/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.db;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.mail.Mail;
import com.iizix.mail.MailSender;
import com.iizix.passwordpolicy.PasswordPolicy;
import com.iizix.server.ServerShell;
import com.iizix.server.db.DBUtilities;
import com.iizix.server.db.GroupInfo;
import com.iizix.server.user.UserAuthentication;
import com.iizix.user.IBasicUserInfoDetailNames;
import com.iizix.user.UserInfoBase;
import com.iizix.user.UserLocaleString;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BasicUserInfo
extends UserInfoBase
implements IBasicUserInfoDetailNames {
    private String a;
    private boolean a;
    private long a;
    private long b;
    private int a;
    private String b;
    public final long refreshTime = System.currentTimeMillis();
    private Map<String, String> a;
    private String c;
    private final ArrayList<Long> a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long[] getUserIDs(Connection connection) throws SQLException {
        long[] lArray;
        ArrayList<Long> arrayList;
        block16: {
            arrayList = new ArrayList<Long>();
            Throwable throwable = null;
            lArray = null;
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT uid FROM IZS.USERS");
                try {
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getLong(1));
                        }
                    }
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (preparedStatement == null) throw throwable;
                    preparedStatement.close();
                    throw throwable;
                }
                preparedStatement.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        int n = arrayList.size();
        lArray = new long[n];
        while (--n >= 0) {
            lArray[n] = (Long)arrayList.get(n);
        }
        return lArray;
    }

    public static BasicUserInfo createNewUser(String string, String string2, boolean bl, String string3, String string4, boolean bl2, Map<String, String> map, String ... stringArray) throws SQLException, NotFoundException {
        Object object;
        Object object2;
        LinkedHashMap<Long, GroupInfo> linkedHashMap = new LinkedHashMap<Long, GroupInfo>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = stringArray2[n2];
            object = GroupInfo.getGroup((String)object2, true);
            if (object == null) {
                throw new NotFoundException("Group \"" + (String)object2 + "\" is not found");
            }
            linkedHashMap.put(object.gid, (GroupInfo)object);
            ++n2;
        }
        object2 = DBUtilities.getPooledConnection();
        try {
            BasicUserInfo basicUserInfo = BasicUserInfo.createNewUser((Connection)object2, string, string2, bl, string3, string4, bl2, map, linkedHashMap.values().toArray(new GroupInfo[linkedHashMap.size()]));
            object2.commit();
            object = basicUserInfo;
            return object;
        }
        catch (SQLException sQLException) {
            try {
                object2.rollback();
            }
            catch (SQLException sQLException2) {
                ILog.SEVERE(BasicUserInfo.class, (String)"Failed rolling back createNewUser", (Throwable)sQLException2);
            }
            throw sQLException;
        }
        finally {
            object2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BasicUserInfo createNewUser(Connection connection, String string, String string2, boolean bl, String string3, String string4, boolean bl2, Map<String, String> map, GroupInfo ... groupInfoArray) throws SQLException, NotFoundException {
        long l;
        Object object;
        Object object2;
        UserAuthentication.validateHashPW(string2);
        string = string.trim();
        String string5 = string.toLowerCase(Locale.ENGLISH);
        long l2 = System.currentTimeMillis();
        long l3 = bl2 ? l2 : 0L;
        Throwable throwable = null;
        ArrayList<Long> arrayList = null;
        try {
            object2 = connection.prepareStatement("INSERT INTO IZS.USERS (user_name,user_name_lower,hash_pw,change_pw,email,lang_codes,created,last_login) VALUES (?,?,?,?,?,?,?,?)", 1);
            try {
                object2.setString(1, string);
                object2.setString(2, string5);
                object2.setString(3, string2);
                object2.setBoolean(4, bl);
                object2.setString(5, string3);
                object2.setString(6, string4);
                object2.setLong(7, l2);
                object2.setLong(8, l3);
                int n = object2.executeUpdate();
                if (n == 0) {
                    throw new SQLException("Failed adding user: no row affected for " + string);
                }
                Throwable object32 = null;
                Iterator<Map.Entry<String, String>> iterator = null;
                try {
                    object = object2.getGeneratedKeys();
                    try {
                        if (!object.next()) {
                            throw new SQLException("Failed adding user: no row affected for " + string);
                        }
                        l = object.getLong(1);
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    void var20_25;
                    if (object32 == null) {
                        Throwable n3 = throwable2;
                    } else if (object32 != throwable2) {
                        object32.addSuppressed(throwable2);
                    }
                    throw var20_25;
                }
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        object = null;
                        Object var23_39 = null;
                        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IZS.USER_DETAILS (uid,detail,value) VALUES (?,?,?)");){
                            String string6 = entry.getValue();
                            if (string6 == null) continue;
                            if (string6.length() > 3000) {
                                string6 = string6.substring(0, 3000);
                            }
                            preparedStatement.setLong(1, l);
                            preparedStatement.setString(2, entry.getKey());
                            preparedStatement.setString(3, string6);
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable3) {
                            if (object == null) {
                                object = throwable3;
                            } else if (object != throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                            throw object;
                        }
                    }
                }
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        int n = groupInfoArray.length;
        arrayList = new ArrayList<Long>(n);
        if (n > 0) {
            void var20_29;
            object2 = "INSERT INTO IZS.USER_GROUPS (uid,gid) VALUES ";
            object = groupInfoArray;
            int n2 = groupInfoArray.length;
            boolean bl3 = false;
            while (var20_29 < n2) {
                GroupInfo groupInfo = object[var20_29];
                long l4 = groupInfo.gid;
                if (!arrayList.isEmpty()) {
                    object2 = (String)object2 + ",";
                }
                object2 = (String)object2 + "(" + l + "," + l4 + ")";
                arrayList.add(l4);
                ++var20_29;
            }
            Throwable throwable5 = null;
            Object var20_30 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement((String)object2);){
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable4) {
                if (throwable5 == null) {
                    throwable5 = throwable4;
                } else if (throwable5 != throwable4) {
                    throwable5.addSuppressed(throwable4);
                }
                throw throwable5;
            }
        }
        return new BasicUserInfo(l, string, string5, string2, bl, string3, string4, l2, l3, map, arrayList);
    }

    private BasicUserInfo(long l, String string, String string2, String string3, boolean bl, String string4, String string5, long l2, long l3, Map<String, String> map, ArrayList<Long> arrayList) {
        super(l, string, string2, string4, string5, l2);
        this.a = string3;
        this.a = bl;
        this.a = l3;
        this.b = 0L;
        this.a = 0;
        this.b = null;
        this.a = map != null ? new ConcurrentHashMap() : null;
        this.a = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BasicUserInfo newBasicUserInfo(Connection connection, String string, boolean bl) throws SQLException, NotFoundException {
        string = string.trim();
        String string2 = string.toLowerCase(Locale.ENGLISH);
        Object object = "SELECT uid,user_name,user_name_lower,hash_pw,change_pw,email,lang_codes,created,last_login,last_fail,fail_count,disabled FROM IZS.USERS where user_name_lower=? OR user_name=?";
        if (bl) {
            object = (String)object + " FOR UPDATE";
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement((String)object);){
            ResultSet resultSet;
            block15: {
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                Throwable throwable2 = null;
                Object var9_12 = null;
                try {
                    BasicUserInfo basicUserInfo;
                    resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) break block15;
                        long l = resultSet.getLong(1);
                        string = resultSet.getString(2);
                        string2 = resultSet.getString(3);
                        String string3 = resultSet.getString(4);
                        boolean bl2 = resultSet.getBoolean(5);
                        String string4 = resultSet.getString(6);
                        String string5 = resultSet.getString(7);
                        long l2 = resultSet.getLong(8);
                        long l3 = resultSet.getLong(9);
                        long l4 = resultSet.getLong(10);
                        int n = resultSet.getInt(11);
                        String string6 = resultSet.getString(12);
                        ArrayList<Long> arrayList = BasicUserInfo.a(connection, l);
                        Map<String, String> map = BasicUserInfo.a(connection, l, null, true);
                        BasicUserInfo basicUserInfo2 = new BasicUserInfo(l, string, string2, string3, bl2, string4, string5, l2, l3, map, arrayList);
                        basicUserInfo2.b = l4;
                        basicUserInfo2.a = n;
                        basicUserInfo2.b = string6;
                        basicUserInfo = basicUserInfo2;
                        if (resultSet == null) return basicUserInfo;
                    }
                    catch (Throwable throwable3) {
                        if (resultSet == null) throw throwable3;
                        resultSet.close();
                        throw throwable3;
                    }
                    resultSet.close();
                    return basicUserInfo;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            if (resultSet == null) throw new NotFoundException("User name \"" + string + "\" not found");
            resultSet.close();
            throw new NotFoundException("User name \"" + string + "\" not found");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BasicUserInfo newBasicUserInfo(Connection connection, long l) throws SQLException, NotFoundException {
        Throwable throwable = null;
        Object var4_4 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT user_name,user_name_lower,hash_pw,change_pw,email,lang_codes,created,last_login,last_fail,fail_count,disabled FROM IZS.USERS where uid=?");){
            ResultSet resultSet;
            block14: {
                preparedStatement.setLong(1, l);
                Throwable throwable2 = null;
                Object var7_9 = null;
                try {
                    BasicUserInfo basicUserInfo;
                    resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) break block14;
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        boolean bl = resultSet.getBoolean(4);
                        String string4 = resultSet.getString(5);
                        String string5 = resultSet.getString(6);
                        long l2 = resultSet.getLong(7);
                        long l3 = resultSet.getLong(8);
                        long l4 = resultSet.getLong(9);
                        int n = resultSet.getInt(10);
                        String string6 = resultSet.getString(11);
                        ArrayList<Long> arrayList = BasicUserInfo.a(connection, l);
                        Map<String, String> map = BasicUserInfo.a(connection, l, null, true);
                        BasicUserInfo basicUserInfo2 = new BasicUserInfo(l, string, string2, string3, bl, string4, string5, l2, l3, map, arrayList);
                        basicUserInfo2.b = l4;
                        basicUserInfo2.a = n;
                        basicUserInfo2.b = string6;
                        basicUserInfo = basicUserInfo2;
                        if (resultSet == null) return basicUserInfo;
                    }
                    catch (Throwable throwable3) {
                        if (resultSet == null) throw throwable3;
                        resultSet.close();
                        throw throwable3;
                    }
                    resultSet.close();
                    return basicUserInfo;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            if (resultSet == null) throw new NotFoundException("User with Unique ID \"" + l + "\" not found");
            resultSet.close();
            throw new NotFoundException("User with Unique ID \"" + l + "\" not found");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BasicUserInfo newBasicUserInfoFromEmail(Connection connection, String string) throws SQLException, NotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT uid,user_name,user_name_lower,hash_pw,change_pw,email,lang_codes,created,last_login,last_fail,fail_count,disabled FROM IZS.USERS where email=?");){
            ResultSet resultSet;
            block14: {
                preparedStatement.setString(1, string);
                Throwable throwable2 = null;
                Object var6_9 = null;
                try {
                    BasicUserInfo basicUserInfo;
                    resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) break block14;
                        long l = resultSet.getLong(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        boolean bl = resultSet.getBoolean(5);
                        String string5 = resultSet.getString(6);
                        String string6 = resultSet.getString(7);
                        long l2 = resultSet.getLong(8);
                        long l3 = resultSet.getLong(9);
                        long l4 = resultSet.getLong(10);
                        int n = resultSet.getInt(11);
                        String string7 = resultSet.getString(12);
                        ArrayList<Long> arrayList = BasicUserInfo.a(connection, l);
                        Map<String, String> map = BasicUserInfo.a(connection, l, null, true);
                        BasicUserInfo basicUserInfo2 = new BasicUserInfo(l, string2, string3, string4, bl, string5, string6, l2, l3, map, arrayList);
                        basicUserInfo2.b = l4;
                        basicUserInfo2.a = n;
                        basicUserInfo2.b = string7;
                        basicUserInfo = basicUserInfo2;
                        if (resultSet == null) return basicUserInfo;
                    }
                    catch (Throwable throwable3) {
                        if (resultSet == null) throw throwable3;
                        resultSet.close();
                        throw throwable3;
                    }
                    resultSet.close();
                    return basicUserInfo;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            if (resultSet == null) throw new NotFoundException("User with email address \"" + string + "\" not found");
            resultSet.close();
            throw new NotFoundException("User with email address \"" + string + "\" not found");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(((Object)((Object)this)).getClass().getName()).append("[id=").append(this.id).append(",userLower=").append(this.userNameLower).append(",user=").append(this.userName);
        if (this.email != null) {
            stringBuilder.append(",email=").append(this.email);
        }
        if (this.langCodes != null && !this.langCodes.isEmpty()) {
            stringBuilder.append(",langCodes=").append(String.join((CharSequence)",", this.langCodes));
        }
        stringBuilder.append(",refreshTime=").append(Utilities.formatDate((long)this.refreshTime)).append(",created=").append(Utilities.formatDate((long)this.created));
        if (this.a != 0L) {
            stringBuilder.append(",lastLogin=").append(Utilities.formatDate((long)this.a));
        }
        if (this.b != 0L) {
            stringBuilder.append(",lastFail=").append(Utilities.formatDate((long)this.b));
        }
        if (this.a) {
            stringBuilder.append(",changePW");
        }
        if (this.b != null) {
            stringBuilder.append(",disabledReason=").append(this.b);
        }
        return stringBuilder.append(']').toString();
    }

    public String getPasswordHash() {
        return this.a;
    }

    public boolean mustChangePassword() {
        return this.a;
    }

    public UserLocaleString canChangePassword() {
        if (this.a) {
            return null;
        }
        String string = (String)this.a.get("IZS-FixedPassword");
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty() || string.equalsIgnoreCase("false")) {
            return null;
        }
        if (string.equalsIgnoreCase("true")) {
            return UserLocaleString.FixedPassword;
        }
        return UserLocaleString.fromNonNull((String)string);
    }

    public long getLastLogin() {
        return this.a;
    }

    public long getLastFail() {
        return this.b;
    }

    public int getFailCount() {
        return this.a;
    }

    public UserLocaleString getDisabledReason() {
        String string = this.b;
        return string != null ? UserLocaleString.fromNonNull((String)string) : null;
    }

    public synchronized String getUUID() {
        if (this.c == null) {
            String string = "iizi\t" + this.id + "\t" + this.userName + "\t" + this.email;
            this.c = UUID.nameUUIDFromBytes(Utilities.getBytes((String)string)).toString();
        }
        return this.c;
    }

    public boolean needsNewHashedPassword() {
        return !this.a && (this.a > 3 || this.b != null || System.currentTimeMillis() - this.a > 604800000L);
    }

    public void updateSuccessfulLogin(Connection connection, String string) throws SQLException {
        this.updateSuccessfulLogin(connection, string, false);
    }

    public void updateSuccessfulLogin(Connection connection, String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        long l = System.currentTimeMillis();
        if (string != null) {
            preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET hash_pw=?,last_login=" + l + (bl ? ",change_pw=false" : "") + ",last_fail=0,fail_count=0,disabled=NULL WHERE uid=" + this.id);
            preparedStatement.setString(1, string);
        } else {
            preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET last_login=" + l + ",last_fail=0,fail_count=0,disabled=NULL WHERE uid=" + this.id);
        }
        try {
            preparedStatement.executeUpdate();
            if (string != null) {
                this.a = string;
                if (bl) {
                    this.a = false;
                }
            }
        }
        finally {
            preparedStatement.close();
        }
        this.getDetails(connection, false);
        this.b = 0L;
        this.a = 0;
        this.a = l;
    }

    public void updateFailedLogin(Connection connection, String string) throws SQLException, NotFoundException {
        PreparedStatement preparedStatement;
        long l;
        this.b = l = System.currentTimeMillis();
        ++this.a;
        if (string != null) {
            preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET last_fail=?,fail_count=fail_count+1,disabled=? WHERE uid=" + this.id);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            this.b = string;
        } else {
            preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET last_fail=?,fail_count=fail_count+1 WHERE uid=" + this.id);
            preparedStatement.setLong(1, l);
        }
        try {
            int n = preparedStatement.executeUpdate();
            if (n != 1) {
                throw new NotFoundException("User not found");
            }
        }
        finally {
            preparedStatement.close();
        }
    }

    public UserLocaleString changePassword(String string, String string2) throws SQLException, NotFoundException {
        if (string == null) {
            throw new NullPointerException("oldPassword is null");
        }
        if (string2 == null) {
            throw new NullPointerException("password is null");
        }
        UserLocaleString userLocaleString = this.getDisabledReason();
        if (userLocaleString != null) {
            return userLocaleString;
        }
        userLocaleString = this.canChangePassword();
        if (userLocaleString != null) {
            return userLocaleString;
        }
        if (!UserAuthentication.getInstance().isOldPasswordMatching(this, string)) {
            return UserLocaleString.HashedPasswordMismatch;
        }
        String string3 = UserAuthentication.getInstance().createNewPasswordHash(this.userName, string2);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Connection connection = DBUtilities.getPooledConnection();){
            this.updateSuccessfulLogin(connection, string3, true);
            connection.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public UserLocaleString resetPassword(StringBuilder stringBuilder) throws SQLException, NotFoundException {
        block24: {
            UserLocaleString userLocaleString = this.getDisabledReason();
            if (userLocaleString != null) {
                return userLocaleString;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            Connection connection = DBUtilities.getPooledConnection();
            try {
                String string = PasswordPolicy.generateStrongPassword();
                String string2 = UserAuthentication.getInstance().createNewPasswordHash(this.userName, string);
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (PreparedStatement preparedStatement = connection.prepareStatement("UPDATE IZS.USERS SET change_pw=TRUE, hash_pw='" + string2 + "' WHERE uid=" + this.id);){
                    int n = preparedStatement.executeUpdate();
                    if (n != 1) {
                        throw new NotFoundException("User " + this.userName + " not found");
                    }
                    connection.commit();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                this.a = true;
                this.a = string2;
                stringBuilder.setLength(0);
                stringBuilder.append(string);
                if (connection == null) break block24;
            }
            catch (Throwable throwable4) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            connection.close();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<Long> a(Connection connection, long l) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT gid FROM IZS.USER_GROUPS WHERE uid=" + l;
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            try {
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getLong(1));
                    }
                }
                if (preparedStatement == null) return arrayList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            return arrayList;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupInfo[] getGroups(boolean bl) throws NotFoundException, SQLException {
        String string = this.a;
        synchronized (string) {
            int n = ((ArrayList)((Object)this.a)).size();
            if (n == 0) {
                return GroupInfo.a;
            }
            long[] lArray = new long[n];
            while (--n >= 0) {
                lArray[n] = (Long)((ArrayList)((Object)this.a)).get(n);
            }
            return GroupInfo.getGroups(lArray, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addGroups(Connection connection, GroupInfo ... groupInfoArray) throws SQLException {
        int n = 0;
        String string = this.a;
        synchronized (string) {
            GroupInfo[] groupInfoArray2 = groupInfoArray;
            int n2 = groupInfoArray.length;
            int n3 = 0;
            while (n3 < n2) {
                GroupInfo groupInfo = groupInfoArray2[n3];
                long l = groupInfo.gid;
                if (!((ArrayList)((Object)this.a)).contains(l)) {
                    groupInfo.a(connection, this);
                    ((ArrayList)((Object)this.a)).add(l);
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeGroups(Connection connection, GroupInfo ... groupInfoArray) throws SQLException {
        int n = 0;
        String string = this.a;
        synchronized (string) {
            GroupInfo[] groupInfoArray2 = groupInfoArray;
            int n2 = groupInfoArray.length;
            int n3 = 0;
            while (n3 < n2) {
                GroupInfo groupInfo = groupInfoArray2[n3];
                long l = groupInfo.gid;
                if (((ArrayList)((Object)this.a)).remove(l)) {
                    groupInfo.b(connection, this);
                }
                ++n3;
            }
        }
        return n;
    }

    public Map<String, String> getDetails() {
        String string = this.a;
        return string == null || string.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(string));
    }

    public Map<String, String> getDetails(boolean bl) throws SQLException {
        if (!bl) {
            return this.getDetails();
        }
        try (Connection connection = DBUtilities.getPooledConnection();){
            Map<String, String> map = this.getDetails(connection, true);
            connection.commit();
            Map<String, String> map2 = map;
            return map2;
        }
    }

    public synchronized Map<String, String> getDetails(Connection connection, boolean bl) throws SQLException {
        String string = this.a;
        Map<String, String> map = BasicUserInfo.a(connection, this.id, (Map<String, String>)((Object)string), bl);
        if (map != string) {
            this.a = map;
        }
        return map == null || map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    private static Map<String, String> a(Connection connection, long l, Map<String, String> map, boolean bl) throws SQLException {
        if (connection == null || !bl && map != null) {
            return map;
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        preparedStatement.setLong(1, l);
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT detail,value FROM IZS.USER_DETAILS where uid=?");){
            Throwable throwable = null;
            Object var8_8 = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    concurrentHashMap.put(string, string2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return concurrentHashMap;
    }

    public void updateUserDetails(Map<String, String> map) throws SQLException {
        try (Connection connection = DBUtilities.getPooledConnection();){
            try {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.setUserDetail(connection, entry.getKey(), entry.getValue());
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                throw sQLException;
            }
        }
    }

    public String setUserDetail(Connection connection, String string, String string2) throws SQLException {
        if (string == null) {
            throw new NullPointerException("detail is null");
        }
        String string3 = null;
        String string4 = this.a;
        if (string2 == null) {
            Throwable throwable = null;
            Object var8_12 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM IZS.USER_DETAILS WHERE uid=? AND detail=?");){
                preparedStatement.setLong(1, this.id);
                preparedStatement.setString(2, string);
                int n = preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (string4 != null) {
                string3 = (String)string4.remove(string);
            }
        } else {
            block39: {
                if (string2.length() > 3000) {
                    string2 = string2.substring(0, 3000);
                }
                try {
                    int n;
                    PreparedStatement preparedStatement;
                    Throwable throwable = null;
                    Object var8_14 = null;
                    try {
                        preparedStatement = connection.prepareStatement("UPDATE IZS.USER_DETAILS SET value=? where uid=? AND detail=?");
                        try {
                            preparedStatement.setString(1, string2);
                            preparedStatement.setLong(2, this.id);
                            preparedStatement.setString(3, string);
                            n = preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    if (n != 0) break block39;
                    throwable = null;
                    var8_14 = null;
                    try {
                        preparedStatement = connection.prepareStatement("INSERT INTO IZS.USER_DETAILS (uid,detail,value) VALUES (?,?,?)");
                        try {
                            preparedStatement.setLong(1, this.id);
                            preparedStatement.setString(2, string);
                            preparedStatement.setString(3, string2);
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        sQLException.addSuppressed(sQLException2);
                    }
                    throw sQLException;
                }
            }
            if (string4 != null) {
                string3 = string4.put(string, string2);
            }
        }
        return string3;
    }

    public int setEmailVerified(String string) {
        Connection connection = null;
        try {
            connection = DBUtilities.getPooledConnection();
            int n = this.setEmailVerified(connection, string);
            connection.commit();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    ILog.SEVERE(BasicUserInfo.class, (String)"Failed rolling back setEmailVerified", (Throwable)sQLException2);
                }
            }
            ILog.SEVERE(BasicUserInfo.class, (String)("Failed setEmailVerified(" + string + ")"), (Throwable)sQLException);
            return -1;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ILog.SEVERE(BasicUserInfo.class, (String)"Failed closing connection at setEmailVerified", (Throwable)sQLException);
                }
            }
        }
    }

    public int setEmailVerified(Connection connection, String string) throws SQLException {
        Map<String, String> map = this.getDetails(connection, true);
        string = string.toLowerCase(Locale.ENGLISH);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = map.get("IZS-Email");
        boolean bl3 = bl = string2 != null && string2.toLowerCase(Locale.ENGLISH).equals(string);
        if (!bl) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getKey().startsWith("IZS-AdditionalEmail") || !entry.getValue().toLowerCase(Locale.ENGLISH).equals(string)) continue;
                bl = true;
                break;
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string3 = entry.getKey();
            if (!string3.startsWith("IZS-EmailVerify")) continue;
            string2 = entry.getValue();
            int n = string2.indexOf(44);
            int n2 = string2.indexOf(44, n + 1);
            if (n <= 0 || n2 <= 0 || !string2.substring(0, n).toLowerCase(Locale.ENGLISH).equals(string)) continue;
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string2.substring(n + 1, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 >= 3) continue;
            bl2 = true;
            this.setUserDetail(connection, string3, string + ",3," + System.currentTimeMillis());
        }
        return bl && bl2 ? 1 : (bl ? 0 : -1);
    }

    public List<String> getMailsToVerify() {
        Map.Entry<String, String> entry2;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Map<String, String> map = this.getDetails();
        String string = map.get("IZS-Email");
        if (string != null && !(string = string.trim()).isEmpty()) {
            hashSet.add(string.toLowerCase(Locale.ENGLISH));
        }
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            String string2 = entry2.getKey();
            if (string2.startsWith("IZS-AdditionalEmail")) {
                string = ((String)entry2.getValue()).trim();
                if (string.isEmpty()) continue;
                hashSet.add(string.toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (!string2.startsWith("IZS-EmailVerify")) continue;
            string = (String)entry2.getValue();
            int n = string.indexOf(44);
            int n2 = string.indexOf(44, n + 1);
            if (n <= 0 || n2 <= 0) continue;
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string.substring(n + 1, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 >= 3) continue;
            hashSet2.add(string.substring(0, n).trim().toLowerCase(Locale.ENGLISH));
        }
        hashSet2.retainAll(hashSet);
        if (hashSet2.isEmpty()) {
            return Collections.emptyList();
        }
        entry2 = new ArrayList(hashSet2);
        entry2.sort(Collator.getInstance(Locale.ENGLISH));
        return entry2;
    }

    public int sendMailsToUnverifiedMailAddresses(List<String> list, MailSender mailSender, String string, String string2, String string3, String string4, String string5) throws NotFoundException, IOException, IllegalStateException, MessagingException {
        if (list == null) {
            list = this.getMailsToVerify();
        }
        if (list.isEmpty()) {
            return 0;
        }
        ServerShell serverShell = ServerShell.getInstance();
        if (serverShell == null) {
            throw new IllegalStateException("Server is not started");
        }
        if (string5 == null && (string5 = serverShell.getExternalWebServerBaseURL()) == null) {
            throw new NotFoundException("Failed getting external web server base URL");
        }
        if (mailSender == null && (mailSender = serverShell.getDefaultMailSender()) == null) {
            throw new NotFoundException("Failed getting default mail sender, server is not configured for one");
        }
        for (String string6 : list) {
            String string7 = serverShell.getEmailVerificationURL(this, string6, string5);
            String string8 = string.replace("${email}", string6);
            String string9 = string4.replace("${email}", string6).replace("${url}", string7);
            Mail mail = mailSender.createMail();
            mail.setSubject(string8);
            mail.setFrom(string2);
            mail.addDestination(string6);
            if (string3 != null) {
                mail.addBCC(string3);
            }
            mail.setText(string9);
            mail.queue();
        }
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferEmailDetails(Map<String, Object> map) {
        Object object2;
        Map.Entry entry22;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string = this.a;
        int n = 0;
        if (string != null) {
            entry22 = string;
            synchronized (entry22) {
                object2 = (String)this.a.get("IZS-Email");
                if (object2 != null) {
                    linkedHashMap.put("IZS-Email", (String)object2);
                }
                for (Map.Entry object3 : string.entrySet()) {
                    String string2 = (String)object3.getKey();
                    if (!string2.startsWith("IZS-AdditionalEmail") && !string2.startsWith("IZS-EmailVerify")) continue;
                    linkedHashMap.put(string2, (String)object3.getValue());
                }
            }
            for (Map.Entry entry22 : linkedHashMap.entrySet()) {
                Object v = entry22.getValue();
                if (v.equals(map.put((String)entry22.getKey(), v))) continue;
                ++n;
            }
        }
        if (!linkedHashMap.containsKey("IZS-Email") && map.remove("IZS-Email") != null) {
            ++n;
        }
        entry22 = map.entrySet().iterator();
        while (entry22.hasNext()) {
            object2 = (Map.Entry)entry22.next();
            String string3 = (String)object2.getKey();
            if (!string3.startsWith("IZS-AdditionalEmail") && !string3.startsWith("IZS-EmailVerify") || linkedHashMap.containsKey(string3)) continue;
            entry22.remove();
            ++n;
        }
        return n;
    }
}

