/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAmountValue;
import java.text.ParseException;
import java.time.Duration;
import java.time.format.DateTimeParseException;

public class DurationValue
extends TermporalAmountValue<Duration> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.Duration;
    }

    @Override
    public Class<Duration> getValueClass() {
        return Duration.class;
    }

    @Override
    public String getDescription() {
        return "Time-based amount of time with nanosecond precision, such as 34.5 seconds";
    }

    @Override
    public Duration createDefault() {
        return Duration.ZERO;
    }

    @Override
    public Duration parse(String string) throws ParseException, IllegalArgumentException, Exception {
        try {
            return Duration.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public Duration convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Duration) {
            return (Duration)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            return Duration.ofMillis(l3);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return Duration.ofMillis(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Duration.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(Duration duration, LocaleInfo localeInfo) {
        try {
            return duration.toMillis();
        }
        catch (ArithmeticException arithmeticException) {
            return Long.MIN_VALUE;
        }
    }
}

