/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.mlist;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.Value;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.mlist.IMLArrowActionListener;
import com.iizix.prop.ui.mlist.IMLRadioButtonStateListener;
import com.iizix.prop.ui.mlist.IMListContentProvider;
import com.iizix.prop.ui.mlist.MLGroup;
import com.iizix.prop.ui.mlist.MLItem;
import com.iizix.prop.ui.mlist.MLItemProp;
import com.iizix.prop.ui.mlist.MLItemType;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSRow;
import com.iizix.text.KString;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MLRadioButton
extends MLItem
implements IMLArrowActionListener {
    public static final String PN_TRAILING_TEXT = "tt";
    public static final String PN_V_TRAILING_TEXT = "V_tt";
    public static final String PN_ALIGN_OPPOSITE = "ao";
    public static final String PN_ARROW = "arrow";
    static Object[] a = new Object[]{"V_$text", Atom.VSCOLUMN, "V_tt", "V_$descr"};
    static Value.Type[] a = new Value.Type[]{Value.Type.KString, Value.Type.Boolean, Value.Type.KString, Value.Type.KString};
    private static final String[] a = new String[]{"selected"};
    private KString b;
    private boolean a;
    private boolean b;
    private GenericListener<IMLRadioButtonStateListener> a;
    private GenericListener<IMLArrowActionListener> b;
    private VSField a;

    public MLRadioButton(boolean bl) {
        this.a = (Object[])(bl ? 1 : 0);
    }

    public MLRadioButton(int n2) {
        if (n2 == 0 || n2 == 1) {
            throw new IllegalArgumentException("state must be 0 or 1");
        }
        this.a = (Object[])n2;
    }

    MLRadioButton(IMListContentProvider iMListContentProvider, VSRow vSRow) {
        super(iMListContentProvider, vSRow);
    }

    @Override
    protected String getSelectionPropName() {
        return "selected";
    }

    @Override
    public MLItemType getType() {
        return MLItemType.RADIO_BUTTON;
    }

    @Override
    protected int getLeadingTextColumn() {
        return 0;
    }

    @Override
    protected int getDescriptionColumn() {
        return 3;
    }

    @Override
    public void refreshFromVS(int[] nArray) {
        if (this.a(nArray)) {
            VSField vSField;
            PropCnr propCnr;
            int n2 = nArray[1];
            if (n2 >= 0 && (propCnr = this.getItemProp()) != null && (vSField = this.a.getField(n2)) != null && !vSField.isDisposed()) {
                this.a = vSField;
                this.a = (Object[])(vSField.convertEqualsValue(null, ((UIComp)propCnr).getValue("selValue")) == 0 || propCnr.getBool("selNoMatch") ? 1 : 0);
                this.setSelection(this.a == true);
            }
            if ((n2 = nArray[2]) >= 0 && (propCnr = this.a.getField(n2)) != null) {
                this.b = ((VSField)propCnr).get_KString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(MLItemProp mLItemProp) {
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        KString kString;
        this.a(mLItemProp);
        VSField vSField = mLItemProp.getVSField();
        if (vSField != null && !vSField.isDisposed()) {
            this.a = vSField;
        }
        MLRadioButton mLRadioButton = this;
        synchronized (mLRadioButton) {
            kString = this.b;
            bl3 = this.a ? Boolean.TRUE : null;
            bl2 = this.b ? Boolean.TRUE : null;
            bl = this.a == true;
        }
        mLItemProp.setPropValue(Atom.TYPE, Integer.valueOf(MLItemType.RADIO_BUTTON.type), IntProp.class);
        mLItemProp.setPropValue(PN_TRAILING_TEXT, kString, KStringProp.class);
        mLItemProp.setPropValue(PN_ALIGN_OPPOSITE, bl3, BoolProp.class);
        mLItemProp.setPropValue(PN_ARROW, bl2, BoolProp.class);
        mLItemProp.setPropValue("selected", bl, BoolProp.class);
    }

    @Override
    protected String[] getUpdatePropertyNames() {
        return a;
    }

    @Override
    void a(PropCnr propCnr, MLItemProp mLItemProp) {
        this.b(propCnr, mLItemProp);
        this.b = propCnr.getPropValue(PN_TRAILING_TEXT, KString.class);
        this.a = propCnr.getBool(PN_ALIGN_OPPOSITE, false);
        this.b = propCnr.getBool(PN_ARROW, false);
        this.setSelected(propCnr.getBool("selected") ? 1 : 0);
        this.b(mLItemProp);
    }

    public KString getTrailingText() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTrailingText(KString kString) {
        boolean bl;
        MLItemProp mLItemProp;
        MLRadioButton mLRadioButton = this;
        synchronized (mLRadioButton) {
            block5: {
                mLItemProp = this.getItemProp();
                boolean bl2 = mLItemProp == null && (kString != null ? kString.equals(this.b) : this.b == null) ? false : (bl = true);
                if (bl) break block5;
                return false;
            }
            this.b = kString;
        }
        if (mLItemProp != null && !mLItemProp.isDisposed()) {
            bl = mLItemProp.setPropValue(PN_TRAILING_TEXT, kString, KStringProp.class);
        }
        return bl;
    }

    public boolean isTrailingTextOppositeAligned() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrailingTextOppositeAligned(boolean bl) {
        boolean bl2;
        MLItemProp mLItemProp;
        MLRadioButton mLRadioButton = this;
        synchronized (mLRadioButton) {
            block5: {
                mLItemProp = this.getItemProp();
                boolean bl3 = bl2 = mLItemProp != null || bl != this.a;
                if (bl2) break block5;
                return false;
            }
            this.a = bl;
        }
        if (mLItemProp != null && !mLItemProp.isDisposed()) {
            bl2 = mLItemProp.setPropValue(PN_ALIGN_OPPOSITE, this.a ? Boolean.TRUE : null, BoolProp.class);
        }
        return bl2;
    }

    public boolean isArrowDisplayed() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setArrowDisplayed(boolean bl) {
        boolean bl2;
        MLItemProp mLItemProp;
        MLRadioButton mLRadioButton = this;
        synchronized (mLRadioButton) {
            block5: {
                mLItemProp = this.getItemProp();
                boolean bl3 = bl2 = mLItemProp != null || bl != this.b;
                if (bl2) break block5;
                return false;
            }
            this.b = bl;
        }
        if (mLItemProp != null && !mLItemProp.isDisposed()) {
            bl2 = mLItemProp.setPropValue(PN_ARROW, bl ? Boolean.TRUE : null, BoolProp.class);
        }
        return bl2;
    }

    private void b(MLItemProp mLItemProp) {
        VSField vSField = mLItemProp.getVSField();
        if (vSField != null && mLItemProp.isSelected() && mLItemProp.enterVSProcessing(vSField)) {
            try {
                Value value = mLItemProp.getValue("selValue");
                if (value == null) {
                    ILog.SEVERE(mLItemProp.getClass(), "Radio component does not have the Selection value defined", (Object)("Component " + mLItemProp.getReferencePropName() + ": " + String.valueOf(mLItemProp)));
                    return;
                }
                try {
                    vSField.setValue(value, true, mLItemProp);
                    mLItemProp.setVSFieldMessageToComponent(vSField, true);
                }
                catch (ValueConversionException valueConversionException) {
                    mLItemProp.setErrorMessage(valueConversionException);
                }
            }
            finally {
                mLItemProp.exitVSProcessing();
            }
        }
    }

    @Override
    void a(MLItemProp mLItemProp, VSField vSField, Value value, IPostEventProcessing iPostEventProcessing) {
        if (vSField == mLItemProp.getVSField() && mLItemProp.enterVSProcessing(vSField)) {
            try {
                boolean bl;
                Value value2 = mLItemProp.getValue("selValue");
                if (value2 != null && vSField.convertEqualsValue(mLItemProp, value2) >= 0) {
                    bl = true;
                } else {
                    bl = mLItemProp.getBool("selNoMatch");
                    if (bl) {
                        iPostEventProcessing.addPostProcessor(gEvent -> {
                            MLGroup mLGroup = this.getGroup();
                            if (mLGroup != null) {
                                MLItemProp[] mLItemPropArray = (MLItemProp[])mLGroup.getItems();
                                int n2 = mLItemPropArray.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    MLItemProp mLItemProp = mLItemPropArray[n3];
                                    if (mLItemProp.getType() == MLItemType.RADIO_BUTTON && mLItemProp.isSelected()) {
                                        return;
                                    }
                                    ++n3;
                                }
                                this.setSelection(true);
                            }
                        });
                        return;
                    }
                }
                this.setSelection(bl);
            }
            finally {
                mLItemProp.exitVSProcessing();
            }
        }
    }

    public synchronized boolean addListener(IMLRadioButtonStateListener iMLRadioButtonStateListener) {
        if (this.a == null) {
            this.a = new GenericListener<IMLRadioButtonStateListener>(IMLRadioButtonStateListener.class);
        }
        return this.a.addListener(iMLRadioButtonStateListener);
    }

    public synchronized boolean removeListener(IMLRadioButtonStateListener iMLRadioButtonStateListener) {
        return this.a != null ? this.a.removeListener(iMLRadioButtonStateListener) : false;
    }

    @Override
    void a(int n2) {
        Object object;
        MLItemProp mLItemProp = this.getItemProp();
        if (mLItemProp != null && (this.a = mLItemProp.getVSField()) != null && n2 == 1) {
            try {
                object = mLItemProp.getValue("selValue");
                if (object == null) {
                    ILog.SEVERE(mLItemProp.getFullPropName(), (Object)"Radio component does not have the Selection value defined");
                    return;
                }
                this.a.setValue(object, true);
            }
            catch (ValueConversionException valueConversionException) {
                ILog.WARNING(this.getClass(), "Wrong field type for radio button: " + String.valueOf(this));
            }
        }
        if ((object = this.a) != null) {
            object.forEach(iMLRadioButtonStateListener -> iMLRadioButtonStateListener.onSelectionStateChanged(this, n2 == 1));
        }
    }

    public synchronized boolean addListener(IMLArrowActionListener iMLArrowActionListener) {
        if (this.b == null) {
            this.b = new GenericListener<IMLArrowActionListener>(IMLArrowActionListener.class);
        }
        return ((GenericListener)((Object)this.b)).addListener(iMLArrowActionListener);
    }

    public synchronized boolean removeListener(IMLArrowActionListener iMLArrowActionListener) {
        return this.b != null ? ((GenericListener)((Object)this.b)).removeListener(iMLArrowActionListener) : false;
    }

    @Override
    public void onArrowInvoked(MLItem mLItem) {
        KString kString = this.b;
        if (kString != null) {
            ((GenericListener)((Object)kString)).forEach(iMLArrowActionListener -> iMLArrowActionListener.onArrowInvoked(mLItem));
        }
    }
}

