/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.SendTransaction;
import com.iizix.prop.AbstractStyles;
import com.iizix.prop.Atom;
import com.iizix.prop.ColorProp;
import com.iizix.prop.GColor;
import com.iizix.prop.GGradient;
import com.iizix.prop.GradientProp;
import com.iizix.prop.IPropMgrInfoProvider;
import com.iizix.prop.ImageReference;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropMgr;
import com.iizix.prop.ReferenceString;
import com.iizix.prop.font.FontConsumed;
import com.iizix.prop.font.IFontConsumer;
import com.iizix.prop.image.IImageTarget;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Styles
extends AbstractStyles
implements IFontConsumer {
    protected static final String[] SUBNAMES_LOCATION = new String[]{"Top", "Right", "Bottom", "Left"};
    protected static final String[] SUBNAMES_CORNER = new String[]{"Top-Left", "Top-Right", "Bottom-Right", "Bottom-Left"};
    protected static final String[] TEXT_ALIGNS = new String[]{"left", "center", "right", "justify"};
    protected static final String[] TEXT_DECORATIONS = new String[]{"none", "underline", "overline", "line-through", "inherit"};
    protected static final String[] TEXT_TRANSFORMS = new String[]{"none", "capitalize", "uppercase", "lowercase", "inherit"};
    protected static final String[] WORD_BREAKS = new String[]{"normal", "break-all", "keep-all", "inherit"};
    protected static final String[] LINE_STYLES = new String[]{"none", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", "inherit"};
    protected static final String[] BACKGROUND_BOX = new String[]{"border-box", "content-box", "padding-box", "inherit"};
    protected static final String[] BACKGROUND_REPEAT = new String[]{"repeat", "repeat-x", "repeat-y", "no-repeat", "inherit"};
    protected static final String[] BACKGROUND_SCROLL = new String[]{"scroll", "fixed", "local", "inherit"};
    protected static final String[] LIST_TYPES = new String[]{"none", "armenian", "circle", "cjk-ideographic", "decimal", "decimal-leading-zero", "disc", "georgian", "hebrew", "hiragana", "hiragana-iroha", "inherit", "katakana", "katakana-iroha", "lower-alpha", "lower-greek", "lower-latin", "lower-roman", "square", "upper-alpha", "upper-latin", "upper-roman"};
    protected static final String[] LIST_POSITIONS = new String[]{"inside", "outside", "inherit"};
    protected static final String[] BOX_SIZINGS = new String[]{"content-box", "border-box", "inherit"};
    protected static final String[] FONT_WEIGHTS = new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900", "initial", "inherit"};
    protected static final String[] FONT_STYLES = new String[]{"normal", "italic", "oblique", "initial", "inherit"};
    public static final Styles[] EMPTY = new Styles[0];
    private static Atom a = Atom.get("backgroundImage");
    private static final Class<?>[] a;

    static {
        a = new Class[]{Styles.class};
    }

    protected Styles() {
    }

    public Styles(Atom atom) {
        super(atom);
    }

    @Override
    public Class<?>[] getExtendsPossibleClasses() {
        return a;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        String string = this.getString("fontFamily");
        if (string != null && !string.isEmpty()) {
            IPropMgrInfoProvider iPropMgrInfoProvider = propMgr.getProvider();
            int n2 = string.indexOf(44);
            if (n2 < 0) {
                iPropMgrInfoProvider.installFont(string);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    iPropMgrInfoProvider.installFont(string2);
                }
            }
        }
        super.appendPropValue(propMgr, sendTransaction, object);
    }

    public String getFontFamily() {
        return this.getString("fontFamily");
    }

    public String getFontStyle() {
        int n2 = this.getInt("fontStyle", -1);
        return n2 >= 0 && n2 < FONT_STYLES.length - 2 ? FONT_STYLES[n2] : null;
    }

    public String getFontWeight() {
        int n2 = this.getInt("fontWeight", -1);
        return n2 >= 0 && n2 < FONT_WEIGHTS.length - 2 ? FONT_WEIGHTS[n2] : null;
    }

    @Override
    public void collectConsumedFonts(Set<FontConsumed> set) {
        String string = this.getString("fontFamily");
        if (string != null && !string.isEmpty()) {
            set.add(new FontConsumed(string, this.getFontStyle(), this.getFontWeight()));
        }
    }

    public boolean isStateStyles() {
        return this.getParent() instanceof Styles;
    }

    public Styles getMainStyles() {
        PropCnr propCnr = this.getParent();
        return propCnr instanceof Styles ? (Styles)propCnr : this;
    }

    public int getStateMask() {
        return this.getInt("states", -1);
    }

    public GColor getBackgroundColor() {
        return this.getPropValue("backgroundColor", GColor.class);
    }

    public boolean setBackgroundColor(GColor gColor) {
        return this.setPropValue("backgroundColor", gColor, ColorProp.class);
    }

    public GGradient getBackgroundGradient() {
        return this.getPropValue("backgroundColor", GGradient.class);
    }

    public boolean setBackgroundGradient(GGradient gGradient) {
        return this.setPropValue("backgroundColor", gGradient, GradientProp.class);
    }

    public GColor getColor() {
        return this.getPropValue("color", GColor.class);
    }

    public boolean setColor(GColor gColor) {
        return this.setPropValue("color", gColor, ColorProp.class);
    }

    public IImageTarget getBackgroundImage() {
        ImageReference imageReference = this.getProp("backgroundImage", ImageReference.class);
        return imageReference != null ? (IImageTarget)imageReference.getTargetReference() : null;
    }

    public boolean setBackgroundImage(IImageTarget iImageTarget) {
        boolean bl;
        if (iImageTarget == null) {
            bl = this.removeProp2(a);
        } else {
            bl = this.setPropValue(a, new ReferenceString(iImageTarget.getReferencePropName()), ImageReference.class);
            ImageReference imageReference = this.getProp(Atom.ICON, ImageReference.class);
            if (imageReference != null) {
                imageReference.setImage(iImageTarget);
            }
        }
        return bl;
    }
}

