/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;

public class PolicyProps
extends PropCnr {
    public static final String PN_ADMIN = "$admin";
    public static final String PN_USER = "$user";
    public static final Atom AN_ADMIN = Atom.get("$admin");
    public static final Atom AN_USER = Atom.USER;
    public static final String PN_MIN_LENGTH = "minLength";
    public static final String PN_HAS_DIGIT = "hasDigit";
    public static final String PN_HAS_Q_SYMBOL = "hasQSymbol";
    public static final String PN_HAS_UPPER_AND_LOWER = "hasUpperLower";
    public static final String PN_HAS_ADVANCED_ENTROPY = "advanced";
    public static final String PN_HISTORY_LENGTH = "history";
    public static final String PN_CHANGE_AT_NEXT_LOGIN = "mustChange";
    public static final String PN_NO_CHANGES = "noChanges";

    public PolicyProps() {
    }

    public PolicyProps(Atom atom) {
        super(atom);
    }

    @Override
    public PolicyProps clone() {
        try {
            PolicyProps policyProps = (PolicyProps)super.clone();
            return policyProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getDescription() {
        String string = this.getString(Atom.DESCR);
        return string != null ? string : (this.isAdminPolicy() ? "Administator's password policy" : "User's password policy");
    }

    public boolean isAdminPolicy() {
        return PN_ADMIN.equals(this.getPropName());
    }

    public int getPasswordMinLength() {
        int n2 = this.getInt(PN_MIN_LENGTH, 0);
        if (n2 < 4) {
            n2 = this.isAdminPolicy() ? 8 : 6;
        }
        return n2;
    }

    public boolean requiresPasswordDigit() {
        return this.getBool(PN_HAS_DIGIT, this.isAdminPolicy());
    }

    public boolean requiresPasswordQSymbol() {
        return this.getBool(PN_HAS_Q_SYMBOL, this.isAdminPolicy());
    }

    public boolean requiresPasswordUpperLower() {
        return this.getBool(PN_HAS_UPPER_AND_LOWER, this.isAdminPolicy());
    }

    public boolean setRequireAdvancedEntropyChecking(boolean bl) {
        return this.getBool(PN_HAS_ADVANCED_ENTROPY, bl);
    }

    public boolean requiredAdvancedEntropyChecking() {
        return this.getBool(PN_HAS_ADVANCED_ENTROPY, false);
    }

    public int getPasswordHistoryLength() {
        int n2 = this.getInt(PN_HISTORY_LENGTH, -1);
        if (n2 < 0) {
            n2 = this.isAdminPolicy() ? 8 : 0;
        }
        return n2;
    }

    public boolean canChangePassword() {
        return !this.getBool(PN_NO_CHANGES);
    }

    public boolean mustChangePassword() {
        return this.getBool(PN_CHANGE_AT_NEXT_LOGIN);
    }
}

