/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.LanguageException;
import com.iizix.comm.ITransactionCreator;
import com.iizix.comm.ITransactionSender;
import com.iizix.gyro.IAppSessionFocusProvider;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.AbstractReference;
import com.iizix.prop.AppLanguages;
import com.iizix.prop.Atom;
import com.iizix.prop.CSSAssetReferences;
import com.iizix.prop.CSSResourceFilePreload;
import com.iizix.prop.ClassReference;
import com.iizix.prop.EnvProps;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.GColor;
import com.iizix.prop.GProp;
import com.iizix.prop.IClassInstantiationAtResolve;
import com.iizix.prop.IClientCachePreload;
import com.iizix.prop.IClientCacheResource;
import com.iizix.prop.IPropMgrInfoProvider;
import com.iizix.prop.ImageReference;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PreloadClientCacheResource;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.SelectorReference;
import com.iizix.prop.StringProp;
import com.iizix.prop.TextTable;
import com.iizix.prop.TextTableReference;
import com.iizix.prop.image.ClientImageData;
import com.iizix.prop.image.IImageTarget;
import com.iizix.prop.image.SVGDefinition;
import com.iizix.prop.ui.device.GThemes;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSFocusReference;
import com.iizix.prop.vs.VSReference;
import com.iizix.text.KString;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ModuleApp
extends PropCnr
implements IClassInstantiationAtResolve,
IClientCachePreload,
IClientCacheResource {
    public static final String PN_ICON_BITMAP = "iconBitmap";
    public static final String PN_ICON_SVG = "iconSVG";
    public static final String PN_ICON_BACKGROUND = "iconBG";
    public static final String PN_TILE_COLOR = "tileColor";
    public static final String PN_THEME_COLOR = "themeColor";
    public static final String PN_CSS_ASSETS = "cssAssets";
    public static final String PN_IIZIRUN_PHONE = "izrPhone";
    public static final String PN_IIZIRUN_TABLET = "izrTablet";
    public static final String PN_IIZIAPP_BROWSER = "izaBrowser";
    private AppLanguages a;
    private GThemes a;

    public ModuleApp() {
    }

    public ModuleApp(Atom atom) {
        super(atom);
    }

    @Override
    protected void addPredefinedProps() throws PropException {
        this.a = this.maybeAddProp(new AppLanguages(Atom.LANG));
    }

    @Override
    protected void getPredefinedProps() {
        this.a = this.getProp(Atom.LANG, AppLanguages.class);
    }

    @Override
    public ModuleApp clone() {
        try {
            ModuleApp moduleApp = (ModuleApp)super.clone();
            return moduleApp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(String string) {
        KString kString = this.getNameKString();
        if (kString == null) {
            return null;
        }
        TextTable textTable = this.getTextTable();
        return textTable != null ? kString.getPLAINString(textTable, string) : kString.getPLAINString(null);
    }

    public KString getNameKString() {
        return this.getPropValue(Atom.NAME, KString.class);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String string) {
        KString kString = this.getDescriptionKString();
        if (kString == null) {
            return null;
        }
        TextTable textTable = this.getTextTable();
        return textTable != null ? kString.getPLAINString(textTable, string) : kString.getPLAINString(null);
    }

    public KString getDescriptionKString() {
        return this.getPropValue(Atom.DESCR, KString.class);
    }

    public TextTable getTextTable() {
        TextTableReference textTableReference = this.getProp("defaultTextTable", TextTableReference.class);
        return textTableReference != null ? (TextTable)textTableReference.getTargetReference() : null;
    }

    public TextTable getTextTable(String string) throws LanguageException {
        TextTable textTable = this.getTextTable();
        if (string == null) {
            return textTable;
        }
        AppLanguages.Result result = this.a.mapLanguage(string);
        if (result.isUnknownLanguage) {
            throw new LanguageException("Application undefined " + String.valueOf(result), string);
        }
        if ((textTable = textTable.getDerivedTextTableRecursive(string)) == null) {
            throw new LanguageException("Text table for language code is not found: " + String.valueOf(result), string);
        }
        return textTable;
    }

    public boolean isAppLocalized() {
        return this.getBool("localized");
    }

    @Override
    public VSReference getVSReference(Atom atom) {
        return this.getProp(Atom.VIRTUALSPACE, VSReference.class);
    }

    @Override
    public VSReference createVSReference(Atom atom, PropCnr[] propCnrArray) {
        propCnrArray[0] = this;
        return new VSReference(Atom.VIRTUALSPACE);
    }

    public VSComponent getInitialVSComponent() {
        VSFocusReference vSFocusReference = this.getProp("vsComp", VSFocusReference.class);
        return vSFocusReference != null ? (VSComponent)vSFocusReference.getVSTarget() : null;
    }

    public IAppSessionFocusProvider getAppSessionFocusProvider() {
        ClassReference classReference = this.getProp("vsFocusProvider", ClassReference.class);
        return classReference != null ? classReference.getRuntimeInstance(IAppSessionFocusProvider.class) : null;
    }

    public SelectorReference getSelectorReference() {
        return this.getProp(Atom.SELECTOR, SelectorReference.class);
    }

    public boolean isSelectorSelected(EnvProps envProps) {
        SelectorReference selectorReference = this.getSelectorReference();
        return selectorReference == null || selectorReference.isSelectorSelected(envProps);
    }

    public AppLanguages getConfiguredLanguages() {
        return this.a;
    }

    public void invalidatePossibleThemes() {
        this.a = null;
    }

    public GThemes computePossibleThemes() {
        if (this.a == null) {
            this.a = GThemes.DEFAULT_MASK;
        }
        return this.a;
    }

    public GThemes getDefaultThemes() {
        GThemes gThemes = this.getPropValue("defaultThemes", GThemes.class);
        return gThemes != null ? gThemes : GThemes.DEFAULT_STARTUP;
    }

    public GThemes getApplicationThemes() {
        GThemes gThemes = this.getPropValue("appThemes", GThemes.class);
        return gThemes != null ? gThemes : GThemes.DEFAULT_MASK;
    }

    public ImageReference getIconBitmapReference() {
        return this.getProp(PN_ICON_BITMAP, ImageReference.class);
    }

    public IImageTarget getIconBitmap() {
        ImageReference imageReference = this.getIconBitmapReference();
        if (imageReference == null) {
            return null;
        }
        IImageTarget iImageTarget = (IImageTarget)imageReference.getTargetReference();
        if (iImageTarget == null) {
            return null;
        }
        ClientImageData clientImageData = iImageTarget.getClientImageData();
        if (clientImageData == null) {
            this.warning("App icon bitmap image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" is unresolved: no ClientImageData");
            return null;
        }
        String string = clientImageData.getDefaultResource();
        if (string == null) {
            this.warning("App icon bitmap image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" is unresolved: resource is unresolved");
            return null;
        }
        if (!clientImageData.isBitmap() || clientImageData.isMulti) {
            this.warning("App icon bitmap image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" is not a single bitmap, resource: \"" + string + "\"");
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (!(string2.endsWith(".png") || string2.endsWith(".jpg") || string2.endsWith(".jpeg"))) {
            this.warning("App icon bitmap image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" resource \"" + string + "\" does not have a PNG, JPG or JPEG file extension");
            return null;
        }
        int n2 = clientImageData.width;
        int n3 = clientImageData.height;
        if (n2 < 0 || n3 < 0 || n2 != n3) {
            this.warning("App icon bitmap image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" is not a square image: width=" + n2 + ", height=" + n3 + ", resource \"" + string + "\"");
            return null;
        }
        return iImageTarget;
    }

    public ImageReference getIconSVGReference() {
        return this.getProp(PN_ICON_SVG, ImageReference.class);
    }

    public IImageTarget getIconSVG() {
        ImageReference imageReference = this.getIconSVGReference();
        if (imageReference == null) {
            return null;
        }
        IImageTarget iImageTarget = (IImageTarget)imageReference.getTargetReference();
        if (iImageTarget == null) {
            return null;
        }
        ClientImageData clientImageData = iImageTarget.getClientImageData();
        if (clientImageData == null || !clientImageData.isSVG()) {
            String string = clientImageData == null ? "<null = no ClientImageData>" : clientImageData.getDefaultResource();
            this.warning("App icon SVG image reference \"" + String.valueOf(imageReference.getReferenceString()) + "\" is not an SVG, resource \"" + string + "\"");
            return null;
        }
        return iImageTarget;
    }

    public GColor getIconBackgroundColor() {
        return this.getPropValue(PN_ICON_BACKGROUND, GColor.class);
    }

    public GColor getTileColor() {
        return this.getPropValue(PN_TILE_COLOR, GColor.class);
    }

    public GColor getThemeColor() {
        return this.getPropValue(PN_THEME_COLOR, GColor.class);
    }

    public CSSAssetReferences getCSSAssetReferences() {
        return this.getProp(PN_CSS_ASSETS, CSSAssetReferences.class);
    }

    public void sendCustomCSS(IPropMgrInfoProvider iPropMgrInfoProvider, ITransactionCreator iTransactionCreator, ITransactionSender iTransactionSender) {
        CSSAssetReferences cSSAssetReferences = this.getCSSAssetReferences();
        if (cSSAssetReferences != null) {
            cSSAssetReferences.sendCustomCSS(this.getCacheOperation(), iPropMgrInfoProvider, iTransactionCreator, iTransactionSender);
        }
    }

    public int getCacheOperation() {
        return this.getInt(Atom.CACHE, 1);
    }

    @Override
    public boolean isCachedOnClient() {
        return this.getCacheOperation() > 0;
    }

    @Override
    public boolean isCachePreloaded() {
        return this.getCacheOperation() == 2;
    }

    @Override
    public PreloadClientCacheResource[] getPreloadClientCacheResources(IClientSessionGyro iClientSessionGyro) {
        Set<FileURIPropCnr> set;
        CSSAssetReferences cSSAssetReferences;
        if (this.isCachePreloaded() && (cSSAssetReferences = this.getCSSAssetReferences()) != null && (set = cSSAssetReferences.getDirectReferencedTargetFiles()) != null && !set.isEmpty()) {
            ArrayList<CSSResourceFilePreload> arrayList = new ArrayList<CSSResourceFilePreload>();
            for (FileURIPropCnr fileURIPropCnr : set) {
                if (fileURIPropCnr.getSize() < 0L || fileURIPropCnr.getModificationTime() <= 0L) continue;
                String string = fileURIPropCnr.getReferencePropName().replace(':', '$');
                arrayList.add(new CSSResourceFilePreload(cSSAssetReferences, fileURIPropCnr, string));
            }
            if (!arrayList.isEmpty()) {
                return arrayList.toArray(new PreloadClientCacheResource[arrayList.size()]);
            }
        }
        return PreloadClientCacheResource.EMPTY;
    }

    public boolean isAvailableForPhones() {
        return this.getBool(PN_IIZIRUN_PHONE, true);
    }

    public boolean isAvailableForTablets() {
        return this.getBool(PN_IIZIRUN_PHONE, true);
    }

    public boolean isAvailableForBrowsers() {
        return this.getBool(PN_IIZIAPP_BROWSER, true);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        Object object;
        Object object2;
        IImageTarget iImageTarget;
        Object object3;
        KStringProp kStringProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        if (this.getProp("appID", StringProp.class) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "appID", PropVerificationError.Severity.WARNING, "App ID", "The App ID must be specified", new String[0]));
        }
        if (this.getProp("version", StringProp.class) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "version", PropVerificationError.Severity.WARNING, "Version", "The Version must be specified", new String[0]));
        }
        if (this.isAppLocalized() && this.getProp("defaultTextTable", TextTableReference.class) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "defaultTextTable", PropVerificationError.Severity.WARNING, "Text table", "Application text table must be specified", new String[0]));
        }
        if ((kStringProp = this.getProp(Atom.NAME, KStringProp.class)) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, Atom.NAME, PropVerificationError.Severity.WARNING, "Application name", "Application name must be specified", new String[0]));
        } else {
            object3 = this.getName();
            if (object3 == null || ((String)object3).isBlank()) {
                propVerification.add(new PropVerificationError("noName", PropVerificationError.Severity.WARNING, "Application name", kStringProp, "Application name cannot be a blank string", new String[0]));
            }
        }
        kStringProp = this.getProp(Atom.DESCR, KStringProp.class);
        if (kStringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, Atom.DESCR, PropVerificationError.Severity.WARNING, "Description", "Description must be specified", new String[0]));
        } else {
            object3 = this.getDescription();
            if (object3 == null || ((String)object3).isBlank()) {
                propVerification.add(new PropVerificationError("noDescr", PropVerificationError.Severity.WARNING, "Description", kStringProp, "Description cannot be a blank string", new String[0]));
            }
        }
        object3 = this.getIconBitmapReference();
        if (object3 != null) {
            iImageTarget = (IImageTarget)((AbstractReference)object3).getTargetReference();
            if (iImageTarget == null) {
                propVerification.add(new PropVerificationError("na", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap is not found", new String[0]));
            } else {
                object2 = iImageTarget.getClientImageData();
                if (object2 == null) {
                    propVerification.add(new PropVerificationError("cid", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap ClientImageData is not found", new String[0]));
                } else {
                    object = ((ClientImageData)object2).getDefaultResource();
                    if (object == null) {
                        propVerification.add(new PropVerificationError("res", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap resource is not found", new String[0]));
                    } else if (!((ClientImageData)object2).isBitmap() || ((ClientImageData)object2).isMulti) {
                        propVerification.add(new PropVerificationError("type", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap is not a single bitmap", new String[0]));
                    } else {
                        String string = ((String)object).toLowerCase(Locale.ENGLISH);
                        if (!(string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg"))) {
                            propVerification.add(new PropVerificationError("format", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap resource: \"" + (String)object + "\" must have a PNG, JPG or JPEG file extension", new String[0]));
                        } else {
                            int n2 = ((ClientImageData)object2).width;
                            int n3 = ((ClientImageData)object2).height;
                            if (n2 < 256 || n2 != n3) {
                                propVerification.add(new PropVerificationError("size", PropVerificationError.Severity.WARNING, "Icon bitmap", (GProp<?>)object3, "Icon bitmap resource is not a square 256x256 image, or larger: width=" + n2 + ", height=" + n3 + ", resource: \"" + (String)object + "\"", new String[0]));
                            }
                        }
                    }
                }
            }
        }
        if ((object3 = this.getIconSVGReference()) != null) {
            iImageTarget = (IImageTarget)((AbstractReference)object3).getTargetReference();
            if (iImageTarget == null) {
                propVerification.add(new PropVerificationError("na", PropVerificationError.Severity.WARNING, "Icon (vector)", (GProp<?>)object3, "Icon (vector) is not found", new String[0]));
            } else if (iImageTarget instanceof SVGDefinition) {
                object2 = (SVGDefinition)iImageTarget;
                object = ((SVGDefinition)object2).getSVGInfo();
                if (object == null) {
                    propVerification.add(new PropVerificationError("res", PropVerificationError.Severity.WARNING, "Icon (vector)", (GProp<?>)object3, "Icon (vector) resource is not found", new String[0]));
                }
            } else {
                propVerification.add(new PropVerificationError("type", PropVerificationError.Severity.WARNING, "Icon (vector)", (GProp<?>)object3, "Icon (vector) must be in SVG format", new String[0]));
            }
        }
        if (!(this.isAvailableForPhones() || this.isAvailableForTablets() || this.isAvailableForBrowsers())) {
            propVerification.add(new PropVerificationError("notAvailable", PropVerificationError.Severity.INFO, "Availability", this, "The app is not available at all (phones, tablets or browsers)", new String[0]));
        }
        return true;
    }
}

