/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license;

import com.iizix.IntArrayList;
import com.iizix.NotFoundException;
import com.iizix.SendTransaction;
import com.iizix.Value;
import com.iizix.os.HardwareInfo;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VSWorkUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public enum HardwareIdentication {
    ComputerInfo(1, false, false),
    ProcessorInfo(2, true, false),
    MemoryInfo(3, true, false),
    OperatingSystem(4, false, false),
    OperatingSystemWithVersion(5, false, false),
    AllMacAddresses(6, true, false),
    IPv4MacAddresses(7, true, false),
    IPv6MacAddresses(8, true, false),
    HostNamesWithDomain(9, true, true),
    HostNames(10, true, true),
    HostAddressesIPv4(11, true, false),
    DiskSerials(12, true, false),
    SystemEnvironment(13, false, false);

    private final int a;
    private final boolean a;
    private final boolean b;
    private static final HardwareIdentication[] a;
    public static final String defaultHWIDs;
    private static final int[] a;

    static {
        a = new HardwareIdentication[]{ComputerInfo, ProcessorInfo, OperatingSystem, AllMacAddresses, DiskSerials};
        int n2 = a.length;
        a = new int[n2];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < n2) {
            HardwareIdentication hardwareIdentication = a[n3];
            HardwareIdentication.a[n3] = hardwareIdentication.a;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(hardwareIdentication.a);
            ++n3;
        }
        defaultHWIDs = stringBuilder.toString();
    }

    private HardwareIdentication(int n3, boolean bl, boolean bl2) {
        this.a = n3;
        this.a = bl;
        this.b = bl2;
    }

    public int getValue() {
        return this.a;
    }

    public boolean needsRefresh() {
        return this.a;
    }

    public boolean hasDNSLookUp() {
        return this.b;
    }

    public String getIdentification() {
        return this.getIdentification(this.a);
    }

    public String getIdentification(boolean bl) {
        return HardwareInfo.getInstance().get(this, bl, true, new String[0]);
    }

    public String getIdentification(String ... stringArray) {
        return HardwareInfo.getInstance().get(this, this.a, true, stringArray);
    }

    public String getIdentification(boolean bl, String ... stringArray) {
        return HardwareInfo.getInstance().get(this, bl, true, stringArray);
    }

    public void append(SendTransaction sendTransaction, boolean bl) {
        sendTransaction.appendByte(this.a);
        sendTransaction.appendString(this.getIdentification(bl && this.a));
    }

    public void set(VSField vSField, boolean bl) {
        vSField.setValue(this.getIdentification(bl && this.a));
    }

    public void set(VSTable vSTable, boolean bl) {
        String string = this.getIdentification(bl && this.a);
        String[] stringArray = string.split(",");
        VSWorkUnit vSWorkUnit = new VSWorkUnit((VSComponent)vSTable);
        vSWorkUnit.beginWork();
        try {
            vSTable.clear();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                vSTable.addRow(new Value[]{new Value(string2)});
                ++n3;
            }
        }
        finally {
            vSWorkUnit.endWork();
        }
    }

    public static HardwareIdentication from(int n2) {
        HardwareIdentication[] hardwareIdenticationArray = HardwareIdentication.values();
        int n3 = hardwareIdenticationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            HardwareIdentication hardwareIdentication = hardwareIdenticationArray[n4];
            if (hardwareIdentication.a == n2) {
                return hardwareIdentication;
            }
            ++n4;
        }
        throw new NotFoundException("HardwareIdentification index value " + n2 + " not found");
    }

    public static final IntArrayList getDefaultHWIDIndexes() {
        return new IntArrayList(a);
    }
}

