/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.Activator;
import com.iizigo.ImageRegistry;
import com.iizigo.editor.PropHelper;
import com.iizigo.navigator.ContentProvider;
import com.iizigo.project.IFileCreated;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.NewWizardPage;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.FolderPropCnr;
import com.iizigo.prop.ResourceDesignerProp;
import com.iizix.ILog;
import com.iizix.prop.PropCnr;
import com.iizix.virtual.VirtualThreads;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NewWizard
extends Wizard
implements INewWizard {
    protected final ModuleModel model;
    protected final StructuredViewer lastViewer = ContentProvider.getLastViewer();
    private NewWizardPage a;
    protected FolderPropCnr initSelectedParentFolder;

    public NewWizard(String string, String string2) {
        this(string, ImageRegistry.getInstance().get("large/" + string2));
    }

    public NewWizard(String string, ImageDescriptor imageDescriptor) {
        this.model = ProjectManager.getInstance().getModuleModel(Activator.getSelectedProject());
        assert (this.model != null);
        this.setWindowTitle(string);
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.setNeedsProgressMonitor(false);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        for (DesignerProp designerProp : Activator.getSelectedProps((ISelection)iStructuredSelection)) {
            this.initSelectedParentFolder = designerProp.getParentFolderProp();
            if (this.initSelectedParentFolder != null) break;
        }
    }

    public String getInitSelectedFolderPath() {
        return this.initSelectedParentFolder != null ? this.initSelectedParentFolder.getReferencePropName() : null;
    }

    public boolean performFinish() {
        return false;
    }

    public void addPage(IWizardPage iWizardPage) {
        super.addPage(iWizardPage);
        if (iWizardPage instanceof NewWizardPage) {
            NewWizardPage newWizardPage;
            this.a = newWizardPage = (NewWizardPage)iWizardPage;
        }
        Activator.checkEnabledOrStarting(this.getShell(), (IWizard)this);
    }

    protected DesignerProp createNewFile(PropCnr propCnr) {
        return this.createNewFile(propCnr, null, true);
    }

    protected DesignerProp createNewFile(PropCnr propCnr, boolean bl) {
        return this.createNewFile(propCnr, null, bl);
    }

    protected DesignerProp createNewFile(PropCnr propCnr, IFileCreated iFileCreated, boolean bl) {
        DesignerProp designerProp = this.a.getItemContainer().getDesigner();
        IFolder iFolder = (IFolder)designerProp.getIResource();
        IFile iFile = iFolder.getFile(this.a.getItemNameAndExtension());
        return this.createNewFile("Create " + designerProp.getFolder().title, iFile, propCnr, iFileCreated, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DesignerProp createNewFile(String string, IFile iFile, PropCnr propCnr, IFileCreated iFileCreated, boolean bl) {
        boolean bl2 = false;
        if (bl2) {
            System.err.println("> NewWizard.createNewFile: " + String.valueOf(iFile.getFullPath()));
        }
        IContainer iContainer = iFile.getParent();
        boolean[] blArray = new boolean[1];
        Object object = new Object();
        IRunnableWithProgress iRunnableWithProgress = iProgressMonitor2 -> {
            try {
                if (bl2) {
                    System.err.println("> Create file: AVOID UPDATE");
                }
                ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                    try {
                        CreateFileOperation createFileOperation = new CreateFileOperation(iFile, null, Activator.createInputStream(propCnr), string);
                        createFileOperation.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
                        createFileOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
                    }
                    catch (IOException | TransformerException | ExecutionException throwable) {
                        throw new CoreException((IStatus)Activator.createErrorStatus("createNewFile()", throwable));
                    }
                }, null, 1, iProgressMonitor2);
                if (bl2) {
                    System.err.println("< Create file: AVOID UPDATE");
                }
                VirtualThreads.getVirtualThreads().startThread(() -> {
                    block27: {
                        if (bl2) {
                            System.err.println("> Refresh file");
                        }
                        try {
                            try {
                                ResourceDesignerProp resourceDesignerProp;
                                iContainer.refreshLocal(2, null);
                                if (bl2) {
                                    System.err.println("< Refresh file");
                                }
                                int n2 = 40;
                                while ((resourceDesignerProp = DesignerProp.getInstance((IResource)iFile)) == null && --n2 >= 0) {
                                    if (bl2) {
                                        System.err.println("- wait create");
                                    }
                                    Thread.sleep(500L);
                                }
                                if (bl2) {
                                    System.err.println("- created = " + (resourceDesignerProp != null));
                                }
                                if (resourceDesignerProp == null) {
                                    ILog.SEVERE(NewWizard.class, (String)"The background workspace listener did not create an iiziGo Designer instance of the file (Workspace thread)!");
                                }
                                if (iFileCreated != null) {
                                    iFileCreated.onFileCreated(iFile);
                                }
                            }
                            catch (InterruptedException | CoreException throwable) {
                                ILog.SEVERE(NewWizard.class, (String)("Workspace refresh of folder '" + String.valueOf(iContainer.getFullPath()) + "' failed"), (Throwable)throwable);
                                if (bl2) {
                                    System.err.println("> notify");
                                }
                                Object object2 = object;
                                synchronized (object2) {
                                    blArray[0] = true;
                                    object.notifyAll();
                                }
                                if (bl2) {
                                    System.err.println("< notify");
                                }
                                break block27;
                            }
                        }
                        catch (Throwable throwable) {
                            if (bl2) {
                                System.err.println("> notify");
                            }
                            Object object3 = object;
                            synchronized (object3) {
                                blArray[0] = true;
                                object.notifyAll();
                            }
                            if (bl2) {
                                System.err.println("< notify");
                            }
                            throw throwable;
                        }
                        if (bl2) {
                            System.err.println("> notify");
                        }
                        Object object4 = object;
                        synchronized (object4) {
                            blArray[0] = true;
                            object.notifyAll();
                        }
                        if (bl2) {
                            System.err.println("< notify");
                        }
                    }
                });
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
            if (bl2) {
                System.err.println("> wait notify");
            }
            Object object2 = object;
            synchronized (object2) {
                if (!blArray[0]) {
                    object.wait();
                }
            }
            if (bl2) {
                System.err.println("< wait notify");
                System.err.println("< NewWizard.createNewFile: " + String.valueOf(iFile.getFullPath()));
            }
            if ((object2 = DesignerProp.getInstance((IResource)iFile)) == null) {
                ILog.SEVERE(NewWizard.class, (String)"The background workspace listener did not create an iiziGo Designer instance of the file (SWT thread)!");
                Activator.openError(this.getShell(), "Internal Error", "The background workspace listener did not create an iiziGo Designer instance of the file!", null);
            } else {
                String string2;
                PropCnr propCnr2 = ((DesignerProp)object2).getPropCnr();
                if (!(propCnr2 instanceof FilePropCnr) || !(propCnr2.getParent() instanceof FolderPropCnr)) {
                    string2 = "Created " + ((DesignerProp)object2).getCNDescriptionType() + " property is not attached in property tree!";
                    ILog.SEVERE(((Object)((Object)this)).getClass(), (String)string2);
                    MessageDialog.openError((Shell)this.getShell(), (String)"Property file creation error", (String)string2);
                }
                if ((string2 = propCnr2.getRootParent()) == null) {
                    String string3 = "Created " + ((DesignerProp)object2).getCNDescriptionType() + " property: cannot find it's root parent (attachment in property tree)!";
                    ILog.SEVERE(((Object)((Object)this)).getClass(), (String)string3);
                    MessageDialog.openError((Shell)this.getShell(), (String)"Property file creation error", (String)string3);
                } else {
                    String string4 = propCnr2.getFullPropName();
                    if (string2.getPropFromPath(string4) != propCnr2) {
                        String string5 = "Created " + ((DesignerProp)object2).getCNDescriptionType() + " property: path '" + string4 + "' does not lead back to same property from root (attachment in property tree)!";
                        ILog.SEVERE(((Object)((Object)this)).getClass(), (String)string5);
                        MessageDialog.openError((Shell)this.getShell(), (String)"Property file creation error", (String)string5);
                    }
                }
                if (bl) {
                    if (this.lastViewer != null) {
                        this.lastViewer.setSelection((ISelection)new StructuredSelection(object2), true);
                    }
                    PropHelper.doOpen(iFile);
                }
            }
            return object2;
        }
        catch (InterruptedException interruptedException) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"createNewFile() operation interrupted", (Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)invocationTargetException.getTargetException());
            Activator.openError(this.getShell(), "Internal Error", "Internal error creating new file", invocationTargetException.getTargetException());
        }
        return null;
    }
}

