/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.navigator.CommonNavigatorEx;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ModulePerspective;
import com.iizigo.project.NewModuleProjectWizardStartupPage1;
import com.iizigo.project.NewModuleProjectWizardStartupPage2;
import com.iizigo.project.ProjectManager;
import com.iizigo.setup.UIFeedBack;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.text.KString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NewModuleProjectWizardStartup
extends Wizard
implements INewWizard {
    private NewModuleProjectWizardStartupPage1 a;
    private NewModuleProjectWizardStartupPage2 a;

    public NewModuleProjectWizardStartup() {
        this.setWindowTitle("Create IIZI Module Project (Quickstart)");
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        int n2 = ApplicationUI.getInstance().cx(500);
        this.a = new NewModuleProjectWizardStartupPage1(n2);
        this.addPage((IWizardPage)this.a);
        this.a = new NewModuleProjectWizardStartupPage2(this.a, n2, "i18n");
        this.addPage((IWizardPage)this.a);
        Activator.checkEnabledOrStarting(this.getShell(), (IWizard)this);
    }

    public boolean performFinish() {
        Shell shell = this.getContainer().getShell();
        UIFeedBack<Object> uIFeedBack = new UIFeedBack<Object>(shell, null);
        uIFeedBack.createDialog(1, "Create New Module Project", "Create quickstart project...");
        Thread thread = new Thread(() -> {
            try {
                NewModuleProjectWizardStartup.createModuleProject(uIFeedBack, this.a, this.a);
            }
            catch (CoreException coreException) {
                uIFeedBack.setReturnCode(coreException.getMessage());
            }
            uIFeedBack.dispose();
        }, "FinishNewModuleProject");
        String string = uIFeedBack.processDialogBlocked(thread);
        if (string == "\u0000") {
            return false;
        }
        if (string == null) {
            return true;
        }
        MessageDialog.openError((Shell)shell, (String)"Setup Wizard", (String)string);
        return false;
    }

    public static void createModuleProject(UIFeedBack<String> uIFeedBack, NewModuleProjectWizardStartupPage1 newModuleProjectWizardStartupPage1, NewModuleProjectWizardStartupPage2 newModuleProjectWizardStartupPage2) throws CoreException {
        String[] stringArray = new String[]{"Removing introduction window"};
        try {
            uIFeedBack.getDisplay().syncExec(() -> {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                if (iWorkbench != null) {
                    IIntroPart iIntroPart;
                    IIntroManager iIntroManager = iWorkbench.getIntroManager();
                    if (iIntroManager != null && (iIntroPart = iIntroManager.getIntro()) != null) {
                        uIFeedBack.updateFeedBack("Removing introduction window");
                        iIntroManager.closeIntro(iIntroPart);
                    }
                    stringArray[0] = uIFeedBack.updateFeedBack("Activating IIZI perspective");
                    iIntroPart = iWorkbench.getPerspectiveRegistry().findPerspectiveWithId(ModulePerspective.PERSPECTIVE_ID);
                    iWorkbench.getActiveWorkbenchWindow().getActivePage().setPerspective((IPerspectiveDescriptor)iIntroPart);
                }
            });
        }
        catch (Throwable throwable) {
            ILog.WARNING(NewModuleProjectWizardStartup.class, (String)("Failed " + stringArray[0] + ", ignoring and continuing..."), (Throwable)throwable);
        }
        uIFeedBack.updateFeedBack("Creating project and panels...");
        ArrayList arrayList = new ArrayList();
        boolean bl = newModuleProjectWizardStartupPage1.useTextTables;
        LinkedHashMap<Atom, KString> linkedHashMap = bl ? new LinkedHashMap<Atom, KString>() : null;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        IProject[] iProjectArray = new IProject[1];
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        iWorkspace.run(iProgressMonitor -> {
            iProgressMonitor.beginTask("Creating project and panels", 4);
            try {
                String string = bl ? newModuleProjectWizardStartupPage2.a() : null;
                iProjectArray[0] = newModuleProjectWizardStartupPage1.a(uIFeedBack, string, linkedHashMap, iProgressMonitor);
                arrayList.add(iProjectArray[0]);
            }
            finally {
                iProgressMonitor.done();
            }
        }, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
        IProject iProject = iProjectArray[0];
        iProject.close((IProgressMonitor)nullProgressMonitor);
        try {
            Thread.sleep(7500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        iProject.open((IProgressMonitor)nullProgressMonitor);
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(iProject);
        if (moduleModel == null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Failed creating IIZI Module Project"));
        }
        int n2 = 30;
        while (--n2 >= 0) {
            if (moduleModel.hasCompletedLoading()) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (bl) {
            newModuleProjectWizardStartupPage2.a(moduleModel, linkedHashMap);
        }
        uIFeedBack.getDisplay().syncExec(() -> {
            uIFeedBack.updateFeedBack("Opening created items...");
            CommonNavigatorEx.selectReveal(arrayList.toArray());
            if (bl) {
                arrayList.addAll(List.of(newModuleProjectWizardStartupPage2.a()));
                newModuleProjectWizardStartupPage2.a(uIFeedBack.getDisplay(), uIFeedBack.getDialogShell());
            }
        });
        newModuleProjectWizardStartupPage1.a(uIFeedBack);
    }

    public boolean canFinish() {
        if (!this.a.isPageComplete()) {
            return false;
        }
        if (!this.a.useTextTables) {
            return true;
        }
        return this.a.isPageComplete();
    }

    public boolean performCancel() {
        return super.performCancel();
    }
}

