/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.comm.IPortController;
import com.iizix.comm.IServerSettings;
import com.iizix.comm.PortConfig;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.b;
import com.iizix.jetty.e;
import com.iizix.jetty.i;
import com.iizix.log.slf4j.LogBinder;
import com.iizix.prop.IWebServerPortConfig;
import com.iizix.virtual.ThreadGroupType;
import com.iizix.virtual.VirtualThreadGroup;
import com.iizix.virtual.VirtualThreads;
import com.iizix.web.ICommonServletInterface;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerConnectionFactory;
import org.eclipse.jetty.quic.quiche.server.QuicheServerConnector;
import org.eclipse.jetty.quic.quiche.server.QuicheServerQuicConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WSHelper {
    static final boolean a;
    public static int MIN_GZIP_SIZE;
    private static final boolean e;
    static final boolean b;
    static final boolean c;
    static final boolean d;
    private static Path a;
    static final ResourceFactory a;

    static {
        MIN_GZIP_SIZE = 128;
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("iizi.jetty-debug");
        boolean bl = false;
        boolean bl2 = false;
        if (Boolean.parseBoolean(string)) {
            bl = true;
            bl2 = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = false;
            bl2 = true;
        }
        if (bl2) {
            string = bl ? "enabled " : "disabled";
            ILog.INFO(WSHelper.class, (String)("Jetty Debug Mode will be " + string + "\n\n   **********************************\n   *                                *\n   *  Jetty Debug will be " + string + "  *\n   *                                *\n   **********************************\n"));
            if (bl) {
                stringBuilder.append("\n - Jetty debug mode = true");
            }
        }
        LogBinder.setJettyDebug((boolean)bl);
        a = bl;
        bl2 = false;
        boolean bl3 = true;
        try {
            string = System.getProperty("iizi.conscrypt");
            if (string != null && !string.isEmpty()) {
                bl2 = true;
                bl3 = Boolean.parseBoolean(string);
                if (!bl3 && !string.equalsIgnoreCase("false")) {
                    ILog.SEVERE(WSHelper.class, (String)"ERROR in environment variable 'iizi.conscrypt'\n\n   *******************************************************\n   *                                                     *\n   *  ERROR in environment variable 'iizi.conscrypt'     *\n   *  ----------------------------------------------     *\n   *                                                     *\n   *  The environment variable 'iizi.conscrypt' must be  *\n   *  be 'true' or 'false'.                              *\n   *                                                     *\n   *  Conscrypt will be enabled for IIZI.                *\n   *                                                     *\n   *******************************************************\n");
                    bl2 = false;
                    bl3 = true;
                }
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(WSHelper.class, (String)"Failed retrieving the environment variable 'iizi.conscrypt': Conscrypt will be enabled", (Throwable)throwable);
        }
        if (bl3) {
            try {
                Conscrypt.checkAvailability();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (bl3 && bl2) {
                    ILog.SEVERE(WSHelper.class, (String)"Conscrypt is not available for this operating system.\n\n   ************************************************\n   *                                              *\n   *  Unsupported Operating System for Conscrypt  *\n   *  ------------------------------------------  *\n   *                                              *\n   *  Conscrypt will be disabled for IIZI.        *\n   *                                              *\n   ************************************************\n");
                }
                bl3 = false;
                bl2 = true;
            }
        }
        if (bl2) {
            string = bl3 ? "enabled " : "disabled";
            ILog.INFO(WSHelper.class, (String)("Conscrypt will be " + string + "\n\n   ********************************\n   *                              *\n   *  Conscrypt will be " + string + "  *\n   *                              *\n   ********************************\n"));
        }
        e = bl3;
        if (a) {
            stringBuilder.append("\n - Use Conscrypt = " + bl3);
        } else {
            stringBuilder.append(" Conscrypt = " + bl3);
        }
        bl2 = false;
        bl3 = true;
        try {
            string = System.getProperty("iizi.http2");
            if (string != null && !string.isEmpty()) {
                bl2 = true;
                bl3 = Boolean.parseBoolean(string);
                if (!bl3 && !string.equalsIgnoreCase("false")) {
                    ILog.SEVERE(WSHelper.class, (String)"ERROR in environment variable 'iizi.http2'\n\n   ************************************************\n   *                                              *\n   *  ERROR in environment variable 'iizi.http2'  *\n   *  ------------------------------------------  *\n   *                                              *\n   *  The environment variable 'iizi.http2' must  *\n   *  be 'true' or 'false'.                       *\n   *                                              *\n   *  HTTP/2 will be disabled for IIZI.           *\n   *                                              *\n   ************************************************\n");
                    bl3 = false;
                    bl2 = false;
                }
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(WSHelper.class, (String)"Failed retrieving the environment variable 'iizi.http2': HTTP/2 will be enabled", (Throwable)throwable);
            bl3 = true;
        }
        if (bl2) {
            string = bl3 ? "enabled " : "disabled";
            ILog.INFO(WSHelper.class, (String)("HTTP/2 will be " + string + "\n\n   *****************************\n   *                           *\n   *  HTTP/2 will be " + string + "  *\n   *                           *\n   *****************************\n"));
        }
        b = bl3;
        if (a) {
            stringBuilder.append("\n - Use HTTP/2 = " + bl3);
        } else {
            stringBuilder.append(", HTTP/2 = " + bl3);
        }
        bl2 = false;
        bl3 = b;
        if (bl3) {
            try {
                string = System.getProperty("iizi.http3");
                if (string != null && !string.isEmpty()) {
                    bl2 = true;
                    bl3 = Boolean.parseBoolean(string);
                    if (!bl3 && !string.equalsIgnoreCase("false")) {
                        ILog.SEVERE(WSHelper.class, (String)"\"ERROR in environment variable 'iizi.http3'\n\n   ************************************************\n   *                                              *\n   *  ERROR in environment variable 'iizi.http3'  *\n   *  ------------------------------------------  *\n   *                                              *\n   *  The environment variable 'iizi.http3' must  *\n   *  be 'true' or 'false'.                       *\n   *                                              *\n   *  HTTP/3 will be disabled for IIZI.           *\n   *                                              *\n   ************************************************\n");
                        bl3 = false;
                        bl2 = false;
                    }
                }
            }
            catch (Throwable throwable) {
                ILog.SEVERE(WSHelper.class, (String)"Failed retrieving the environment variable 'iizi.http3': HTTP/3 will be enabled", (Throwable)throwable);
                bl3 = true;
            }
            if (bl2) {
                string = bl3 ? "enabled " : "disabled";
                ILog.INFO(WSHelper.class, (String)("HTTP/3 will be " + string + "\n\n   *****************************\n   *                           *\n   *  HTTP/3 will be " + string + "  *\n   *                           *\n   *****************************\n"));
            }
        }
        c = bl3;
        if (a) {
            stringBuilder.append("\n - Use HTTP/3 = " + bl3);
        } else {
            stringBuilder.append(", HTTP/3 = " + bl3);
        }
        bl2 = false;
        bl3 = true;
        try {
            string = System.getProperty("iizi.jettywebsocketextensions");
            if (string != null && !string.isEmpty()) {
                bl2 = true;
                bl3 = Boolean.parseBoolean(string);
                if (!bl3 && !string.equalsIgnoreCase("false")) {
                    ILog.SEVERE(WSHelper.class, (String)"ERROR in environment variable 'iizi.jettywebsocketextensions'\n\n   *******************************************************************\n   *                                                                 *\n   *  ERROR in environment variable 'iizi.jettywebsocketextensions'  *\n   *  -------------------------------------------------------------  *\n   *                                                                 *\n   *  The environment variable 'iizi.jettywebsocketextensions' must  *\n   *  be 'true' or 'false'.                                          *\n   *                                                                 *\n   *  Jetty WebSocket Extensions will be disabled for IIZI.          *\n   *                                                                 *\n   *******************************************************************\n");
                    bl3 = false;
                    bl2 = false;
                }
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(WSHelper.class, (String)"Failed retrieving the environment variable 'iizi.jettywebsocketextensions': Jetty WebSocket Extensions be disabled", (Throwable)throwable);
            bl3 = false;
        }
        if (bl2) {
            string = bl3 ? "enabled " : "disabled";
            ILog.INFO(WSHelper.class, (String)("Jetty WebSocket Extensions will be " + string + "\n\n   ***************************************************\n   *                                                 *\n   *  Jetty WebSocket Extensions will be " + string + "    *\n   *                                                 *\n   ***************************************************\n"));
        }
        d = bl3;
        if (a) {
            stringBuilder.append("\n - Jetty WebSocket Extensions = " + bl3);
        } else {
            stringBuilder.append(", Jetty WebSocket Extensions = " + bl3);
        }
        if (a) {
            try {
                String[] stringArray = SSLContext.getDefault().getSocketFactory().getDefaultCipherSuites();
                stringBuilder.append("\n - Cipher suites:");
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    stringBuilder.append("\n    + " + string2);
                    ++n2;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (stringBuilder.length() > 0) {
            ILog.INFO(WSHelper.class, (String)("Jetty webserver settings:" + String.valueOf(stringBuilder)));
        }
        a = ResourceFactory.closeable();
    }

    private static synchronized Path a(File file) {
        if (a == null) {
            try {
                File file2;
                File file3 = file2 = file != null ? new File(file, "quic-work") : new File("quic-work");
                if (!file2.isDirectory() && !file2.mkdir()) {
                    throw new RuntimeException("Failed creating Quic working directory 'quic-work' under the Server directory for temporary files");
                }
                a = file2.getCanonicalFile().toPath();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed creating Quic working directory 'quic-work' under the Server directory for temporary files", throwable);
            }
        }
        return a;
    }

    static Server a(PortConfig[] portConfigArray, File file, KeyStore keyStore, String string) {
        VirtualThreadGroup virtualThreadGroup = new VirtualThreadGroup(ThreadGroupType.WEB_SERVER, "WebServer-pool");
        ThreadGroup threadGroup = virtualThreadGroup.getThreadGroup();
        ThreadFactory threadFactory = virtualThreadGroup.getThreadFactory();
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(200, 8, 60000, -1, null, threadGroup, threadFactory);
        if (virtualThreadGroup.usesVirtualThreads()) {
            queuedThreadPool.setVirtualThreadsExecutor((Executor)virtualThreadGroup.newExecutorService());
        }
        Server server = new Server((ThreadPool)queuedThreadPool);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PortConfig[] portConfigArray2 = portConfigArray;
        int n = portConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            block27: {
                Object object;
                PortConfig portConfig = portConfigArray2[n2];
                String string2 = portConfig.bind;
                if (string2 != null && string2.isEmpty()) {
                    string2 = null;
                }
                if (string2 != null && (object = (InetAddress)hashMap.get(string2)) == null) {
                    try {
                        object = InetAddress.getByName(string2);
                        hashMap.put(string2, object);
                    }
                    catch (UnknownHostException unknownHostException) {
                        string2 = null;
                        ILog.SEVERE(WSHelper.class, (String)"Bind address \"{}\" is not valid, assuming no bind address", (Object[])new Object[]{string2, unknownHostException});
                    }
                }
                if (portConfig.isHTTPS && keyStore == null) {
                    object = WSHelper.class;
                    ILog.WARNING((Class)object, (String)"Using self-signed SSL certificate provided with iiziGo");
                    URL uRL = ((Class)object).getResource("/cert/self_signed.p12");
                    if (uRL == null) {
                        ILog.SEVERE((Class)object, (String)"The self-signed SSL certificate provided with iiziGo is not found: cert/self_signed.p12");
                    } else {
                        try {
                            Throwable throwable = null;
                            Object var18_21 = null;
                            try (InputStream inputStream = uRL.openStream();){
                                if (string == null || string.isEmpty()) {
                                    string = "password";
                                }
                                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                                keyStore.load(inputStream, string.toCharArray());
                                Enumeration<String> enumeration = keyStore.aliases();
                                if (enumeration.hasMoreElements()) {
                                    String string3 = enumeration.nextElement();
                                    Certificate certificate = keyStore.getCertificate(string3);
                                    if (certificate instanceof X509Certificate) {
                                        X509Certificate x509Certificate = (X509Certificate)certificate;
                                        Date date = x509Certificate.getNotAfter();
                                        if (System.currentTimeMillis() > date.getTime()) {
                                            ILog.WARNING((Class)object, (String)"The self-signed SSL certificate provided with iiziGo has expired ({}), please configure a new PKCS#12 identity", (Object)date);
                                        }
                                    } else {
                                        ILog.SEVERE((Class)object, (String)("The self-signed SSL certificate provided with iiziGo does not contain an X.509 certificate for alias \"" + string3 + "\""));
                                    }
                                } else {
                                    ILog.SEVERE((Class)object, (String)"The self-signed SSL certificate provided with iiziGo has no aliases: Jetty HTTP/3 connector will not work!");
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            ILog.SEVERE((Class)object, (String)"Keystore failed to initialize, disabling secure port {}", (Object[])new Object[]{portConfig.port, exception});
                            break block27;
                        }
                    }
                }
                server.addConnector((Connector)(portConfig.isHTTPS ? WSHelper.a(portConfig, server, file, null, null, string2, keyStore, string) : WSHelper.a(portConfig, server, string2, 0)));
            }
            ++n2;
        }
        return server;
    }

    static Server a(IServerSettings iServerSettings, ArrayList<PortConfig> arrayList, int[] nArray) throws IOException {
        String string;
        PortConfig portConfig;
        IWebServerPortConfig iWebServerPortConfig;
        VirtualThreadGroup virtualThreadGroup = new VirtualThreadGroup(ThreadGroupType.WEB_SERVER, "WebServer-pool");
        ThreadGroup threadGroup = virtualThreadGroup.getThreadGroup();
        ThreadFactory threadFactory = virtualThreadGroup.getThreadFactory();
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(iServerSettings.getWSMaxThreads(), iServerSettings.getWSMinThreads(), iServerSettings.getWSIdleTimeout(), iServerSettings.getWSReservedThreads(), null, threadGroup, threadFactory);
        if (virtualThreadGroup.usesVirtualThreads()) {
            queuedThreadPool.setVirtualThreadsExecutor((Executor)virtualThreadGroup.newExecutorService());
        }
        Server server = new Server((ThreadPool)queuedThreadPool);
        int n = iServerSettings.getWSRedirectCodeHTTP_to_HTTPS();
        HashMap<String, InetAddress> hashMap = new HashMap<String, InetAddress>();
        PortConfig portConfig2 = iServerSettings.getPortConfigurations();
        int n2 = ((IWebServerPortConfig[])portConfig2).length;
        String[] stringArray = new String[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            InetAddress inetAddress;
            iWebServerPortConfig = portConfig2[n3];
            String string2 = iWebServerPortConfig.getBindAddress();
            if (string2 != null && (inetAddress = (InetAddress)hashMap.get(string2)) == null) {
                try {
                    inetAddress = InetAddress.getByName(string2);
                    hashMap.put(string2, inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    string2 = null;
                    ILog.SEVERE(WSHelper.class, (String)("Bind address \"" + string2 + "\" is not valid, assuming no bind address: " + unknownHostException.getMessage()));
                }
            }
            if (iWebServerPortConfig.isLocalHTTP() && !iWebServerPortConfig.isFrontEndSecured()) {
                stringArray[n3] = string2;
                nArray2[n3] = -1;
            }
            ++n3;
        }
        if (n > 0) {
            n3 = 0;
            portConfig = portConfig2;
            int n4 = ((IWebServerPortConfig[])portConfig).length;
            int n5 = 0;
            while (n5 < n4) {
                iWebServerPortConfig = portConfig[n5];
                if (iWebServerPortConfig.isLocalHTTPS() || iWebServerPortConfig.isFrontEndSecured()) {
                    int n6;
                    string = iWebServerPortConfig.getBindAddress();
                    if (!hashMap.containsKey(string)) {
                        string = null;
                    }
                    int n7 = n6 = iWebServerPortConfig.isFrontEndSecured() ? iWebServerPortConfig.getExternalPort() : iWebServerPortConfig.getPort();
                    if (n6 < 0) {
                        n6 = 443;
                    }
                    int n8 = 0;
                    while (n8 < n2) {
                        if (nArray2[n8] < 0 && Objects.equals(stringArray[n8], string)) {
                            nArray2[n8] = n6;
                            n3 = 1;
                        }
                        ++n8;
                    }
                }
                ++n5;
            }
            if (n3 != 0) {
                nArray[0] = n;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            block20: {
                iWebServerPortConfig = portConfig2[n3];
                String string3 = iWebServerPortConfig.getBindAddress();
                if (string3 != null && !hashMap.containsKey(string3)) {
                    string3 = null;
                }
                e e2 = new e(server, iWebServerPortConfig);
                e2.a = portConfig = iWebServerPortConfig.newPortConfig((IPortController)e2);
                arrayList.add(portConfig);
                if (!iWebServerPortConfig.isLocalHTTPS()) {
                    string = WSHelper.a(portConfig, server, string3, nArray2[n3]);
                } else {
                    try {
                        StringBuilder stringBuilder = new StringBuilder();
                        KeyStore keyStore = iWebServerPortConfig.getKeyStore(stringBuilder);
                        if (keyStore == null) break block20;
                        string = WSHelper.a(portConfig, server, null, e2, iWebServerPortConfig, string3, keyStore, stringBuilder.toString());
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException exception) {
                        ILog.SEVERE(WSHelper.class, (String)"Failed loading the key store for the HTTPS port {}, port configuration is ignored and not started", (Object[])new Object[]{portConfig.port, exception});
                        break block20;
                    }
                }
                server.addConnector((Connector)string);
            }
            ++n3;
        }
        return server;
    }

    private static HttpConfiguration a(int n) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        if (n > 0) {
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.setSecurePort(n);
        }
        return httpConfiguration;
    }

    private static ServerConnector a(PortConfig portConfig, Server server, String string, int n) {
        HttpConfiguration httpConfiguration = WSHelper.a(n);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        i i2 = b ? new i(portConfig, server, new ConnectionFactory[]{httpConnectionFactory, new HTTP2CServerConnectionFactory(httpConfiguration)}) : new i(portConfig, server, new ConnectionFactory[]{httpConnectionFactory});
        i2.setPort(portConfig.port);
        if (string != null) {
            i2.setHost(string);
        }
        return i2;
    }

    private static ServerConnector a(PortConfig portConfig, Server server, File file, e e2, IWebServerPortConfig iWebServerPortConfig, String string, KeyStore keyStore, String string2) {
        i i2;
        if (e) {
            Security.addProvider((Provider)new OpenSSLProvider());
        }
        SslContextFactory.Server server2 = new SslContextFactory.Server();
        server2.setTrustAll(true);
        server2.setKeyStore(keyStore);
        server2.setKeyStorePassword(string2);
        server2.addExcludeProtocols(new String[]{"TLSv1", "TLSv1.1"});
        server2.setRenegotiationAllowed(false);
        server2.setCipherComparator(HTTP2Cipher.COMPARATOR);
        server2.setUseCipherSuitesOrder(true);
        if (e) {
            server2.setProvider("Conscrypt");
        }
        HttpConfiguration httpConfiguration = WSHelper.a(portConfig.port);
        SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer(false);
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        String string3 = httpConnectionFactory.getProtocol();
        if (b) {
            HTTP2ServerConnectionFactory hTTP2ServerConnectionFactory = new HTTP2ServerConnectionFactory(httpConfiguration);
            ALPNServerConnectionFactory aLPNServerConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
            aLPNServerConnectionFactory.setDefaultProtocol(string3);
            String string4 = aLPNServerConnectionFactory.getProtocol();
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(server2, string4);
            i2 = new i(portConfig, server, new ConnectionFactory[]{sslConnectionFactory, aLPNServerConnectionFactory, hTTP2ServerConnectionFactory, httpConnectionFactory});
            if (c) {
                HTTP3ServerConnectionFactory hTTP3ServerConnectionFactory = new HTTP3ServerConnectionFactory(httpConfiguration);
                QuicheServerQuicConfiguration quicheServerQuicConfiguration = new QuicheServerQuicConfiguration(WSHelper.a(file));
                QuicheServerConnector quicheServerConnector = new QuicheServerConnector(server, server2, quicheServerQuicConfiguration, new ConnectionFactory[]{hTTP3ServerConnectionFactory});
                quicheServerConnector.setPort(portConfig.port);
                if (string != null) {
                    quicheServerConnector.setHost(string);
                }
                server.addConnector((Connector)quicheServerConnector);
            }
        } else {
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(server2, string3);
            i2 = new i(portConfig, server, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        }
        i2.setPort(portConfig.port);
        if (string != null) {
            i2.setHost(string);
        }
        if (e2 != null) {
            e2.a = () -> {
                KeyStore keyStore;
                if (iWebServerPortConfig == null || !server.isStarted()) {
                    return;
                }
                String string2 = "HTTPS connector on port " + portConfig.port;
                if (string != null) {
                    string2 = string2 + " bound to " + string;
                }
                ILog.INFO(WSHelper.class, (String)("Reloading server identity for " + string2));
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    keyStore = iWebServerPortConfig.getKeyStore(stringBuilder);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException exception) {
                    ILog.SEVERE(WSHelper.class, (String)("Failed retrieving the KeyStore for " + string2 + ", leaving it running without changes"), (Throwable)exception);
                    return;
                }
                try {
                    server2.reload(sslContextFactory -> {
                        server2.setKeyStore(keyStore);
                        server2.setKeyStorePassword(stringBuilder.toString());
                    });
                }
                catch (Throwable throwable) {
                    ILog.SEVERE(WSHelper.class, (String)("Failed reloading server identity in Jetty SSL Context Factory for " + string2), (Throwable)throwable);
                    return;
                }
                ILog.INFO(WSHelper.class, (String)("Reloaded server identity for " + string2));
            };
        }
        return i2;
    }

    static Thread a(Server server, Runnable runnable) {
        try {
            server.start();
            return VirtualThreads.getVirtualThreads().startThread(() -> {
                try {
                    server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ILog.INFO(WSHelper.class, (String)"Web server stopped");
                if (runnable != null) {
                    runnable.run();
                }
            }, "WebServer");
        }
        catch (Throwable throwable) {
            ILog.INFO(WSHelper.class, (String)"Failed starting web server", (Throwable)throwable);
            try {
                server.stop();
            }
            catch (Throwable throwable2) {
                ILog.SEVERE(WSHelper.class, (String)"Failed stopping reminder of web server", (Throwable)throwable2);
            }
            return null;
        }
    }

    static boolean a(Server server, Thread thread, long l) {
        Path path = a;
        a = null;
        try {
            if (path != null && path.toFile().exists()) {
                ILog.WARNING(WSHelper.class, (String)("Removing QUIC temporary working directory: " + String.valueOf(path)));
                Utilities.deleteDirectoryRecursive((Path)path, null);
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(WSHelper.class, (String)("Failed removing QUIC temporary working directory: " + String.valueOf(path)));
        }
        if (server != null && !server.isStopped()) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                ILog.SEVERE(WSHelper.class, (String)"Failed stopping web server, proceeding to destroy...", (Throwable)exception);
                try {
                    server.destroy();
                    ILog.INFO(WSHelper.class, (String)"Successfully destroyed web server");
                }
                catch (Throwable throwable) {
                    ILog.SEVERE(WSHelper.class, (String)"Failed destroying web server", (Throwable)throwable);
                }
            }
        }
        if (thread == null || !thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join(l <= 0L ? 0L : l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !thread.isAlive();
    }

    public static String getExternalBaseServerURL(String string, String string2, int n, int n2, boolean bl) {
        Object object = string;
        if (object == null || ((String)object).isEmpty()) {
            InetAddress inetAddress = null;
            if (string2 != null && !string2.isEmpty()) {
                try {
                    inetAddress = InetAddress.getByName(string2);
                    try {
                        object = inetAddress.getCanonicalHostName();
                    }
                    catch (Exception exception) {
                        object = inetAddress.getHostName();
                    }
                }
                catch (Exception exception) {
                    object = string2;
                }
            } else {
                try {
                    inetAddress = InetAddress.getLocalHost();
                    object = inetAddress.getCanonicalHostName();
                }
                catch (Throwable throwable) {
                    if (inetAddress != null) {
                        try {
                            object = inetAddress.getHostName();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    object = "localhost";
                    ILog.WARNING(WSHelper.class, (String)"Failed retrieving the local host name, \"localhost\" will be used as the external web server base name");
                }
            }
            if (bl) {
                object = "https://" + (String)object;
            } else if (n2 > 0) {
                object = "https://" + (String)object;
                if (n2 != 443) {
                    object = (String)object + ":" + n2;
                }
            } else {
                object = "http://" + (String)object;
                if (n > 0 && n != 80) {
                    object = (String)object + ":" + n;
                }
            }
        }
        return object;
    }

    public static String validateExternalHostName(String string) {
        URL uRL;
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            uRL = new URI(string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return "External host URL is a malformed URL: " + string;
        }
        String string2 = uRL.getProtocol();
        boolean bl = string2.equals("http");
        if (bl || string2.equals("https")) {
            int n = uRL.getPort();
            if (n >= 0) {
                if (bl && n == 80) {
                    return "External host URL should not specify port 80 for http://";
                }
                if (!bl && n == 443) {
                    return "External host URL should not specify port 443 for https://";
                }
            }
            if (!uRL.getPath().isEmpty()) {
                return "External host URL should not specify a path";
            }
            if (uRL.getQuery() != null) {
                return "External host URL should not specify a query";
            }
        } else {
            return "External host URL must specify http:// or https://";
        }
        return null;
    }

    public static String getDomain(HttpServletRequest httpServletRequest, int n, String string) {
        String string2;
        String string3 = WSHelper.getDomainFromURL(httpServletRequest);
        if (n > 0 && !string3.equals(string2 = WSHelper.getDomainFromHostHeader(httpServletRequest))) {
            String string4 = string + ": request does not match HTTP \"host\" header field: host = " + string2 + ", URL = " + String.valueOf(httpServletRequest.getRequestURL());
            if (n > 1) {
                ILog.SEVERE(WSHelper.class, (String)string4);
                string2 = null;
            } else {
                ILog.WARNING(WSHelper.class, (String)string4);
            }
        }
        return string3;
    }

    public static String getDomainFromURL(HttpServletRequest httpServletRequest) {
        String string;
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        String string2 = stringBuffer.substring(0, stringBuffer.indexOf(string = httpServletRequest.getRequestURI()));
        int n = string2.indexOf("://");
        if (n < 0) {
            return "unknown";
        }
        int n2 = string2.lastIndexOf(58);
        return n2 < (n += 3) || string2.indexOf(91, n2 + 1) > 0 ? string2.substring(n) : string2.substring(n, n2);
    }

    public static String getDomainFromHostHeader(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("host");
        if (string != null && !string.isEmpty()) {
            int n = string.lastIndexOf(58);
            return n < 0 || string.indexOf(91, n + 1) > 0 ? string : string.substring(0, n);
        }
        return httpServletRequest.getServerName();
    }

    static ServletHolder a(String string, boolean bl, boolean bl2, IExternalBrowserPages iExternalBrowserPages, ICommonServletInterface ... iCommonServletInterfaceArray) throws FileNotFoundException {
        b b2 = new b(string, iExternalBrowserPages, iCommonServletInterfaceArray);
        return WSHelper.a("default", "Default", (Servlet)b2, bl, bl2);
    }

    private static ServletHolder a(String string, String string2, Servlet servlet, boolean bl, boolean bl2) {
        ServletHolder servletHolder = new ServletHolder(string, servlet);
        servletHolder.setDisplayName(string2);
        servletHolder.setInitParameter("dirAllowed", Boolean.toString(bl));
        servletHolder.setInitParameter("etags", "true");
        servletHolder.setInitParameter("stylesheet", "/iz/css/dir.css");
        if (bl2) {
            servletHolder.setInitParameter("gzip", "true");
            servletHolder.setInitParameter("precompressed", "gzip=.gz");
        }
        return servletHolder;
    }

    static GzipHandler a(Handler handler) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(MIN_GZIP_SIZE);
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    static Resource a(File file) {
        try {
            return a.newResource(file.toPath());
        }
        catch (Throwable throwable) {
            ILog.WARNING(WSHelper.class, (String)"Web server resource file {} is not found", (Object[])new Object[]{file, throwable});
            return null;
        }
    }

    static boolean a(Throwable throwable) {
        if (throwable instanceof ClosedChannelException || throwable instanceof EOFException) {
            return true;
        }
        String string = throwable.getClass().getName();
        return string.endsWith(".UpgradeException") || string.endsWith(".WebSocketTimeoutException");
    }
}

