/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.plugin.statusbar;

import com.tabnine.eclipse.plugin.statusbar.TabnineStatusBarActions;
import com.tabnine.eclipse.plugin.statusbar.TabnineStatusBarState;
import com.tabnine.eclipse.shared.api.ConcurrentState;
import com.tabnine.eclipse.shared.api.services.ConfigService;
import java.util.Optional;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class TabnineStatusBar
extends WorkbenchWindowControlContribution
implements MouseListener {
    private static final String STATUS_BAR_ID = "tabnine-status-bar";
    private static final String STATUS_BAR_TOOLTIP_TEXT = "Tabnine (Click to open settings)";
    private CLabel statusBarLabel;
    private TabnineStatusBarState state = new TabnineStatusBarState();
    private Optional<ConcurrentState.Unsubscribe> unsubscribeFromStateChanges = Optional.empty();

    public TabnineStatusBar() {
        super(STATUS_BAR_ID);
    }

    protected Control createControl(Composite parent) {
        parent.getParent().setRedraw(true);
        this.statusBarLabel = new CLabel(parent, 32){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                size.x = 150;
                return size;
            }
        };
        this.statusBarLabel.setText(((TabnineStatusBarState.StatusBarStateData)this.state.getValue()).text);
        this.statusBarLabel.setImage(ConfigService.CONFIG.getTabnineIcon());
        this.statusBarLabel.setToolTipText(STATUS_BAR_TOOLTIP_TEXT);
        this.statusBarLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        this.statusBarLabel.addMouseListener((MouseListener)this);
        this.unsubscribeFromStateChanges = Optional.of(this.state.onChange(this::updateStatusBar));
        return this.statusBarLabel;
    }

    public boolean isDynamic() {
        return true;
    }

    public void updateStatusBar(TabnineStatusBarState.StatusBarStateData stateData) {
        this.statusBarLabel.getDisplay().asyncExec(() -> {
            this.statusBarLabel.setText(statusBarStateData.text);
            this.statusBarLabel.setImage(this.getIcon(statusBarStateData.isSnoozed));
            this.statusBarLabel.update();
        });
    }

    public void dispose() {
        this.statusBarLabel.removeMouseListener((MouseListener)this);
        super.dispose();
        this.statusBarLabel.dispose();
        this.unsubscribeFromStateChanges.ifPresent(ConcurrentState.Unsubscribe::unsubscribe);
        this.state.dispose();
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.openDropdownMenu();
    }

    private void openDropdownMenu() {
        MenuManager menuManager = new MenuManager();
        TabnineStatusBarActions.getActions().forEach(arg_0 -> ((MenuManager)menuManager).add(arg_0));
        CLabel control = this.statusBarLabel;
        Menu menu = menuManager.createContextMenu((Control)control);
        menu.setVisible(true);
    }

    private Image getIcon(boolean isSnoozed) {
        return isSnoozed ? ConfigService.CONFIG.getTabnineDisabledIcon() : ConfigService.CONFIG.getTabnineIcon();
    }
}

