/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.notifications.BinaryNotification;
import com.tabnine.eclipse.shared.api.binary.requests.notifications.NotificationsBinaryRequest;
import com.tabnine.eclipse.shared.api.binary.requests.notifications.NotificationsBinaryResponse;
import com.tabnine.eclipse.shared.d.a;
import com.tabnine.eclipse.shared.d.c;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryNotificationsService {
    private Logger logger = LogManager.getLogger(BinaryNotificationsService.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();
    private static BinaryNotificationsService instance;

    public static BinaryNotificationsService getInstance() {
        if (instance == null) {
            instance = new BinaryNotificationsService();
        }
        return instance;
    }

    public void poll() {
        try {
            NotificationsBinaryResponse notificationsBinaryResponse = this.binaryRequestFacade.executeRequest(new NotificationsBinaryRequest());
            if (notificationsBinaryResponse != null && notificationsBinaryResponse.getNotifications() != null) {
                notificationsBinaryResponse.getNotifications().stream().forEach(binaryNotification -> {
                    this.logger.info("Show binary notification. notification id: " + binaryNotification.id);
                    c.a(new a((BinaryNotification)binaryNotification));
                });
                return;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(() -> this.poll(), 0L, 10L, TimeUnit.SECONDS);
    }
}

