/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user;

import com.iizix.NotFoundException;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserAuthentication;
import com.iizix.urn.user.IUserProfileImageRequest;
import java.util.Objects;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UserProfileImageRequest
implements IUserProfileImageRequest {
    public static final double[] COMMON_DPRS_EMPTY = new double[0];
    private AuthenticatedUser a;
    private int a;
    private int b;
    private int c;
    private int d;
    private boolean a;
    private double[] a;
    private AppSessionGyro a;
    private ClientSessionGyro a;

    UserProfileImageRequest() {
    }

    public UserProfileImageRequest clone() {
        try {
            return (UserProfileImageRequest)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public UserProfileImageRequest currentClientSessionGyro() {
        ClientSessionGyro clientSessionGyro = ClientSessionGyro.getSessionInstance();
        if (clientSessionGyro == null) {
            throw new NotFoundException("Client Session Gyro not found from current thread");
        }
        this.a = clientSessionGyro;
        if (this.a == null) {
            this.a = clientSessionGyro.getAppSessionGyro();
        }
        return this;
    }

    public UserProfileImageRequest currentAppSessionGyro() {
        AppSessionGyro appSessionGyro = AppSessionGyro.getSessionInstance();
        if (appSessionGyro == null) {
            throw new NotFoundException("App Session Gyro not found from current thread");
        }
        this.a = appSessionGyro;
        if (this.a == null) {
            this.a = appSessionGyro.getAuthenticatedUser();
        }
        if (this.a == null) {
            this.a = ClientSessionGyro.getSessionInstance();
        }
        return this;
    }

    public UserProfileImageRequest appSessionGyro(IAppSessionGyro iAppSessionGyro) {
        this.a = (AppSessionGyro)Objects.requireNonNull(iAppSessionGyro);
        if (this.a == null) {
            this.a = ((AppSessionGyro)iAppSessionGyro).getAuthenticatedUser();
        }
        if (this.a == null && iAppSessionGyro == AppSessionGyro.getSessionInstance()) {
            this.a = ClientSessionGyro.getSessionInstance();
        }
        return this;
    }

    public UserProfileImageRequest clientSessionGyro(IClientSessionGyro iClientSessionGyro) {
        this.a = (ClientSessionGyro)Objects.requireNonNull(iClientSessionGyro);
        if (this.a == null) {
            this.a = this.a.getAppSessionGyro();
        }
        if (this.a == null) {
            this.a.getAppSessionGyro().getAuthenticatedUser();
        }
        return this;
    }

    public UserProfileImageRequest user(long l) throws NotFoundException {
        if (l < 0L) {
            throw new IllegalArgumentException("User ID is invalid, must be strictly positive: " + l);
        }
        AuthenticatedUser authenticatedUser = UserAuthentication.getInstance().getUser(l);
        if (authenticatedUser == null) {
            throw new NotFoundException("User ID " + l + " is not found");
        }
        this.a = authenticatedUser;
        return this;
    }

    public UserProfileImageRequest user(String string) {
        this.a = UserAuthentication.getInstance().getUser(string);
        return this;
    }

    public UserProfileImageRequest size(int n) {
        if (n < 16 || n > 400) {
            throw new IllegalArgumentException("Invalid height (16-400): " + this.b);
        }
        this.a = this.b = n;
        return this;
    }

    public UserProfileImageRequest size(int n, int n2) {
        if (n < 16 || n > 400) {
            throw new IllegalArgumentException("Invalid width (16-400): " + n);
        }
        if (n2 < 16 || n2 > 400) {
            throw new IllegalArgumentException("Invalid height (16-400): " + n2);
        }
        this.a = n;
        this.b = n2;
        return this;
    }

    public UserProfileImageRequest quality(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("quality must be in range 0-100: " + n);
        }
        this.c = n;
        return this;
    }

    public UserProfileImageRequest circle() {
        this.d = -1;
        return this;
    }

    public UserProfileImageRequest circle(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid size (16-400): " + n);
        }
        this.a = this.b = n;
        this.d = -1;
        return this;
    }

    public UserProfileImageRequest corners(int n) {
        this.d = n < 0 ? -1 : n;
        return this;
    }

    public UserProfileImageRequest DRPs(double[] dArray) {
        if (dArray == null) {
            double[] dArray2;
            ClientSessionGyro clientSessionGyro = this.a;
            if (clientSessionGyro != null) {
                double[] dArray3 = new double[2];
                dArray3[0] = 1.0;
                dArray2 = dArray3;
                dArray3[1] = clientSessionGyro.getEnvironment().getDPR();
            } else {
                dArray2 = AuthenticatedUser.a;
            }
            dArray = dArray2;
        } else {
            dArray = dArray == COMMON_DPRS_EMPTY ? AuthenticatedUser.b : (double[])dArray.clone();
        }
        this.a = dArray;
        return this;
    }

    public UserProfileImageRequest createDefault(boolean bl) {
        this.a = bl;
        return this;
    }

    public AppSessionGyro getAppSessionGyro() {
        return this.a;
    }

    public ClientSessionGyro getClientSessionGyro() {
        return this.a;
    }

    public AuthenticatedUser getUser() {
        return this.a;
    }

    public long getUserID() {
        AuthenticatedUser authenticatedUser = this.a;
        return authenticatedUser != null ? authenticatedUser.getBasicUserInfo().id : -1L;
    }

    public String getUserName() {
        return null;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public int getQuality() {
        return this.c;
    }

    public int getCorners() {
        return this.d;
    }

    public boolean isCircle() {
        return this.d < 0;
    }

    public boolean doCreateDefault() {
        return this.a;
    }

    public double[] getDPRs() {
        double[] dArray = this.a;
        if (dArray == null) {
            dArray = AuthenticatedUser.a;
        }
        return (double[])dArray.clone();
    }
}

