/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.agreement;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.server.db.DBFunctions;
import java.io.File;
import java.nio.file.Files;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LicenseAgreement {
    final long a;
    final String a;
    final String b;
    final String c;
    final long b;
    final long c;
    private String d;

    LicenseAgreement(long l, String string, String string2, long l2, String string3, long l3, String string4) {
        this.a = l;
        this.a = string;
        this.b = string2;
        this.b = l2;
        this.c = string3;
        this.c = l3;
        this.d = string4;
    }

    public boolean isNotApplicable() {
        return this.a.equals("n/a");
    }

    public synchronized String getAgreementText() {
        if (this.d == null) {
            this.d = "Failed loading agreement";
            try {
                DBFunctions.execute(connection -> {
                    block19: {
                        String string = "SELECT text FROM IZS.AGREEMENTS WHERE id=" + this.a + " AND name=? AND languageCode=?";
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                            preparedStatement.setString(1, this.a);
                            preparedStatement.setString(2, this.b);
                            Throwable throwable2 = null;
                            Object var7_10 = null;
                            try (ResultSet resultSet = preparedStatement.executeQuery();){
                                if (resultSet.next()) {
                                    this.d = resultSet.getString(1);
                                    break block19;
                                }
                                throw new SQLException("Failed locating agreement in database, deleted?");
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    connection.commit();
                    return null;
                });
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)("Failed loading license agreement ID " + this.a + " named " + this.a + " in language code " + this.b), (Throwable)throwable);
            }
        }
        return this.d;
    }

    public String toString() {
        String string = this.getClass().getName() + "[id=" + this.a + ",name=+" + this.a + ",languageCode=+" + this.b + ",description=+" + this.c + ",created=+" + (this.b > 0L ? Utilities.formatDate((long)this.b) : "n/a");
        if (this.c > 0L) {
            string = string + ",updatedBy=" + this.c;
        }
        return string + ",text=[" + this.d + "]]";
    }

    public static LicenseAgreement createLicenseAgreement(String string, String string2, String string3, String string4) throws SQLException, NotFoundException {
        String string5 = string2.replace('_', '-').toLowerCase().trim();
        return DBFunctions.execute(connection -> {
            AutoCloseable autoCloseable;
            PreparedStatement preparedStatement;
            Object object;
            Object object2;
            Object object3 = "SELECT MAX(id) FROM IZS.AGREEMENTS WHERE lang_code=?";
            long l = 1L;
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                object2 = connection.prepareStatement((String)object3);
                try {
                    object2.setString(1, string5);
                    object = null;
                    preparedStatement = null;
                    try {
                        autoCloseable = object2.executeQuery();
                        try {
                            if (autoCloseable.next()) {
                                l = autoCloseable.getLong(1) + 1L;
                            }
                        }
                        finally {
                            if (autoCloseable != null) {
                                autoCloseable.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (object == null) {
                            object = throwable2;
                        } else if (object != throwable2) {
                            ((Throwable)object).addSuppressed(throwable2);
                        }
                        throw object;
                    }
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            System.out.println("Found next ID = " + l + " for language code = '" + string5 + "'");
            long l2 = System.currentTimeMillis();
            object3 = "INSERT INTO IZS.AGREEMENTS (id,name,lang_code,created,descr,text) VALUES (" + l + ",?,?," + l2 + ",?,?)";
            object2 = null;
            object = null;
            try {
                preparedStatement = connection.prepareStatement((String)object3);
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string5);
                    preparedStatement.setString(3, string3);
                    preparedStatement.setString(4, string4.replace("\r\n", "\n").replace('\r', '\n'));
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (object2 == null) {
                    object2 = throwable4;
                } else if (object2 != throwable4) {
                    ((Throwable)object2).addSuppressed(throwable4);
                }
                throw object2;
            }
            int n = 0;
            object3 = "UPDATE IZS.AGREEMENTS SET updated_by_id=" + l + " WHERE updated_by_id!=0 AND name=? AND lang_code=?";
            object = null;
            preparedStatement = null;
            try {
                autoCloseable = connection.prepareStatement((String)object3);
                try {
                    autoCloseable.setString(1, string);
                    autoCloseable.setString(2, string5);
                    n = autoCloseable.executeUpdate();
                }
                finally {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (object == null) {
                    object = throwable5;
                } else if (object != throwable5) {
                    ((Throwable)object).addSuppressed(throwable5);
                }
                throw object;
            }
            connection.commit();
            object = n == 0 ? "" : (n == 1 ? ", replacing " + n + " agreeement: " : ", replacing " + n + " agreeements");
            ILog.INFO(LicenseAgreement.class, (String)("Added license agreement ID " + l + " named " + string + " in language code " + string5 + (String)object + ":\n    " + string4.replace("\n", "\n    ")));
            return new LicenseAgreement(l, string, string5, l2, string3, 0L, string4);
        });
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4 || stringArray.length % 2 > 0) {
            System.out.println("LicenseAgreement: syntax: LicenseAgreement 'name' 'descr' 'languageCode' 'fileName' ['languageCode' 'fileName'] ...");
            System.exit(9);
        } else {
            String string = stringArray[0];
            String string2 = stringArray[1];
            int n = 2;
            while (n < stringArray.length) {
                String string3 = stringArray[n++].toLowerCase().replace('_', '-');
                String string4 = stringArray[n++];
                Locale locale = Locale.forLanguageTag(string3.replace('-', '_'));
                if (!locale.toLanguageTag().replace('_', '-').equalsIgnoreCase(string3)) {
                    System.err.println("Language code '" + string3 + "' is not found, but " + locale.toLanguageTag() + " was found instead");
                    System.exit(1);
                }
                System.out.println("LicenseAgreement creation:");
                File file = Utilities.getCanonicalFile((File)new File(string4));
                try {
                    String string5 = Files.readString(file.toPath(), Utilities.UTF8);
                    LicenseAgreement licenseAgreement = LicenseAgreement.createLicenseAgreement(string, string3, string2, string5);
                    System.out.println("\nAdded license agreement:\n" + String.valueOf(licenseAgreement));
                }
                catch (Throwable throwable) {
                    System.err.println("Failure to add agreement '" + string + "', language code '" + string3 + "', descr='" + string2 + "' to file " + file.getPath());
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }
}

