/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.plugin.logging;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.eclipse.core.runtime.Platform;

@Plugin(name="TabnineAppender", elementType="appender", category="Core")
public class TabnineAppender
extends AbstractAppender {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(10);
    public static final String LOGGER_HOST = "https://ide-logs-gateway.tabnine.com";

    protected TabnineAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    @PluginFactory
    public static TabnineAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new TabnineAppender(name, filter, null, true, null);
    }

    private JsonObject buildRequestBaseBody() {
        JsonObject body = new JsonObject();
        body.addProperty("appName", "tabnine-plugin-Eclipse");
        body.addProperty("category", "extensions");
        body.addProperty("ideVersion", Platform.getBundle((String)"org.eclipse.platform").getVersion().toString());
        body.addProperty("os", System.getProperty("os.name"));
        return body;
    }

    public void append(LogEvent event) {
        HttpPost postRequest = this.buildPostRequest(event);
        executorService.submit(() -> {
            try {
                if (postRequest == null) {
                    return;
                }
                HttpClients.createDefault().execute((HttpUriRequest)postRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private HttpPost buildPostRequest(LogEvent event) {
        try {
            HttpPost postRequest = new HttpPost(String.format("%s/logs/%s", LOGGER_HOST, event.getLevel()));
            JsonObject requestBody = this.buildRequestBaseBody();
            requestBody.addProperty("message", event.getMessage().getFormat());
            if (event.getThrown() != null) {
                requestBody.addProperty("error_message", event.getThrown().getMessage().toString());
                requestBody.addProperty("error_type", event.getThrown().getClass().toString());
            }
            postRequest.setEntity((HttpEntity)new StringEntity(requestBody.toString()));
            postRequest.setHeader("Content-Type", "application/json");
            return postRequest;
        }
        catch (Exception e) {
            return null;
        }
    }
}

