/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.ILog;
import com.iizix.LocaleInfo;
import com.iizix.value.IValueObject;
import java.text.Format;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import org.w3c.dom.Element;

public abstract class TermporalAccessorValue<TYPE extends TemporalAccessor>
implements IValueObject<TYPE> {
    public static ZoneOffset _getSystemZoneOffset() {
        ZoneId zoneId = ZoneId.systemDefault().normalized();
        if (zoneId instanceof ZoneOffset) {
            return (ZoneOffset)zoneId;
        }
        ILog.WARNING(TermporalAccessorValue.class, "Failed to retrive system ZoneOffset");
        return ZoneOffset.UTC;
    }

    DateTimeFormatter a(String string, LocaleInfo localeInfo, boolean bl) {
        ResolverStyle resolverStyle;
        block77: {
            String string2;
            if (string.isEmpty()) {
                return localeInfo.getDateTimeFormatter("");
            }
            resolverStyle = null;
            if (string.charAt(0) != '[') break block77;
            int n2 = string.indexOf(93, 1);
            if (n2 < 0) {
                return localeInfo.getDateTimeFormatter(string);
            }
            switch (string2 = string.substring(1, n2)) {
                case "strict": {
                    resolverStyle = ResolverStyle.STRICT;
                    string = string.substring(n2 + 1);
                    break;
                }
                case "smart": {
                    resolverStyle = ResolverStyle.SMART;
                    string = string.substring(n2 + 1);
                    break;
                }
                case "lenient": {
                    resolverStyle = ResolverStyle.LENIENT;
                    string = string.substring(n2 + 1);
                    break;
                }
                default: {
                    break block77;
                }
            }
            string = string.substring(n2 + 1);
        }
        DateTimeFormatter dateTimeFormatter = switch (string) {
            case "short" -> localeInfo.getDateTimeFormatter(FormatStyle.SHORT);
            case "medium" -> localeInfo.getDateTimeFormatter(FormatStyle.MEDIUM);
            case "long" -> localeInfo.getDateTimeFormatter(FormatStyle.LONG);
            case "full" -> localeInfo.getDateTimeFormatter(FormatStyle.FULL);
            case "BASIC_ISO_DATE" -> DateTimeFormatter.BASIC_ISO_DATE;
            case "ISO_LOCAL_DATE" -> DateTimeFormatter.ISO_LOCAL_DATE;
            case "ISO_OFFSET_DATE" -> DateTimeFormatter.ISO_OFFSET_DATE;
            case "ISO_DATE" -> DateTimeFormatter.ISO_DATE;
            case "ISO_LOCAL_TIME" -> DateTimeFormatter.ISO_LOCAL_TIME;
            case "ISO_OFFSET_TIME" -> DateTimeFormatter.ISO_OFFSET_TIME;
            case "ISO_TIME" -> DateTimeFormatter.ISO_TIME;
            case "ISO_LOCAL_DATE_TIME" -> DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            case "ISO_OFFSET_DATE_TIME" -> DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            case "ISO_ZONED_DATE_TIME" -> DateTimeFormatter.ISO_ZONED_DATE_TIME;
            case "ISO_DATE_TIME" -> DateTimeFormatter.ISO_DATE_TIME;
            case "ISO_ORDINAL_DATE" -> DateTimeFormatter.ISO_ORDINAL_DATE;
            case "ISO_WEEK_DATE" -> DateTimeFormatter.ISO_WEEK_DATE;
            case "ISO_INSTANT" -> DateTimeFormatter.ISO_INSTANT;
            case "RFC_1123_DATE_TIME" -> DateTimeFormatter.RFC_1123_DATE_TIME;
            default -> localeInfo.getDateTimeFormatter(string);
        };
        if (bl && resolverStyle != null) {
            dateTimeFormatter = dateTimeFormatter.withResolverStyle(resolverStyle);
        }
        return dateTimeFormatter;
    }

    @Override
    public final Format getFormatter(String string, LocaleInfo localeInfo) {
        if (string == null) {
            return null;
        }
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(true);
        }
        DateTimeFormatter dateTimeFormatter = this.a(string, localeInfo, true);
        return dateTimeFormatter.toFormat();
    }

    @Override
    public final String toString(TYPE TYPE) {
        return String.valueOf(TYPE);
    }

    @Override
    public String toString(TYPE TYPE, String string, LocaleInfo localeInfo) {
        if (string == null) {
            return String.valueOf(TYPE);
        }
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(true);
        }
        DateTimeFormatter dateTimeFormatter = this.a(string, localeInfo, false);
        return dateTimeFormatter.format((TemporalAccessor)TYPE);
    }

    public abstract TYPE parse(String var1, DateTimeFormatter var2) throws ParseException, Exception;

    @Override
    public final TYPE parse(String string, String string2, LocaleInfo localeInfo) throws ParseException, Exception {
        if (string2 == null) {
            return (TYPE)((TemporalAccessor)this.parse(string));
        }
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(true);
        }
        DateTimeFormatter dateTimeFormatter = this.a(string2, localeInfo, true);
        return this.parse(string, dateTimeFormatter);
    }

    @Override
    public final TYPE load(String string, Element element) throws Exception {
        return (TYPE)((TemporalAccessor)this.parse(string));
    }

    @Override
    public final String save(TYPE TYPE, Element element) throws Exception {
        return TYPE.toString();
    }
}

