/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class FloatValue
extends NumberValue<Float> {
    private static final Float a = Float.valueOf(0.0f);

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Float;
    }

    @Override
    public Class<Float> getValueClass() {
        return Float.class;
    }

    @Override
    public String getDescription() {
        return "Single precision floating point number";
    }

    @Override
    public Float createDefault() {
        return a;
    }

    @Override
    public Float parse(String string) throws NumberFormatException {
        return Float.valueOf(string);
    }

    @Override
    public Float convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 > 3.4028234663852886E38 || d2 < -3.4028234663852886E38) {
                throw new ArithmeticException("Value out of Float range: " + String.valueOf(object));
            }
            return Float.valueOf((float)d2);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return Float.valueOf(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

