/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.BooleanFormat;
import com.iizix.value.IValueObject;
import java.text.Format;
import java.text.ParseException;
import org.w3c.dom.Element;

public class BooleanValue
implements IValueObject<Boolean> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.Boolean;
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public String getDescription() {
        return "Boolean (true or false)";
    }

    @Override
    public Boolean createDefault() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean parse(String string) {
        return (string = string.trim()).equalsIgnoreCase("true") || string.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean parse(String string, String string2, LocaleInfo localeInfo) throws ParseException {
        Format format;
        if (string2 != null && (format = this.getFormatter(string2, localeInfo)) != null) {
            return (Boolean)format.parseObject(string);
        }
        return this.parse(string);
    }

    @Override
    public Format getFormatter(String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        return new BooleanFormat(string);
    }

    @Override
    public String toString(Boolean bl) {
        return String.valueOf(bl);
    }

    @Override
    public String toString(Boolean bl, String string, LocaleInfo localeInfo) {
        if (string != null) {
            return this.getFormatter(string, localeInfo).format(bl);
        }
        return String.valueOf(bl);
    }

    @Override
    public Boolean load(String string, Element element) throws Exception {
        return string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String save(Boolean bl, Element element) throws Exception {
        return bl.toString();
    }

    @Override
    public Boolean convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() == 1L ? Boolean.TRUE : Boolean.FALSE;
        }
        String string = (type != null ? type.valueObject.toStringForced(object) : String.valueOf(object)).trim();
        return string.equalsIgnoreCase("true") || string.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public long asLong(Boolean bl, LocaleInfo localeInfo) {
        return bl != false ? 1L : 0L;
    }
}

