/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.push.vapid;

import com.iizix.push.vapid.Encoding;
import com.iizix.push.vapid.Encrypted;
import com.iizix.push.vapid.HttpEce;
import com.iizix.push.vapid.HttpRequest;
import com.iizix.push.vapid.Notification;
import com.iizix.push.vapid.Utils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.HashMap;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractPushService<T extends AbstractPushService<T>> {
    private static final SecureRandom a = new SecureRandom();
    public static final String SERVER_KEY_ID = "server-key-id";
    public static final String SERVER_KEY_CURVE = "P-256";
    private String a;
    private String b;
    private PublicKey a;
    private PrivateKey a;

    public AbstractPushService() {
    }

    public AbstractPushService(String string) {
        this.a = string;
    }

    public AbstractPushService(KeyPair keyPair) {
        this.a = keyPair.getPublic();
        this.a = keyPair.getPrivate();
    }

    public AbstractPushService(KeyPair keyPair, String string) {
        this(keyPair);
        this.b = string;
    }

    public AbstractPushService(String string, String string2) throws GeneralSecurityException {
        this.a = Utils.loadPublicKey(string);
        this.a = Utils.loadPrivateKey(string2);
    }

    public AbstractPushService(String string, String string2, String string3) throws GeneralSecurityException {
        this(string, string2);
        this.b = string3;
    }

    public static Encrypted encrypt(byte[] byArray, ECPublicKey eCPublicKey, byte[] byArray2, Encoding encoding) throws GeneralSecurityException {
        KeyPair keyPair = AbstractPushService.a();
        HashMap<String, KeyPair> hashMap = new HashMap<String, KeyPair>();
        hashMap.put(SERVER_KEY_ID, keyPair);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put(SERVER_KEY_ID, SERVER_KEY_CURVE);
        byte[] byArray3 = new byte[16];
        a.nextBytes(byArray3);
        HttpEce httpEce = new HttpEce(hashMap, hashMap2);
        byte[] byArray4 = httpEce.encrypt(byArray, byArray3, null, SERVER_KEY_ID, eCPublicKey, byArray2, encoding);
        return new Encrypted.Builder().withSalt(byArray3).withPublicKey(keyPair.getPublic()).withCiphertext(byArray4).build();
    }

    private static KeyPair a() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)eCNamedCurveParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    protected final HttpRequest prepareRequest(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        if (this.getPrivateKey() != null && this.getPublicKey() != null && !Utils.verifyKeyPair(this.getPrivateKey(), this.getPublicKey())) {
            throw new IllegalStateException("Public key and private key do not match.");
        }
        Encrypted encrypted = AbstractPushService.encrypt(notification.getPayload(), notification.getUserPublicKey(), notification.getUserAuth(), encoding);
        byte[] byArray = Utils.encode((ECPublicKey)encrypted.getPublicKey());
        byte[] byArray2 = encrypted.getSalt();
        String string = notification.getEndpoint();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray3 = null;
        hashMap.put("TTL", String.valueOf(notification.getTTL()));
        if (notification.hasUrgency()) {
            hashMap.put("Urgency", notification.getUrgency().getHeaderValue());
        }
        if (notification.hasTopic()) {
            hashMap.put("Topic", notification.getTopic());
        }
        if (notification.hasPayload()) {
            hashMap.put("Content-Type", "application/octet-stream");
            if (encoding == Encoding.AES128GCM) {
                hashMap.put("Content-Encoding", "aes128gcm");
            } else if (encoding == Encoding.AESGCM) {
                hashMap.put("Content-Encoding", "aesgcm");
                hashMap.put("Encryption", "salt=" + Base64.getUrlEncoder().withoutPadding().encodeToString(byArray2));
                hashMap.put("Crypto-Key", "dh=" + Base64.getUrlEncoder().encodeToString(byArray));
            }
            byArray3 = encrypted.getCiphertext();
        }
        if (notification.isGcm()) {
            if (this.getGcmApiKey() == null) {
                throw new IllegalStateException("An GCM API key is needed to send a push notification to a GCM endpoint.");
            }
            hashMap.put("Authorization", "key=" + this.getGcmApiKey());
        } else if (this.vapidEnabled()) {
            if (encoding == Encoding.AES128GCM && notification.getEndpoint().startsWith("https://fcm.googleapis.com")) {
                string = notification.getEndpoint().replace("fcm/send", "wp");
            }
            JwtClaims jwtClaims = new JwtClaims();
            jwtClaims.setAudience(notification.getOrigin());
            jwtClaims.setExpirationTimeMinutesInTheFuture(720.0f);
            if (this.getSubject() != null) {
                jwtClaims.setSubject(this.getSubject());
            }
            JsonWebSignature jsonWebSignature = new JsonWebSignature();
            jsonWebSignature.setHeader("typ", "JWT");
            jsonWebSignature.setHeader("alg", "ES256");
            jsonWebSignature.setPayload(jwtClaims.toJson());
            jsonWebSignature.setKey((Key)this.getPrivateKey());
            jsonWebSignature.setAlgorithmHeaderValue("ES256");
            byte[] byArray4 = Utils.encode((ECPublicKey)this.getPublicKey());
            if (encoding == Encoding.AES128GCM) {
                hashMap.put("Authorization", "vapid t=" + jsonWebSignature.getCompactSerialization() + ", k=" + Base64.getUrlEncoder().withoutPadding().encodeToString(byArray4));
            } else if (encoding == Encoding.AESGCM) {
                hashMap.put("Authorization", "WebPush " + jsonWebSignature.getCompactSerialization());
            }
            if (hashMap.containsKey("Crypto-Key")) {
                hashMap.put("Crypto-Key", (String)hashMap.get("Crypto-Key") + ";p256ecdsa=" + Base64.getUrlEncoder().encodeToString(byArray4));
            } else {
                hashMap.put("Crypto-Key", "p256ecdsa=" + Base64.getUrlEncoder().encodeToString(byArray4));
            }
        } else if (notification.isFcm() && this.getGcmApiKey() != null) {
            hashMap.put("Authorization", "key=" + this.getGcmApiKey());
        }
        return new HttpRequest(string, hashMap, byArray3);
    }

    public T setGcmApiKey(String string) {
        this.a = string;
        return (T)this;
    }

    public String getGcmApiKey() {
        return this.a;
    }

    public String getSubject() {
        return this.b;
    }

    public T setSubject(String string) {
        this.b = string;
        return (T)this;
    }

    public T setKeyPair(KeyPair keyPair) {
        this.setPublicKey(keyPair.getPublic());
        this.setPrivateKey(keyPair.getPrivate());
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.a;
    }

    public T setPublicKey(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPublicKey(Utils.loadPublicKey(string));
        return (T)this;
    }

    public PrivateKey getPrivateKey() {
        return this.a;
    }

    public KeyPair getKeyPair() {
        return new KeyPair(this.a, this.a);
    }

    public T setPublicKey(PublicKey publicKey) {
        this.a = publicKey;
        return (T)this;
    }

    public T setPrivateKey(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPrivateKey(Utils.loadPrivateKey(string));
        return (T)this;
    }

    public T setPrivateKey(PrivateKey privateKey) {
        this.a = privateKey;
        return (T)this;
    }

    protected boolean vapidEnabled() {
        return this.a != null && this.a != null;
    }
}

