/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.event.RemoteEvent;
import com.iizix.gyro.FocusException;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.Atom;
import com.iizix.prop.IPropReference;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSRelativeReference;

public class VSOnUIEvent
extends VSRelativeReference<VSComponent> {
    public VSOnUIEvent() {
    }

    public VSOnUIEvent(Atom atom) {
        super(atom);
    }

    @Override
    protected boolean isPropPrivateAtCreation() {
        return false;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        sendTransaction.appendString("");
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        readTransaction.readString();
        return false;
    }

    @Override
    public Class<VSComponent> getPropertyClass() {
        return VSComponent.class;
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.VSOnUIEvent;
    }

    @Override
    protected void onResolved(VSComponent vSComponent) {
    }

    @Override
    protected void onRemoved(VSComponent vSComponent) {
    }

    @Override
    public void onRemoteEvent(RemoteEvent remoteEvent) {
        if (remoteEvent.getLocalID() == 1) {
            this.d();
        } else {
            super.onRemoteEvent(remoteEvent);
        }
    }

    private void d() {
        IClientSessionGyro iClientSessionGyro = this.getClientSessionGyro();
        if (iClientSessionGyro != null) {
            Object TARGET = this.getVSTarget();
            IAppSessionGyro iAppSessionGyro = iClientSessionGyro.getAppSessionGyro();
            if (iAppSessionGyro != null && TARGET != null) {
                Object TARGET2 = iAppSessionGyro.getVirtualizedVSComponent(TARGET);
                if (TARGET2 == null) {
                    ILog.SEVERE(this.getClass(), "Failed locating virtualized component of " + String.valueOf(TARGET));
                } else if (TARGET2 instanceof VSAction) {
                    VSAction vSAction2 = (VSAction)TARGET2;
                    String string = vSAction2.invoke(iClientSessionGyro, this, true, (vSAction, vSActionTXProcess, throwable) -> iClientSessionGyro.exitClientLock());
                    if (string != null) {
                        ILog.WARNING(this.getClass(), string, (Object)("Action " + this.getReferencePropName() + ": " + String.valueOf(this)));
                        iClientSessionGyro.exitClientLock();
                    }
                } else {
                    try {
                        try {
                            ((PropCnr)TARGET2).requestFocusEx(this, true);
                        }
                        catch (FocusException focusException) {
                            ILog.SEVERE(this.getClass(), "Failed setting focus to VS component", "Source = " + String.valueOf(this), "Target = " + String.valueOf(TARGET2));
                            iClientSessionGyro.exitClientLock();
                        }
                    }
                    finally {
                        iClientSessionGyro.exitClientLock();
                    }
                }
            }
        }
    }
}

