/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.NotFoundException;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.DoubleProp;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.IUILabelForTarget;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.value.IUIDoubleRangeValueComponent;
import com.iizix.prop.vs.VSField;

public class UISlider
extends UIComp
implements IUIContextMenuOwner,
IUIFocusComp,
IUILabelForTarget,
IUIDoubleRangeValueComponent {
    public UISlider() {
    }

    public UISlider(Atom atom) {
        super(atom);
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return false;
    }

    public int getOrientation() {
        return this.getInt("orientation");
    }

    @Override
    public boolean canFillX() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean canFillY() {
        return this.getOrientation() != 0;
    }

    @Override
    public boolean canAlignX() {
        return this.getOrientation() != 0;
    }

    @Override
    public boolean canAlignY() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean hasImplicitAlignFillY() {
        return this.getOrientation() != 0;
    }

    @Override
    public int setComponentToVSField() {
        VSField vSField = this.vsField;
        if (this.enterVSProcessing(vSField)) {
            try {
                double d2 = this.getValue();
                vSField.set_Double((Double)d2, this);
                this.setVSFieldMessageToComponent(vSField, true);
                return 1;
            }
            catch (NotFoundException notFoundException) {
            }
            catch (ValueConversionException valueConversionException) {
                this.setErrorMessage(valueConversionException);
                return -1;
            }
            finally {
                this.exitVSProcessing();
            }
        }
        return 0;
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        if (vSField == this.vsField && this.enterVSProcessing(vSField)) {
            try {
                try {
                    this.setValue(vSField.get_Double());
                }
                catch (ValueConversionException valueConversionException) {
                    this.setErrorMessage(valueConversionException);
                    this.exitVSProcessing();
                }
            }
            finally {
                this.exitVSProcessing();
            }
        }
    }

    public int getTicks() {
        int n2 = this.getInt("ticks", 0);
        return n2 > 1 ? n2 : 0;
    }

    public boolean setTicks(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Ticks is lower than zero");
        }
        if (n2 == 1) {
            throw new IllegalArgumentException("Ticks cannot be set to 1");
        }
        return this.setInt("ticks", n2);
    }

    public int getPageIncrement() {
        return this.getInt("pageIncrement", 5);
    }

    public boolean setPageIncrement(int n2) throws IllegalArgumentException {
        int n3 = this.getTicks();
        if (n2 < 0 || n3 != 0 && n2 > n3) {
            throw new IllegalArgumentException("Page increment is bigger than discrete values");
        }
        return this.setInt("pageIncrement", n2);
    }

    @Override
    public double getMinimumDefault() {
        return 0.0;
    }

    @Override
    public double getMaximumDefault() {
        return 100.0;
    }

    @Override
    public double getDefaultValue() {
        return this.getMinimum();
    }

    public boolean getShowButtons() {
        return this.getBool("showButtons", true);
    }

    public boolean setShowButtons(boolean bl) {
        return this.setBool("showButtons", bl);
    }

    public boolean getClickSelect() {
        return this.getBool("clickSelect", true);
    }

    public boolean setClickSelect(boolean bl) {
        return this.setBool("clickSelect", bl);
    }

    public int getSlideDuration() {
        return this.getInt("slideDuration", 500);
    }

    public boolean setMaximalLength(int n2) {
        return this.setInt("slideDuration", n2);
    }

    @Override
    public Size getApproximateSize() {
        return new Size(200, this.isMobile() ? 24 : 16);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        double d2;
        NumberProp numberProp;
        double d3;
        GProp gProp;
        int n2;
        if (!super.verify(propVerification)) {
            return false;
        }
        if (!this.isMobile() && (n2 = this.getInt("ticks", 0)) > 0) {
            gProp = this.getProp("ticks", IntProp.class);
            if (n2 == 1) {
                propVerification.add(new PropVerificationError("tics", PropVerificationError.Severity.ERROR, "Ticks", gProp, "Ticks (discrete values), cannot be '1' (one) as this means the slider only has one value", "DeleteProperty"));
            } else {
                int n3 = this.getPageIncrement();
                if (n2 < n3) {
                    if (gProp == null) {
                        propVerification.add(new PropVerificationError((PropCnr)this, "tics", PropVerificationError.Severity.ERROR, "Ticks", "Ticks (discrete values), must be larger than the page increment value (or scale must be continuous)", "DeleteProperty"));
                    } else {
                        propVerification.add(new PropVerificationError("tics", PropVerificationError.Severity.ERROR, "Ticks", gProp, "Ticks (discrete values), must be larger than the page increment value (or scale must be continuous)", "DeleteProperty"));
                    }
                }
            }
        }
        NumberProp numberProp2 = this.getProp("max", NumberProp.class);
        gProp = this.getProp("min", NumberProp.class);
        double d4 = numberProp2 != null ? numberProp2.getDouble(100.0) : 100.0;
        double d5 = d3 = gProp != null ? ((DoubleProp)gProp).getDouble(0.0) : 0.0;
        if (d3 >= d4) {
            if (numberProp2 != null) {
                propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.ERROR, "Maximum value", numberProp2, "Maximum value must be larger than minimum value (" + d3 + ")", "DeleteProperty"));
            } else if (gProp != null) {
                propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.ERROR, "Minimum value", gProp, "Minimum value must be smaller than maximum value (" + d4 + ")", "DeleteProperty"));
            }
        }
        if ((numberProp = this.getProp(Atom.VALUE, NumberProp.class)) != null && !Double.isNaN(d2 = numberProp.getDouble(Double.NaN))) {
            String string = null;
            if (d2 < d3) {
                string = "Value must be equal or greater than " + d3;
            } else if (d2 > d4) {
                string = "Value must be equal or smaller than " + d4;
            }
            if (string != null) {
                propVerification.add(new PropVerificationError("valueRange", PropVerificationError.Severity.ERROR, "Value", numberProp, string, "DeleteProperty"));
            }
        }
        return true;
    }
}

