/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GColor
implements Cloneable {
    public static final GColor NONE = new GColor(0, true);
    public static final GColor INHERIT = new GColor();
    private static final String[] a = new String[]{"AliceBlueF0F8FF", "AntiqueWhiteFAEBD7", "Aqua00FFFF", "Aquamarine7FFFD4", "AzureF0FFFF", "BeigeF5F5DC", "BisqueFFE4C4", "Black000000", "BlanchedAlmondFFEBCD", "Blue0000FF", "BlueViolet8A2BE2", "BrownA52A2A", "BurlyWoodDEB887", "CadetBlue5F9EA0", "Chartreuse7FFF00", "ChocolateD2691E", "CoralFF7F50", "CornflowerBlue6495ED", "CornsilkFFF8DC", "CrimsonDC143C", "Cyan00FFFF", "DarkBlue00008B", "DarkCyan008B8B", "DarkGoldenrodB8860B", "DarkGrayA9A9A9", "DarkGreen006400", "DarkKhakiBDB76B", "DarkMagenta8B008B", "DarkOliveGreen556B2F", "DarkOrangeFF8C00", "DarkOrchid9932CC", "DarkRed8B0000", "DarkSalmonE9967A", "DarkSeaGreen8FBC8F", "DarkSlateBlue483D8B", "DarkSlateGray2F4F4F", "DarkTurquoise00CED1", "DarkViolet9400D3", "DeepPinkFF1493", "DeepSkyBlue00BFFF", "DimGray696969", "DodgerBlue1E90FF", "FireBrickB22222", "FloralWhiteFFFAF0", "ForestGreen228B22", "FuchsiaFF00FF", "GainsboroDCDCDC", "GhostWhiteF8F8FF", "GoldFFD700", "GoldenrodDAA520", "Gray808080", "Green008000", "GreenYellowADFF2F", "HoneydewF0FFF0", "HotPinkFF69B4", "IndianRedCD5C5C", "Indigo4B0082", "IvoryFFFFF0", "KhakiF0E68C", "LavenderE6E6FA", "LavenderBlushFFF0F5", "LawnGreen7CFC00", "LemonChiffonFFFACD", "LightBlueADD8E6", "LightCoralF08080", "LightCyanE0FFFF", "LightGoldenrodYellowFAFAD2", "LightGreen90EE90", "LightGreyD3D3D3", "LightPinkFFB6C1", "LightSalmonFFA07A", "LightSeaGreen20B2AA", "LightSkyBlue87CEFA", "LightSlateGray778899", "LightSteelBlueB0C4DE", "LightYellowFFFFE0", "Lime00FF00", "LimeGreen32CD32", "LinenFAF0E6", "MagentaFF00FF", "Maroon800000", "MediumAquamarine66CDAA", "MediumBlue0000CD", "MediumOrchidBA55D3", "MediumPurple9370DB", "MediumSeaGreen3CB371", "MediumSlateBlue7B68EE", "MediumSpringGreen00FA9A", "MediumTurquoise48D1CC", "MediumVioletRedC71585", "MidnightBlue191970", "MintCreamF5FFFA", "MistyRoseFFE4E1", "MoccasinFFE4B5", "NavajoWhiteFFDEAD", "Navy000080", "OldLaceFDF5E6", "Olive808000", "OliveDrab6B8E23", "OrangeFFA500", "OrangeRedFF4500", "OrchidDA70D6", "PaleGoldenrodEEE8AA", "PaleGreen98FB98", "PaleTurquoiseAFEEEE", "PaleVioletRedDB7093", "PapayaWhipFFEFD5", "PeachPuffFFDAB9", "PeruCD853F", "PinkFFC0CB", "PlumDDA0DD", "PowderBlueB0E0E6", "Purple800080", "RedFF0000", "RosyBrownBC8F8F", "RoyalBlue4169E1", "SaddleBrown8B4513", "SalmonFA8072", "SandyBrownF4A460", "SeaGreen2E8B57", "SeashellFFF5EE", "SiennaA0522D", "SilverC0C0C0", "SkyBlue87CEEB", "SlateBlue6A5ACD", "SlateGray708090", "SnowFFFAFA", "SpringGreen00FF7F", "SteelBlue4682B4", "TanD2B48C", "Teal008080", "ThistleD8BFD8", "TomatoFF6347", "Turquoise40E0D0", "VioletEE82EE", "WheatF5DEB3", "WhiteFFFFFF", "WhiteSmokeF5F5F5", "YellowFFFF00", "YellowGreen9ACD32"};
    private static final String[] b = new String[]{"Accent", "WigetBase", "WidgetBackground", "NormalBackground", "NormalText", "HoveredBackground", "HoveredText", "SelectedBackground", "SelectedText"};
    private static final LinkedHashMap<String, Integer> a;
    public static final HashMap<Integer, String> namesForColors;
    private static final String[] c;
    private boolean a;
    private final int a;
    private String a;

    static {
        a = new LinkedHashMap();
        namesForColors = new HashMap();
        int n2 = a.length;
        c = new String[n2];
        int n3 = 0;
        String[] stringArray = a;
        int n4 = a.length;
        int n5 = 0;
        while (n5 < n4) {
            String string = stringArray[n5];
            int n6 = string.length() - 6;
            int n7 = Integer.parseInt(string.substring(n6), 16);
            String string2 = string.substring(0, n6);
            int n8 = n3++;
            String string3 = string2.toLowerCase();
            GColor.c[n8] = string3;
            String string4 = string3;
            a.put(string4, n7);
            namesForColors.putIfAbsent(n7, string4);
            ++n5;
        }
    }

    public static String[] getColorNames() {
        return (String[])c.clone();
    }

    public static int getRGBColorFromCSS3Name(String string) {
        Integer n2 = (Integer)a.get(string.toLowerCase());
        return n2 != null ? n2 : -1;
    }

    public static GColor createGColor(String string) {
        return string == null || string.isEmpty() ? NONE : (string.equals("inherit") ? INHERIT : new GColor(string));
    }

    public static GColor parseGColor(String string) throws ParseException {
        if ((string = string.trim().toLowerCase()).isEmpty()) {
            throw new ParseException("Empty color string", 0);
        }
        if (string.equals("inherit")) {
            return INHERIT;
        }
        if (string.charAt(0) == '#') {
            int n2 = string.length();
            if (n2 != 4 && n2 != 7) {
                throw new ParseException("Hexadecimal value for color must be 3 or 6 hex digits", 1);
            }
            string = string.substring(1);
            if (n2 == 4) {
                string = "" + string.charAt(0) + string.charAt(0) + string.charAt(1) + string.charAt(1) + string.charAt(2) + string.charAt(2);
            }
            try {
                long l2 = Long.parseLong(string, 16);
                return new GColor((int)l2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid hexadecimal value", 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), 1);
            }
        }
        if (string.startsWith("rgb(")) {
            if (!string.endsWith(")")) {
                throw new ParseException("Missing end parenthesis", 4);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4, string.length() - 1), ",");
            int n3 = stringTokenizer.countTokens();
            if (n3 != 3) {
                throw new ParseException("rgb(r,g,b) takes 3 parameters but " + n3 + " are specified", 5);
            }
            String string2 = null;
            String string3 = null;
            try {
                string2 = "Red";
                string3 = stringTokenizer.nextToken();
                int n4 = Integer.parseInt(string3);
                if (n4 < 0 || n4 > 255) {
                    throw new ParseException("Invalid Red component value: " + n4 + ", must be 0-255", 0);
                }
                string2 = "Green";
                string3 = stringTokenizer.nextToken();
                int n5 = Integer.parseInt(string3);
                if (n5 < 0 || n5 > 255) {
                    throw new ParseException("Invalid Green component value: " + n5 + ", must be 0-255", 0);
                }
                string2 = "Blue";
                string3 = stringTokenizer.nextToken();
                int n6 = Integer.parseInt(string3);
                if (n6 < 0 || n6 > 255) {
                    throw new ParseException("Invalid Blue component value: " + n6 + ", must be 0-255", 0);
                }
                return new GColor(n4, n5, n6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid " + string2 + ": " + string3, 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), 1);
            }
        }
        if (string.startsWith("rgba(")) {
            if (!string.endsWith(")")) {
                throw new ParseException("Missing end parenthesis", 5);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(5, string.length() - 1), ",");
            int n7 = stringTokenizer.countTokens();
            if (n7 != 4) {
                throw new ParseException("rgba(r,g,b,a) takes 4 parameters but " + n7 + " are specified", 6);
            }
            String string4 = null;
            String string5 = null;
            try {
                string4 = "Red";
                string5 = stringTokenizer.nextToken().trim();
                int n8 = Integer.parseInt(string5);
                if (n8 < 0 || n8 > 255) {
                    throw new ParseException("Invalid color \"" + string + "\": Red component value: " + n8 + ", must be 0-255", 0);
                }
                string4 = "Green";
                string5 = stringTokenizer.nextToken().trim();
                int n9 = Integer.parseInt(string5);
                if (n9 < 0 || n9 > 255) {
                    throw new ParseException("Invalid color \"" + string + "\": Green component value: " + n9 + ", must be 0-255", 0);
                }
                string4 = "Blue";
                string5 = stringTokenizer.nextToken().trim();
                int n10 = Integer.parseInt(string5);
                if (n10 < 0 || n10 > 255) {
                    throw new ParseException("Invalid color \"" + string + "\": Blue component value: " + n10 + ", must be 0-255", 0);
                }
                string4 = "Alpha";
                string5 = stringTokenizer.nextToken().trim();
                double d2 = Double.parseDouble(string5);
                if (d2 < 0.0 || d2 > 1.0) {
                    throw new ParseException("Invalid color \"" + string + "\": Alpha component value: " + d2 + ", must be decimal value 0.0 to 1.0", 0);
                }
                return new GColor(n8, n9, n10, (int)Math.round(d2 * 255.0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid color \"" + string + "\": " + string4 + " component: " + string5, 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException(illegalArgumentException.getMessage(), 1);
            }
        }
        Integer n11 = (Integer)a.get(string.toLowerCase());
        if (n11 != null) {
            GColor gColor = new GColor(n11);
            gColor.a = string;
            return gColor;
        }
        throw new ParseException("Unknown color format string: \"" + string + "\"", 0);
    }

    public static GColor from(ReadTransaction readTransaction) {
        return readTransaction.readBoolean() ? INHERIT : new GColor(readTransaction);
    }

    public GColor(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("r,g,b values 0-255");
        }
        this.a = n2 << 16 | n3 << 8 | n4 | 0xFF000000;
    }

    public GColor(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255 || n5 < 0 || n5 > 255) {
            throw new IllegalArgumentException("a,r,g,b values 0-255");
        }
        this.a = n5 << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public GColor(int n2, int n3, int n4, double d2) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("r,g,b values 0-255");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("a range is 0.0-1.0");
        }
        this.a = (int)Math.round(d2 * 255.0) << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public GColor(int n2) {
        if (n2 < 0 || n2 > 0xFFFFFF) {
            throw new IllegalArgumentException("Invalid RGB (0-0xFFFFFF): " + n2);
        }
        this.a = n2 | 0xFF000000;
    }

    public GColor(int n2, boolean bl) {
        if (!bl) {
            if (n2 < 0 || n2 > 0xFFFFFF) {
                throw new IllegalArgumentException("Invalid RGB (0-0xFFFFFF): " + n2);
            }
            n2 |= 0xFF000000;
        }
        this.a = n2;
    }

    private GColor() {
        this.a = true;
        this.a = -1;
    }

    private GColor(String string) throws IllegalArgumentException, NumberFormatException {
        long l2;
        long l3 = l2 = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal ARGB value: " + string);
        }
        this.a = (int)l2;
    }

    private GColor(ReadTransaction readTransaction) {
        this.a = readTransaction.readLong();
    }

    public String getName() {
        if (this.a == null) {
            this.a = namesForColors.get(this.a);
        }
        return this.a;
    }

    public boolean isThemeColor() {
        return this.a != null && this.a == -123;
    }

    public void appendColor(SendTransaction sendTransaction) {
        if (this.a) {
            sendTransaction.appendBoolean(true);
        } else {
            sendTransaction.appendBoolean(false);
            sendTransaction.appendLong(this.a);
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GColor && this.equals((GColor)object);
    }

    public boolean equals(GColor gColor) {
        return gColor == null ? false : (this.a ? gColor.a : gColor.a == this.a);
    }

    public int hashCode() {
        return this.a ? -2023406815 : this.a;
    }

    public boolean isInherited() {
        return this.a;
    }

    public boolean isTransparent() {
        return !this.a && (this.a & 0xFF000000) == 0;
    }

    public boolean isOpaque() {
        return !this.a && (this.a & 0xFF000000) == -16777216;
    }

    public int getColor() {
        return this.a;
    }

    public String getString() {
        return this.paramString();
    }

    protected String paramString() {
        return this.a ? "inherit" : "0x" + Long.toHexString((long)this.a & 0xFFFFFFFFL);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public String getCSSValue() {
        if (this.a) {
            return "inherit";
        }
        if ((this.a & 0xFF000000) == -16777216) {
            int n2 = this.a;
            return (n2 >> 4 & 0xF0F0F) != (n2 & 0xF0F0F) ? String.format(Locale.ENGLISH, "#%06X", this.a & 0xFFFFFF) : String.format(Locale.ENGLISH, "#%X%X%X", n2 >> 16 & 0xF, n2 >> 8 & 0xF, n2 & 0xF);
        }
        int n3 = this.a >> 24 & 0xFF;
        String string = n3 == 0 ? "0" : (n3 == 255 ? "1" : Utilities.getShortestDouble((double)Math.round(100000.0 * (double)n3 / 255.0) / 100000.0).substring(1));
        return String.format(Locale.ENGLISH, "rgba(%d,%d,%d,%s)", this.a >> 16 & 0xFF, this.a >> 8 & 0xFF, this.a & 0xFF, string);
    }
}

