/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.PropMgr;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import org.w3c.dom.Element;

public final class GBadge
implements Cloneable {
    public static final int DEFAULT_FONT_SIZE = 16;
    public final KString text;
    public final Color color;
    public final Location location;
    public final int fontSize;

    public GBadge(String string) {
        this(KString.newPlainKString(string), Color.RED, Location.TOP_TRAILING, 0);
    }

    public GBadge(KString kString) {
        this(kString, Color.RED, Location.TOP_TRAILING, 0);
    }

    public GBadge(KString kString, Color color) {
        this(kString, color, Location.TOP_TRAILING, 0);
    }

    public GBadge(KString kString, Location location) {
        this(kString, Color.RED, location, 0);
    }

    public GBadge(KString kString, Color color, Location location) {
        this(kString, color, location, 0);
    }

    public GBadge(KString kString, GBadge gBadge) {
        this(kString, gBadge.color, gBadge.location, gBadge.fontSize);
    }

    public GBadge(KString kString, Color color, Location location, int n2) {
        if (kString == null) {
            throw new NullPointerException("text is null");
        }
        if (n2 > 0 && (n2 < 6 || n2 > 255)) {
            throw new IllegalArgumentException("fontSize range (6-255): " + n2);
        }
        if (location == null) {
            location = Location.TOP_TRAILING;
        }
        if (color == null) {
            color = Color.RED;
        }
        this.text = kString;
        this.color = color;
        this.location = location;
        this.fontSize = n2;
    }

    GBadge(Element element) throws IllegalArgumentException, NumberFormatException, KStringException {
        this.color = Color.valueOf(element.getAttribute("color"));
        String string = element.getAttribute("location");
        this.location = string.isEmpty() ? Location.TOP_TRAILING : Location.valueOf(string);
        string = element.getAttribute("fontSize");
        this.fontSize = string.isEmpty() ? 0 : Integer.parseInt(string);
        this.text = KString.createKString(element);
    }

    GBadge(ReadTransaction readTransaction) throws KStringException {
        int n2 = readTransaction.readByte();
        this.color = Color.values()[n2 >>> 2];
        this.location = Location.values()[n2 & 3];
        this.fontSize = readTransaction.readByte();
        this.text = new KString(KString.Type.HTML, readTransaction.readString(), false);
    }

    public GBadge clone() {
        return new GBadge(this.text.clone(), this.color, this.location, this.fontSize);
    }

    public void dispose() {
        this.text.dispose();
    }

    protected void finalize() throws Throwable {
        try {
            this.text.dispose();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Failed finalize", throwable);
        }
        super.finalize();
    }

    void a(SendTransaction sendTransaction, PropMgr propMgr) {
        sendTransaction.appendByte(this.color.ordinal() << 2 | this.location.ordinal());
        sendTransaction.appendByte(this.fontSize);
        sendTransaction.appendString(this.text.getHTMLString(propMgr.getProvider()));
    }

    void a(Element element) {
        element.setAttribute("color", this.color.name());
        if (this.location != Location.TOP_TRAILING) {
            element.setAttribute("location", this.location.name());
        }
        if (this.fontSize > 0) {
            element.setAttribute("fontSize", Integer.toString(this.fontSize));
        }
        this.text.toElement(element);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GBadge) {
            GBadge gBadge = (GBadge)object;
            return gBadge.fontSize == this.fontSize && gBadge.color == this.color && gBadge.location == this.location && gBadge.text.equals(this.text);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode() ^ Integer.rotateLeft(this.location.hashCode(), 8) ^ this.fontSize ^ this.text.hashCode();
    }

    public boolean equalsOmitReferenceRefreshCheck(GBadge gBadge) {
        return gBadge != null && gBadge.fontSize == this.fontSize && gBadge.color == this.color && gBadge.location == this.location && gBadge.text.equalsOmitReferenceRefreshCheck(this.text);
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf((Object)this.color) + "," + String.valueOf((Object)this.location) + "," + this.fontSize + "," + String.valueOf(this.text) + "]";
    }

    public static enum Color {
        RED("Red"),
        BLUE("Blue"),
        GREEN("Green");

        public final String description;

        private Color(String string2) {
            this.description = string2;
        }
    }

    public static enum Location {
        TOP_TRAILING("Top trailing"),
        TOP_LEADING("Top leading"),
        BOTTOM_TRAILING("Bottom trailing"),
        BOTTOM_LEADING("Bottom leading");

        public final String description;

        private Location(String string2) {
            this.description = string2;
        }
    }
}

