/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.translate;

import com.iizix.ILog;
import com.iizix.text.KString;
import com.iizix.translate.ITranslationEngine;
import com.iizix.translate.ITranslationReply;
import com.iizix.translate.ITranslator;
import com.iizix.translate.RequestException;
import com.iizix.translate.TranslationQueue;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class TranslationEngine
implements ITranslationEngine {
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    public static final String ENCODING_NAME = ENCODING.name();
    public static boolean DEBUG = false;
    private static ITranslationEngine a;
    private final LinkedHashMap<String, TranslationQueue> a = new LinkedHashMap();

    public static ITranslationEngine getInstance() {
        return a;
    }

    protected TranslationEngine() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranslationEngine(boolean bl) {
        Class<TranslationEngine> clazz = TranslationEngine.class;
        synchronized (TranslationEngine.class) {
            ITranslationEngine iTranslationEngine = a;
            if (iTranslationEngine != null && !bl) {
                throw new InternalError("Engine " + iTranslationEngine.getClass().getName() + " is already set");
            }
            a = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TranslationQueue[] getQueues() {
        ITranslationEngine iTranslationEngine = this.a;
        synchronized (iTranslationEngine) {
            return ((LinkedHashMap)((Object)this.a)).values().toArray(new TranslationQueue[((HashMap)((Object)this.a)).size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearLanguageQueue() {
        ITranslationEngine iTranslationEngine = this.a;
        synchronized (iTranslationEngine) {
            ((LinkedHashMap)((Object)this.a)).clear();
        }
    }

    @Override
    public boolean canTranslate(String string, String string2) {
        ITranslator iTranslator = this.getTranslator(string, string2);
        return iTranslator != null ? iTranslator.canTranslate(string, string2) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ITranslationEngine iTranslationEngine = this.a;
        synchronized (iTranslationEngine) {
            for (TranslationQueue translationQueue : ((LinkedHashMap)((Object)this.a)).values()) {
                translationQueue.cancel();
            }
            ((LinkedHashMap)((Object)this.a)).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean translate(KString kString, String string, String string2, ITranslationReply iTranslationReply) {
        TranslationQueue translationQueue;
        block9: {
            if (kString == null) {
                throw new NullPointerException("sourceText==null");
            }
            if (string2 == null) {
                throw new NullPointerException("targetLanguageCode==null");
            }
            if (iTranslationReply == null) {
                throw new NullPointerException("replyCallback==null");
            }
            String string3 = string + "\t" + string2;
            ITranslationEngine iTranslationEngine = this.a;
            synchronized (iTranslationEngine) {
                ITranslator iTranslator;
                block8: {
                    translationQueue = (TranslationQueue)((LinkedHashMap)((Object)this.a)).get(string3);
                    if (translationQueue != null) break block9;
                    iTranslator = this.getTranslator(string, string2);
                    if (iTranslator != null) break block8;
                    if (string == null) {
                        string = "<auto-detect>";
                    }
                    ILog.WARNING(this.getClass(), "Translation engine for language combination is not loaded, cannot translate", "sourceText = " + kString.getRawString(), "sourceLanguageCode = " + string, "targetLanguageCode = " + string2);
                    return false;
                }
                translationQueue = this.newTranslationQueue(string, string2, iTranslator);
                ((HashMap)((Object)this.a)).put(string3, translationQueue);
            }
        }
        translationQueue.addRequest(kString, iTranslationReply);
        return true;
    }

    protected abstract TranslationQueue newTranslationQueue(String var1, String var2, ITranslator var3);

    @Override
    public JSONObject requestJSON(String string, Map<String, String> map, Map<String, String> map2, int n2, int n3) throws IOException, JSONException {
        String string2 = this.requestString(string, map, map2, n2, n3);
        return new JSONObject(new JSONTokener(string2));
    }

    @Override
    public JSONObject requestJSON(String string, String string2, Map<String, String> map, int n2, int n3) throws IOException, JSONException {
        String string3 = this.requestString(string, string2, map, n2, n3);
        return new JSONObject(new JSONTokener(string3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String requestString(String object, Map<String, String> map, Map<String, String> map2, int n2, int n3) throws IOException {
        void var7_11;
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, String> object22 : map.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(object22.getKey());
                String string = object22.getValue();
                if (string == null) continue;
                stringBuilder.append('=').append(URLEncoder.encode(string, ENCODING));
            }
        }
        Object var7_9 = null;
        if (n2 == 1 && ((String)object).length() + stringBuilder.length() < 1900) {
            if (map != null) {
                object = (String)object + "?" + stringBuilder.toString();
            }
        } else {
            String string = stringBuilder.toString();
        }
        return this.requestString((String)object, (String)var7_11, map2, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String requestString(String string, String string2, Map<String, String> map, int n2, int n3) throws IOException {
        Object object;
        Object object2;
        String string3;
        Object object3;
        Object object4;
        Object object6;
        Object object7;
        byte[] byArray = null;
        if (string2 != null) {
            object7 = new ByteArrayOutputStream(n3 + 100);
            object6 = new OutputStreamWriter((OutputStream)object7, ENCODING);
            ((Writer)object6).write(string2.toString());
            ((OutputStreamWriter)object6).close();
            byArray = ((ByteArrayOutputStream)object7).toByteArray();
            if (byArray.length > n3) {
                throw new RequestException("Translation text is too long");
            }
        }
        if (DEBUG) {
            System.err.println("REQ: " + string);
        }
        try {
            object7 = new URI(string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IOException("Syntax error in the URI: " + string, exception);
        }
        object6 = this.getProxy((URL)object7);
        HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object7).openConnection((Proxy)object6);
        this.configureProxy(httpURLConnection);
        httpURLConnection.setRequestProperty("Accept-Charset", ENCODING_NAME);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setReadTimeout(20000);
        boolean bl = false;
        if (map != null) {
            for (Map.Entry<String, String> object52 : map.entrySet()) {
                object4 = object52.getKey();
                httpURLConnection.setRequestProperty((String)object4, object52.getValue());
                if (!((String)object4).equalsIgnoreCase("Content-Type")) continue;
                bl = true;
            }
        }
        if (string2 == null) {
            if (n2 == 0) {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.getOutputStream().close();
            } else {
                httpURLConnection.setRequestMethod("GET");
            }
        } else {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            if (!bl) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            if (n2 == 1) {
                httpURLConnection.setRequestProperty("X-HTTP-Method-Override", "GET");
            }
            Throwable throwable = null;
            object3 = null;
            try {
                object4 = httpURLConnection.getOutputStream();
                try {
                    ((OutputStream)object4).write(byArray);
                }
                finally {
                    if (object4 != null) {
                        ((OutputStream)object4).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                void var11_19;
                if (throwable == null) {
                    Throwable iOException = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var11_19;
            }
            if (DEBUG) {
                System.err.println("Form:\n" + new String(byArray, ENCODING));
            }
        }
        httpURLConnection.connect();
        try {
            Throwable throwable = null;
            object3 = null;
            try {
                object4 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), ENCODING));
                try {
                    CharBuffer charBuffer = CharBuffer.allocate(4096);
                    StringBuilder stringBuilder = new StringBuilder();
                    while (((Reader)object4).read(charBuffer) >= 0) {
                        charBuffer.flip();
                        stringBuilder.append(charBuffer.toString());
                        charBuffer.clear();
                    }
                    String string4 = stringBuilder.toString().replaceAll("\ufeff", "");
                    if (DEBUG) {
                        System.err.println("REPLY:\n" + string4);
                    }
                    return string4;
                }
                finally {
                    if (object4 != null) {
                        ((BufferedReader)object4).close();
                    }
                }
            }
            catch (Throwable throwable3) {
                void var11_24;
                if (throwable == null) {
                    Throwable throwable4 = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw var11_24;
            }
        }
        catch (IOException iOException) {
            object3 = new StringBuilder();
            try {
                object4 = null;
                string3 = null;
                try {
                    object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), ENCODING));
                    try {
                        object = CharBuffer.allocate(256);
                        while (((Reader)object2).read((CharBuffer)object) >= 0) {
                            ((CharBuffer)object).flip();
                            ((StringBuilder)object3).append(((CharBuffer)object).toString());
                            ((CharBuffer)object).clear();
                        }
                    }
                    finally {
                        if (object2 != null) {
                            ((BufferedReader)object2).close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (object4 == null) {
                        object4 = throwable;
                    } else if (object4 != throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                    throw object4;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object4 = ((StringBuilder)object3).toString().replaceAll("\ufeff", "");
        if (DEBUG && !((String)object4).isEmpty()) {
            System.err.println("ERROR:\n" + (String)object4);
        }
        Object object5 = object2 = (string3 = httpURLConnection.getResponseMessage()) != null ? ": " + string3 : "";
        if (!((String)object4).isEmpty()) {
            object = null;
            try {
                JSONObject jSONObject = new JSONObject(new JSONTokener((String)object4));
                object = jSONObject.getString("message");
                if (object == null) {
                    object = jSONObject.toString(2);
                } else {
                    Object object8;
                    object = "reason = " + (String)object;
                    Object object9 = jSONObject.get("statusCode");
                    if (object9 != null) {
                        object = "statusCode = " + String.valueOf(object9) + ", reason = " + (String)object;
                    }
                    if ((object8 = jSONObject.get("error")) != null) {
                        object = "statusCode = " + String.valueOf(object8) + ", " + (String)object;
                    }
                }
                object2 = ": " + (String)object;
            }
            catch (Throwable throwable) {
                object2 = (String)object2 + ", reply = " + (String)object4;
            }
        }
        throw new RequestException("Translation engine request failed" + (String)object2, (Throwable)iOException, httpURLConnection.getResponseCode(), (String)object4);
    }

    @Override
    public String postRequestJSON(String string, Map<String, String> map, String string2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        URL uRL;
        if (DEBUG) {
            System.err.println("REQ (as POST): " + string + "\nData:\n" + string2);
        }
        try {
            uRL = new URI(string).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IOException("Syntax error in the URL: " + string);
        }
        Proxy proxy = this.getProxy(uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
        this.configureProxy(httpURLConnection);
        httpURLConnection.setRequestProperty("Accept-Charset", ENCODING_NAME);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setReadTimeout(20000);
        if (map != null) {
            for (Map.Entry<String, String> object42 : map.entrySet()) {
                httpURLConnection.setRequestProperty(object42.getKey(), object42.getValue());
            }
        }
        byte[] byArray = string2.getBytes(ENCODING);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        Object object5 = null;
        StringBuilder throwable = null;
        try {
            object3 = httpURLConnection.getOutputStream();
            try {
                ((OutputStream)object3).write(byArray);
            }
            finally {
                if (object3 != null) {
                    ((OutputStream)object3).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (object5 == null) {
                object5 = throwable2;
            } else if (object5 != throwable2) {
                ((Throwable)object5).addSuppressed(throwable2);
            }
            throw object5;
        }
        if (DEBUG) {
            System.err.println("Data:\n" + string2);
        }
        httpURLConnection.connect();
        try {
            object5 = null;
            throwable = null;
            try {
                object3 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), ENCODING));
                try {
                    CharBuffer string3 = CharBuffer.allocate(4096);
                    StringBuilder object22 = new StringBuilder();
                    while (((Reader)object3).read(string3) >= 0) {
                        string3.flip();
                        object22.append(string3.toString());
                        string3.clear();
                    }
                    String object4 = object22.toString().replaceAll("\ufeff", "");
                    if (DEBUG) {
                        System.err.println("REPLY:\n" + object4);
                    }
                    return object4;
                }
                finally {
                    if (object3 != null) {
                        ((BufferedReader)object3).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (object5 == null) {
                    object5 = throwable2;
                } else if (object5 != throwable2) {
                    ((Throwable)object5).addSuppressed(throwable2);
                }
                throw object5;
            }
        }
        catch (IOException iOException) {
            throwable = new StringBuilder();
            try {
                object3 = null;
                String throwable3 = null;
                try {
                    object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), ENCODING));
                    try {
                        object = CharBuffer.allocate(256);
                        while (((Reader)object2).read((CharBuffer)object) >= 0) {
                            ((CharBuffer)object).flip();
                            throwable.append(((CharBuffer)object).toString());
                            ((CharBuffer)object).clear();
                        }
                    }
                    finally {
                        if (object2 != null) {
                            ((BufferedReader)object2).close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (object3 == null) {
                        object3 = throwable4;
                    } else if (object3 != throwable4) {
                        ((Throwable)object3).addSuppressed(throwable4);
                    }
                    throw object3;
                }
            }
            catch (Throwable throwable5) {
                // empty catch block
            }
        }
        object3 = throwable.toString().replaceAll("\ufeff", "");
        if (DEBUG && !((String)object3).isEmpty()) {
            System.err.println("ERROR:\n" + (String)object3);
        }
        Object object6 = object2 = (throwable3 = httpURLConnection.getResponseMessage()) != null ? ": " + throwable3 : "";
        if (!((String)object3).isEmpty()) {
            object = null;
            try {
                JSONObject throwable6 = new JSONObject(new JSONTokener((String)object3));
                object = throwable6.getString("message");
                if (object == null) {
                    object = throwable6.toString(2);
                } else {
                    Object object7;
                    object = "reason = " + (String)object;
                    Object object8 = throwable6.get("statusCode");
                    if (object8 != null) {
                        object = "statusCode = " + String.valueOf(object8) + ", reason = " + (String)object;
                    }
                    if ((object7 = throwable6.get("error")) != null) {
                        object = "statusCode = " + String.valueOf(object7) + ", " + (String)object;
                    }
                }
                object2 = ": " + (String)object;
            }
            catch (Throwable throwable7) {
                object2 = (String)object2 + ", reply = " + (String)object3;
            }
        }
        throw new RequestException("Translation engine request failed" + (String)object2, (Throwable)iOException, httpURLConnection.getResponseCode(), (String)object3);
    }
}

