/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.push;

import com.iizix.push.PushNotificationState;
import java.util.Objects;

public class PushNotificationEvent {
    public final PushNotificationState state;
    public final Throwable exception;

    public PushNotificationEvent(PushNotificationState pushNotificationState) {
        this(pushNotificationState, null);
        if (pushNotificationState == null) {
            throw new NullPointerException("state is null");
        }
        if (pushNotificationState == PushNotificationState.ERROR) {
            throw new IllegalArgumentException("ERROR must specify an exception");
        }
    }

    public PushNotificationEvent(Throwable throwable) {
        this(PushNotificationState.ERROR, throwable);
        if (throwable == null) {
            throw new NullPointerException("exception is null");
        }
    }

    private PushNotificationEvent(PushNotificationState pushNotificationState, Throwable throwable) {
        this.state = pushNotificationState;
        this.exception = throwable;
    }

    public PushNotificationState getState() {
        return this.state;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.exception});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PushNotificationEvent)) {
            return false;
        }
        PushNotificationEvent pushNotificationEvent = (PushNotificationEvent)object;
        return this.state == pushNotificationEvent.state && Objects.equals(this.exception, pushNotificationEvent.exception);
    }

    public String toString() {
        String string = "PushNotificationEventState[state=" + String.valueOf((Object)this.state);
        if (this.exception != null) {
            string = string + ", exception=" + String.valueOf(this.exception);
        }
        return string + "]";
    }
}

