/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.api.ui.UISelectionEvent;
import com.iizix.event.GEvent;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.ClassReference;
import com.iizix.prop.GProp;
import com.iizix.prop.MethodReference;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUICheck2Component;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.IUILabelForTarget;
import com.iizix.prop.ui.IUISelectionListener;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.vs.VSField;
import java.lang.reflect.Method;
import java.util.List;

public class MUISwitch
extends UIComp
implements IUICheck2Component,
IUIFocusComp,
IUILabelForTarget {
    private Method f;
    private GenericListener<IUISelectionListener> a;

    public MUISwitch() {
    }

    public MUISwitch(Atom atom) {
        super(atom);
    }

    public MUISwitch(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public MUISwitch clone() {
        MUISwitch mUISwitch = (MUISwitch)super.clone();
        mUISwitch.a = null;
        return mUISwitch;
    }

    @Override
    public Atom getSelectionPropAtom() {
        return CHECKED_ATOM;
    }

    @Override
    public synchronized GenericListener<IUISelectionListener> getSelectionListenerHandler(boolean bl) {
        if (this.a == null && bl) {
            this.a = new GenericListener<IUISelectionListener>(IUISelectionListener.class);
        }
        return this.a;
    }

    @Override
    protected void onSelectionChanged(GEvent gEvent) {
        MUISwitch.setComponentSwitchStateToVSField(this, this.getVSField());
    }

    public static int setComponentSwitchStateToVSField(UIComp uIComp, VSField vSField) {
        if (vSField != null && uIComp.enterVSProcessing(vSField)) {
            try {
                String string;
                Value value = null;
                if (uIComp.getBool("checked")) {
                    value = uIComp.getValue("checkedValue");
                    string = "On";
                } else {
                    value = uIComp.getValue("uncheckedValue");
                    string = "Off";
                }
                if (value == null) {
                    ILog.SEVERE(uIComp.getClass(), "Switch component does not have the " + string + " value defined", (Object)("Component " + uIComp.getReferencePropName() + ": " + String.valueOf(uIComp)));
                    return 0;
                }
                vSField.setValue(value, true, uIComp);
                uIComp.setVSFieldMessageToComponent(vSField, true);
                return 1;
            }
            catch (ValueConversionException valueConversionException) {
                uIComp.setErrorMessage(valueConversionException);
                return -1;
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
        return 0;
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        MUISwitch.onValueChanged(this, vSField);
    }

    public static int onValueChanged(UIComp uIComp, VSField vSField) {
        int n2 = -1;
        if (vSField != null && uIComp != null && uIComp.enterVSProcessing(vSField)) {
            try {
                int n3 = vSField.convertEqualsValue(uIComp, uIComp.getValue("uncheckedValue"), uIComp.getValue("checkedValue"));
                if (n3 < 0) {
                    switch (uIComp.getInt("checkNoMatch")) {
                        default: {
                            break;
                        }
                        case 1: {
                            n3 = 0;
                            n2 = 0;
                            break;
                        }
                        case 2: {
                            n3 = 1;
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            n3 = -1;
                        }
                    }
                }
                if (n3 >= 0) {
                    uIComp.setBool("checked", n3 == 1);
                }
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
        return n2;
    }

    @Override
    public final int getDeviceType() {
        return -1;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return true;
    }

    @Override
    public boolean canFillY() {
        return false;
    }

    @Override
    public boolean canAlignX() {
        return false;
    }

    @Override
    public Size getApproximateSize() {
        return new Size(50, 16);
    }

    @Override
    protected void onPrepare(ClassReference classReference, List<Throwable> list) {
        super.onPrepare(classReference, list);
        MethodReference methodReference = this.getProp("$OnUISelection", MethodReference.class);
        if (methodReference != null) {
            this.f = methodReference.lookupMethod(classReference, list, UISelectionEvent.class);
        }
    }

    @Override
    public Method getOnUISelectionMethod() {
        return this.f;
    }
}

