/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.ClasspathEntry;
import com.iizix.prop.ModuleApp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.SettingsPropCnr;
import com.iizix.prop.StringArrayProp;
import com.iizix.prop.StringMapProp;
import com.iizix.prop.StringProp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ModuleProjectSettings {
    public static final String ALIAS = "alias";
    public static final String ALIASES = "aliases";
    public static final String PROJECT = "project";
    public static final String CLASSPATH = "classpath";
    public static final String USER_AUTH = "userAuth";
    public static final String EXT_LOGIN = "extLogin";
    public static final String CUSTOM_APP = "customApp";
    public static final String APP_ID = "appID";
    public static final String VERSION = "version";
    private final PropCnr a;
    private final ModuleApp a;
    private boolean a;
    private Boolean a;
    private Boolean b;
    private Boolean c;

    public ModuleProjectSettings(PropCnr propCnr) {
        this.a = propCnr;
        ModuleApp moduleApp = propCnr.getProp(Atom.MODULE_APP, ModuleApp.class);
        if (moduleApp == null) {
            moduleApp = new ModuleApp(Atom.MODULE_APP);
            propCnr.addProp2(moduleApp);
        }
        this.a = moduleApp;
    }

    public void setEditing(boolean bl) {
        this.a = bl;
    }

    public boolean isEditing() {
        return this.a;
    }

    public PropCnr getMainPropCnr() {
        return this.a;
    }

    public ModuleApp getModuleApp() {
        return this.a;
    }

    public String getDescription() {
        return this.getModuleApp().getDescription();
    }

    public boolean useAliases() {
        Boolean bl = this.a;
        if (bl == null) {
            bl = this.a = Boolean.valueOf(this.a.getBool(ALIAS, false));
        }
        return bl;
    }

    public void setUseAliases(boolean bl) {
        this.a = bl;
        this.a.setBool(ALIAS, bl);
    }

    public ArrayList<String[]> getAliases() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        PropCnr propCnr = this.a.getProp(ALIASES, PropCnr.class);
        if (propCnr != null) {
            int n2 = 0;
            while (true) {
                String string = propCnr.getString(PROJECT + n2);
                String string2 = propCnr.getString(ALIAS + n2);
                if (string == null || string2 == null) break;
                arrayList.add(new String[]{string, string2});
                ++n2;
            }
        }
        return arrayList;
    }

    public void setAliases(ArrayList<String[]> arrayList) {
        try {
            PropCnr propCnr = this.a.getProp(ALIASES, PropCnr.class);
            if (propCnr == null) {
                propCnr = new PropCnr(Atom.get(ALIASES));
                this.a.addProp2(propCnr);
            } else {
                propCnr.removeAllProps();
            }
            int n2 = 0;
            for (String[] stringArray : arrayList) {
                propCnr.addProp2(new StringProp(Atom.get(PROJECT + n2), stringArray[0]));
                propCnr.addProp2(new StringProp(Atom.get(ALIAS + n2), stringArray[1]));
                ++n2;
            }
        }
        catch (PropException propException) {
            ILog.SEVERE(ModuleProjectSettings.class, "setAliases failed", propException);
        }
    }

    public SettingsPropCnr getSettings(String string) throws PropException {
        SettingsPropCnr settingsPropCnr = this.getContainer(string, SettingsPropCnr.class);
        if (settingsPropCnr == null) {
            settingsPropCnr = new SettingsPropCnr(Atom.get(string));
            this.a.addProp(settingsPropCnr);
        }
        return settingsPropCnr;
    }

    public String getPlugins() {
        String string = this.a.getString(Atom.PLUGINS);
        return string != null && !string.isEmpty() ? string : null;
    }

    public <PC extends PropCnr> PC getContainer(String string, Class<PC> clazz) {
        return (PC)((PropCnr)this.a.getProp(string, clazz));
    }

    public boolean isUserAuthenticationAlwaysRequired() {
        Boolean bl = this.b;
        if (bl == null) {
            bl = this.b = Boolean.valueOf(this.a.getBool(USER_AUTH));
        }
        return bl;
    }

    public boolean isExternalLoginUsed() {
        Boolean bl = this.c;
        if (bl == null) {
            bl = this.c = Boolean.valueOf(this.a.getBool(EXT_LOGIN));
        }
        return bl;
    }

    public String getCustomAppValue(String string) {
        StringMapProp stringMapProp = this.a.getProp(CUSTOM_APP, StringMapProp.class);
        return stringMapProp != null ? stringMapProp.getValue(string) : null;
    }

    public Map<String, String> getCustomAppMap() {
        StringMapProp stringMapProp = this.a.getProp(CUSTOM_APP, StringMapProp.class);
        return stringMapProp != null ? stringMapProp.getHashMap() : null;
    }

    public String getAppID() {
        return this.a.getString(APP_ID);
    }

    public String getVersion() {
        String string = this.a.getString(VERSION);
        if (string != null && !(string = string.trim().toLowerCase()).isEmpty()) {
            return string;
        }
        return "0";
    }

    public boolean setClasspath(Collection<ClasspathEntry> collection) {
        boolean bl = false;
        StringArrayProp stringArrayProp = this.a.getProp(CLASSPATH, StringArrayProp.class);
        if (stringArrayProp == null) {
            this.a.removeProp2(CLASSPATH);
            stringArrayProp = new StringArrayProp(Atom.get(CLASSPATH));
            this.a.addProp2(stringArrayProp);
            bl = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClasspathEntry classpathEntry : collection) {
            arrayList.add(classpathEntry.toString());
        }
        if (!stringArrayProp.getArrayList().equals(arrayList)) {
            bl = true;
            try {
                stringArrayProp.clear();
                stringArrayProp.addStrings(arrayList);
            }
            catch (PropException propException) {
                throw new InternalError("Shouldn't be", propException);
            }
        }
        return bl;
    }

    public ClasspathEntry[] getClasspathEntries() {
        StringArrayProp stringArrayProp = this.a.getProp(CLASSPATH, StringArrayProp.class);
        if (stringArrayProp == null) {
            return new ClasspathEntry[0];
        }
        List<String> list = stringArrayProp.getArrayList();
        int n2 = list.size();
        ClasspathEntry[] classpathEntryArray = new ClasspathEntry[n2];
        while (--n2 >= 0) {
            classpathEntryArray[n2] = ClasspathEntry.fromString(list.get(n2));
        }
        return classpathEntryArray;
    }
}

