/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.config;

import com.iizigo.prop.IDynamicPropertyEditorList;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.editor.IPropEditorExtender;
import com.iizigo.prop.editor.IPropEditorExtenderProvider;
import com.iizigo.prop.editor.PKCS12IdentityPropEditor;
import com.iizigo.prop.tooltip.ITooltipPropList;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizigo.server.config.EditorLetsEncryptDomain;
import com.iizigo.server.config.ServerConfigDesignerProp;
import com.iizigo.server.config.b;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PKCS12IdentityProp;
import com.iizix.prop.PasswordProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.server.acme.LetsEncryptDomain;
import com.iizix.server.prop.WebServerPortConfig;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.validator.routines.DomainValidator;
import org.eclipse.jetty.util.ssl.X509;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorWebServerPortConfig
extends WebServerPortConfig
implements IDynamicPropertyEditorList,
IPropDesigner,
IPropEditorExtenderProvider<PKCS12IdentityPropEditor, PKCS12IdentityProp, byte[]>,
ITooltipPropList {
    private ServerConfigDesignerProp a = new ServerConfigDesignerProp((PropCnr)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Description", Atom.DESCR), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Port", "port"), TooltipItem.newNormal("Protocol", "protocol", (propCnr, gProp, object) -> {
            switch (((EditorWebServerPortConfig)propCnr).getProtocol()) {
                case 0: {
                    return "HTTP";
                }
                case 1: {
                    return "HTTPS";
                }
            }
            return "Unknown";
        }), TooltipItem.newNormal("Bind address", "bindAddress"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Front-end secured", "frontEndSecured"), TooltipItem.newNormal("External port", "externalPort"), TooltipItem.newNormal("External host name", "externalHostName"), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Domain names", "domainNames"), TooltipItem.newNormal("PKCS#12 keystore", "idPKCS12", (propCnr, gProp, object) -> EditorLetsEncryptDomain.a(gProp)), TooltipItem.SPACER_8PX, TooltipItem.newNormal("Let's Encrypt domains", "letsEncryptDomain"));
    }

    public EditorWebServerPortConfig() {
    }

    public EditorWebServerPortConfig(Atom atom) {
        super(atom);
    }

    @Override
    public ServerConfigDesignerProp getDesigner() {
        return this.a;
    }

    public EditorWebServerPortConfig clone() {
        EditorWebServerPortConfig editorWebServerPortConfig = (EditorWebServerPortConfig)super.clone();
        editorWebServerPortConfig.a = new ServerConfigDesignerProp((PropCnr)editorWebServerPortConfig);
        return editorWebServerPortConfig;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }

    @Override
    public boolean hasEditedPropertyListChanged(GEvent gEvent) {
        return "protocol".equals(gEvent.getEventTarget().getPropName());
    }

    @Override
    public IPropEditorExtender<PKCS12IdentityPropEditor, PKCS12IdentityProp, byte[]> getEditorExtender(PKCS12IdentityPropEditor pKCS12IdentityPropEditor, Atom atom) {
        return new b();
    }

    public boolean verify(PropVerification propVerification) {
        String string;
        Object object;
        Object object2;
        int n2;
        if (!super.verify(propVerification)) {
            return false;
        }
        IntProp intProp = (IntProp)this.getProp("port", IntProp.class);
        if (intProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "port", PropVerificationError.Severity.WARNING, "Port", "Invalid value: missing port value", new String[0]));
        } else {
            n2 = intProp.getInt();
            if (n2 < 1 || n2 > 65534) {
                propVerification.add(new PropVerificationError("port", PropVerificationError.Severity.WARNING, "Port", (GProp)intProp, "Port value must be 1-65534, but is " + n2, new String[0]));
            }
        }
        intProp = (IntProp)this.getProp("externalPort", IntProp.class);
        if (intProp != null && ((n2 = intProp.getInt()) < 1 || n2 > 65534)) {
            propVerification.add(new PropVerificationError("port", PropVerificationError.Severity.WARNING, "External port", (GProp)intProp, "External port value must be 1-65534, but is " + n2, new String[0]));
        }
        String string2 = this.getBindAddress();
        int n3 = 0;
        PropCnr propCnr = this.getParent();
        if (propCnr != null) {
            object2 = (EditorWebServerPortConfig[])propCnr.getProps(EditorWebServerPortConfig.class);
            int n4 = ((EditorWebServerPortConfig[])object2).length;
            int n5 = 0;
            while (n5 < n4) {
                object = object2[n5];
                if (object != this && Objects.equals(string2, object.getBindAddress()) && this.getPort() == object.getPort()) {
                    propVerification.add(new PropVerificationError("dupPort." + ++n3, PropVerificationError.Severity.ERROR, "Port", (GProp)this, "Port duplication with Port definition '" + object.getDescription() + "'", new String[0]));
                }
                ++n5;
            }
        }
        if ((object = (StringProp)this.getProp("externalHostName", StringProp.class)) != null && (string = object.getString()) != null && !DomainValidator.getInstance((boolean)false).isValid(string)) {
            propVerification.add(new PropVerificationError("inv.extName", PropVerificationError.Severity.WARNING, "External host name", (GProp)object, "Invalid external host name", new String[0]));
        }
        this.a(propVerification, "Domain names", "domainNames", true);
        int n6 = this.getProtocol();
        IntProp intProp2 = (IntProp)this.getProp("protocol", IntProp.class);
        if (intProp2 == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "protocol", PropVerificationError.Severity.WARNING, "Protocol", "Missing value: Protocol", new String[0]));
        } else {
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    LetsEncryptDomain letsEncryptDomain;
                    Object object32;
                    this.a(propVerification, "Let's Encrypt domains", "letsEncryptDomain", false);
                    object2 = this.getDomainNamesSet();
                    boolean bl = false;
                    Object object4 = null;
                    Object object5 = null;
                    int n7 = 0;
                    int n8 = 0;
                    Set set = this.getLetsEncryptDomainNamesSet();
                    for (Object object32 : set) {
                        bl = true;
                        letsEncryptDomain = this.getLetsEncryptDomain((String)object32);
                        if (letsEncryptDomain == null) {
                            object5 = object5 == null ? object32 : (String)object5 + ", " + (String)object32;
                            ++n8;
                        }
                        if (object2.remove(object32)) continue;
                        ++n7;
                        Object object6 = object4 = object4 == null ? object32 : (String)object4 + ", " + (String)object32;
                    }
                    if (object5 != null) {
                        object5 = (n8 == 1 ? "Let's Encrypt domain must be added: " : "Let's Encrypt domains must be added: ") + object5;
                        object32 = this.getProp("letsEncryptDomain");
                        if (object32 != null) {
                            propVerification.add(new PropVerificationError("missing.le", PropVerificationError.Severity.ERROR, "Let's Encrypt domains", (GProp)object32, (String)object5, new String[0]));
                        } else {
                            propVerification.add(new PropVerificationError((PropCnr)this, "letsEncryptDomain", PropVerificationError.Severity.ERROR, "Let's Encrypt domains", (String)object5, new String[0]));
                        }
                    }
                    if (object4 != null) {
                        object4 = (n7 == 1 ? "Let's Encrypt domain name must be added: " : "Let's Encrypt domain names must be added: ") + object4;
                        object32 = this.getProp("domainNames");
                        if (object32 != null) {
                            propVerification.add(new PropVerificationError("missing.le", PropVerificationError.Severity.ERROR, "Domain names", (GProp)object32, (String)object4, new String[0]));
                        } else {
                            propVerification.add(new PropVerificationError((PropCnr)this, "domainNames", PropVerificationError.Severity.ERROR, "Domain names", (String)object4, new String[0]));
                        }
                    }
                    if (object2.isEmpty() && bl) break;
                    object32 = (object2.size() == 1 ? "identity for domain " : "identities for domains ") + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object2);
                    PKCS12IdentityProp pKCS12IdentityProp = (PKCS12IdentityProp)this.getProp("idPKCS12", PKCS12IdentityProp.class);
                    if (pKCS12IdentityProp == null) {
                        propVerification.add(new PropVerificationError((PropCnr)this, "idPKCS12", PropVerificationError.Severity.WARNING, "PKCS#12 Identity", "Missing value: " + (String)object32, new String[0]));
                        break;
                    }
                    if (pKCS12IdentityProp.getByteArray() == null || pKCS12IdentityProp.getByteArray().length == 0) {
                        propVerification.add(new PropVerificationError("idPKCS12", PropVerificationError.Severity.WARNING, "PKCS#12 Identity", (GProp)pKCS12IdentityProp, "Missing value: " + (String)object32, new String[0]));
                        break;
                    }
                    letsEncryptDomain = (PasswordProp)this.getProp("idPassword", PasswordProp.class);
                    if (letsEncryptDomain == null || letsEncryptDomain.getString("").isEmpty()) {
                        propVerification.add(new PropVerificationError("idPassword", PropVerificationError.Severity.ERROR, "PKCS#12 Identity password", (GProp)pKCS12IdentityProp, "Missing Identity password", new String[0]));
                        break;
                    }
                    Object object7 = "Identity cannot be loaded, please redefine it";
                    try {
                        KeyStore keyStore = pKCS12IdentityProp.getKeyStore(letsEncryptDomain.getString().toCharArray());
                        if (keyStore != null) {
                            for (String string3 : Collections.list(keyStore.aliases())) {
                                X509Certificate x509Certificate;
                                Certificate certificate = keyStore.getCertificate(string3);
                                if (certificate == null || !"X.509".equals(certificate.getType()) || X509.isCertSign((X509Certificate)(x509Certificate = (X509Certificate)certificate))) continue;
                                X509 x509 = new X509(string3, x509Certificate);
                                for (String string4 : x509.getHosts()) {
                                    object2.remove(string4);
                                }
                                for (String string4 : x509.getWilds()) {
                                    string4 = string4.substring(1);
                                    Iterator iterator = object2.iterator();
                                    while (iterator.hasNext()) {
                                        if (!((String)iterator.next()).endsWith(string4)) continue;
                                        iterator.remove();
                                    }
                                }
                            }
                            object7 = object2.isEmpty() ? null : (object2.size() == 1 ? "Missing identity for domain " + (String)object2.iterator().next() : "Missing identities for domains " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object2));
                        }
                    }
                    catch (Exception exception) {
                        object7 = "Identity failed to load: " + exception.getMessage();
                    }
                    if (object7 == null) break;
                    propVerification.add(new PropVerificationError("decodePKCS12", PropVerificationError.Severity.ERROR, "PKCS#12 Identity", (GProp)pKCS12IdentityProp, (String)object7, new String[0]));
                    break;
                }
                default: {
                    propVerification.add(new PropVerificationError("protocol", PropVerificationError.Severity.WARNING, "Protocol", (GProp)intProp2, "Invalid value: Protocol", new String[0]));
                }
            }
        }
        return true;
    }

    private void a(PropVerification propVerification, String string, String string2, boolean bl) {
        String string3;
        StringProp stringProp = (StringProp)this.getProp(string2, StringProp.class);
        if (stringProp != null && (string3 = stringProp.getString()) != null && !string3.isEmpty()) {
            String string4 = null;
            HashSet<String> hashSet = new HashSet<String>();
            DomainValidator domainValidator = DomainValidator.getInstance((boolean)bl);
            String[] stringArray = string3.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string5;
                String string6 = stringArray[n3];
                String string7 = !domainValidator.isValid(string6 = string6.trim()) ? "Domain name \"" + string6 + "\" is not valid" : (string5 = !hashSet.add(string6) ? "Domain name \"" + string6 + "\" is specified more than once" : null);
                if (string5 != null) {
                    string4 = string4 == null ? string5 : string4 + ", " + string5;
                }
                ++n3;
            }
            if (string4 != null) {
                propVerification.add(new PropVerificationError("inv.dns", PropVerificationError.Severity.WARNING, string, (GProp)stringProp, string4, new String[0]));
            }
        }
    }
}

