/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizix.prop.GColor;
import com.iizix.prop.GUnit;
import com.iizix.prop.GUnitException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class DropShadowValidator {
    public final String input;
    public GUnit horz;
    public GUnit vert;
    public GUnit blur;
    public GColor color;
    public String error;
    private boolean a;
    public boolean tooManyParams;

    public DropShadowValidator(String string) {
        this.input = string;
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = 0;
        block15: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.isEmpty()) continue;
            switch (++n2) {
                case 1: {
                    try {
                        this.horz = GUnit.createGUnit((String)string2, (String[])new String[0]);
                    }
                    catch (GUnitException gUnitException) {
                        this.a("Horizontal offset", gUnitException.getLocalizedMessage());
                    }
                    continue block15;
                }
                case 2: {
                    try {
                        this.vert = GUnit.createGUnit((String)string2, (String[])new String[0]);
                    }
                    catch (GUnitException gUnitException) {
                        this.a("Vertical offset", gUnitException.getLocalizedMessage());
                    }
                    continue block15;
                }
                case 3: {
                    try {
                        this.blur = GUnit.createGUnit((String)string2, (String[])new String[0]);
                    }
                    catch (GUnitException gUnitException) {
                        this.a("Blur size", gUnitException.getLocalizedMessage());
                    }
                    continue block15;
                }
                case 4: {
                    try {
                        this.color = GColor.parseGColor((String)string2);
                    }
                    catch (ParseException parseException) {
                        this.a("Color", parseException.getLocalizedMessage());
                    }
                    continue block15;
                }
                case 5: {
                    this.tooManyParams = true;
                    return;
                }
            }
        }
    }

    private void a(String string, String string2) {
        if (this.error == null) {
            this.a = true;
            this.error = string + ":\t" + string2;
        } else {
            if (this.a) {
                this.error = "Multiple errors:\n - " + this.error;
                this.a = false;
            }
            this.error = String.valueOf(this.error) + "\n - " + string + "\t" + string2;
        }
    }

    public String getCSSValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.horz != null) {
            stringBuilder.append(this.horz);
            if (this.vert != null) {
                stringBuilder.append(' ').append(this.vert);
                if (this.blur != null) {
                    stringBuilder.append(' ').append(this.blur);
                }
                if (this.color != null) {
                    stringBuilder.append(' ').append(this.color.getCSSValue());
                }
            }
        }
        return stringBuilder.toString();
    }
}

