/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineDeadException;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryVersionFetcher;
import com.tabnine.eclipse.shared.api.services.ConfigService;
import com.tabnine.eclipse.shared.api.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;

public class BinaryRun {
    public static final String UNINSTALLING_FLAG = "--uninstalling";
    private final BinaryVersionFetcher binaryFetcher;

    public BinaryRun(BinaryVersionFetcher binaryVersionFetcher) {
        this.binaryFetcher = binaryVersionFetcher;
    }

    public List<String> generateRunCommand(Map<String, Object> object) {
        object = new ArrayList();
        String string = System.getenv("BINARY_LOCATION");
        if (string == null) {
            string = this.binaryFetcher.fetchBinary();
        }
        object.add(string);
        object.addAll(this.getBinaryConstantParameters());
        return object;
    }

    public Process reportUninstall(Map<String, Object> object) {
        object = this.binaryFetcher.fetchBinary();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(object, UNINSTALLING_FLAG));
        arrayList.addAll(this.getBinaryConstantParameters());
        try {
            return new ProcessBuilder(arrayList).start();
        }
        catch (IOException iOException) {
            throw new TabNineDeadException(iOException, (String)object);
        }
    }

    private ArrayList<String> getBinaryConstantParameters() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--client");
        arrayList.add("eclipse");
        arrayList.add("--no-lsp");
        arrayList.add("true");
        String string = ConfigService.CONFIG.getLogFilePath();
        if (string != null && !string.isEmpty()) {
            arrayList.add("--log-file-path");
            arrayList.add(string);
        }
        if ((string = ConfigService.CONFIG.getLogLevel()) != null && !string.isEmpty()) {
            arrayList.add("--log-level");
            arrayList.add(string);
        }
        if ((string = ConfigService.CONFIG.getIgnoreSSLErrors()) != null && string.equals("true")) {
            arrayList.add("--tls_config");
            arrayList.add("true");
        }
        if ((string = ConfigService.CONFIG.getCloudUrl()) != null && !string.isBlank()) {
            arrayList.add("--cloud2_url");
            arrayList.add(Utils.cmdSanitize(string));
        }
        string = null;
        String string2 = null;
        String string3 = null;
        try {
            IProduct iProduct = Platform.getProduct();
            string2 = iProduct.getDefiningBundle().getVersion().toString();
            string = (String)iProduct.getDefiningBundle().getHeaders().get("Bundle-Name");
            string3 = ConfigService.CONFIG.getPluginVersion();
        }
        catch (Throwable throwable) {}
        if (string != null || string2 != null || string3 != null) {
            arrayList.add("--client-metadata");
            if (string2 != null) {
                arrayList.add("eclipseVersion=".concat(String.valueOf(string2)));
            }
            if (string != null) {
                arrayList.add("eclipseBundle=".concat(String.valueOf(string)));
            }
            if (string3 != null) {
                arrayList.add("pluginVersion=".concat(String.valueOf(string3)));
            }
        }
        return arrayList;
    }
}

