/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.java.JavaHelper;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizigo.java.classpath.IzClasspathContainerInitializer;
import com.iizigo.plugin.PluginDescriptor;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizix.ILog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ModuleNature
implements IProjectNature {
    public static final String NATURE_ID = "com.iizigo.modulenature";
    private IProject a;
    private ModuleModel a;

    public static boolean hasModuleNature(IProject iProject) throws CoreException {
        return iProject.hasNature(NATURE_ID);
    }

    public static void associateNature(IProject iProject, PluginDescriptor[] pluginDescriptorArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!JavaHelper.hasJavaNature(iProject)) {
            throw new CoreException((IStatus)new Status(4, "com.iizigo", "Java nature for project not found"));
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        String string = "creating module folders";
        iProgressMonitor.beginTask("Creating IIZI Module nature for project", 14);
        try {
            try {
                ModuleModel.a(iProject, pluginDescriptorArray, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10));
                string = "setting up classpath";
                IzClasspathContainerInitializer.addContainer(IzClasspathContainer.Type.RUNTIME, JavaHelper.getJavaProject(iProject), iProgressMonitor);
                iProgressMonitor.worked(1);
                string = "adding IIZI Module Nature";
                IProjectDescription iProjectDescription = iProject.getDescription();
                String[] stringArray = iProjectDescription.getNatureIds();
                int n2 = stringArray.length;
                String[] stringArray2 = new String[n2 + 1];
                System.arraycopy(stringArray, 0, stringArray2, 1, n2);
                stringArray2[0] = NATURE_ID;
                iProjectDescription.setNatureIds(stringArray2);
                iProject.setDescription(iProjectDescription, 2, iProgressMonitor);
                iProgressMonitor.worked(1);
                string = "closing project";
                iProject.close(iProgressMonitor);
                iProgressMonitor.worked(1);
                string = "re-opening project";
                iProject.open(iProgressMonitor);
                iProgressMonitor.worked(1);
            }
            catch (CoreException coreException) {
                ILog.SEVERE(ModuleNature.class, (String)("Failed adding IIZI nature to project: " + string), (Throwable)coreException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(IProject iProject) {
        Object object = ProjectManager.getInstance().a();
        synchronized (object) {
            this.a = iProject;
            this.a = ProjectManager.getInstance().getModuleModel(iProject);
            if (this.a == null) {
                try {
                    this.a = new ModuleModel(iProject);
                    ProjectManager.getInstance().a(iProject, this.a);
                }
                catch (Throwable throwable) {
                    ILog.SEVERE(ModuleNature.class, (String)"Failed creating the Module Model", (Throwable)throwable);
                    throw throwable;
                }
            }
        }
    }

    public IProject getProject() {
        return this.a;
    }

    public void configure() throws CoreException {
        if (!JavaHelper.hasJavaNature(this.a)) {
            throw new CoreException((IStatus)new Status(4, "com.iizigo", "Java Nature for project not found"));
        }
    }

    public void deconfigure() throws CoreException {
        this.a = null;
    }

    public ModuleModel getModel() {
        return this.a;
    }
}

