/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class YearMonthValue
extends TermporalAccessorValue<YearMonth> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.YearMonth;
    }

    @Override
    public Class<YearMonth> getValueClass() {
        return YearMonth.class;
    }

    @Override
    public String getDescription() {
        return "Year-month in the ISO-8601 calendar system, such as 2007-12";
    }

    @Override
    public YearMonth createDefault() {
        return YearMonth.of(1970, 1);
    }

    @Override
    public YearMonth parse(String string) throws ParseException, Exception {
        try {
            return YearMonth.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public YearMonth parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return YearMonth.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public YearMonth convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof YearMonth) {
            return (YearMonth)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            int n2 = (int)(l3 % 100L);
            long l4 = l3 / 100L;
            if (l4 > 0L && l4 < 9999L && n2 >= 1 && n2 <= 12) {
                return YearMonth.of((int)l4, n2);
            }
            Date date = new Date(l3);
            return YearMonth.of(date.getYear() + 1900, date.getMonth() + 1);
        }
        if (object instanceof LocalDate || object instanceof LocalDateTime || object instanceof OffsetDateTime || object instanceof ZonedDateTime) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return YearMonth.from(temporalAccessor);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return YearMonth.of(date.getYear() + 1900, date.getMonth() + 1);
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            int n3 = gregorianCalendar.get(2);
            int n4 = gregorianCalendar.get(1);
            return YearMonth.of(n4, n3);
        }
        if (object instanceof Year) {
            return ((Year)object).atMonth(1);
        }
        if (object instanceof MonthDay) {
            return YearMonth.of(1970, ((MonthDay)object).getMonthValue());
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return YearMonth.from(Instant.ofEpochMilli(l2));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return YearMonth.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(YearMonth yearMonth, LocaleInfo localeInfo) {
        return yearMonth.atDay(1).toEpochDay() * 86400000L;
    }
}

