/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.user;

import com.iizix.Utilities;
import com.iizix.urn.IURNProvider;
import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.URN;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResourceType;
import com.iizix.urn.user.IUserProfileImageURNProvider;
import com.iizix.urn.user.UserProfileImageURN;
import com.iizix.urn.user.UserProfileImageURNType;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class UserProfileImageURNFactory
implements IURNProvider {
    private static final UserProfileImageURNFactory a = new UserProfileImageURNFactory();
    public static final NID nid = NID.PROFILE_IMAGE;

    public static void initialize(URNFactory uRNFactory, IUserProfileImageURNProvider iUserProfileImageURNProvider) {
        uRNFactory.register(a);
        UserProfileImageURN.setUserProfileImageURNProvider(iUserProfileImageURNProvider);
    }

    public static UserProfileImageURNFactory getInstance() {
        return a;
    }

    private UserProfileImageURNFactory() {
    }

    @Override
    public NID getNID() {
        return nid;
    }

    @Override
    public List<URNResourceType> getResourceTypes() {
        return Collections.emptyList();
    }

    @Override
    public URN parse(String string, String string2, String string3, String string4, String string5) throws URNException {
        if (string3 != null) {
            throw new NIDException("User Profile Image URN should not contain a request part '?+': " + string3, string, nid);
        }
        if (string4 != null) {
            throw new NIDException("User Profile Image URN should not contain a query part '?='", string, nid);
        }
        if (string5 != null) {
            throw new NIDException("User Profile Image URN should not contain a fragment part '#': " + string5, string, nid);
        }
        int n2 = string2.indexOf(58);
        if (n2 < 0) {
            throw new NIDException("Invalid User ID or User Name in User Profile Image URN, missing ':'", string, nid);
        }
        String string6 = string2.substring(0, n2);
        UserProfileImageURNType userProfileImageURNType = UserProfileImageURNType.fromString(string6);
        if (userProfileImageURNType == null) {
            throw new NIDException("User Profile Image URN NSS specifies an invalid type: " + string6, string, nid);
        }
        int n3 = string2.indexOf(61, n2 + 1);
        if (n3 < 0) {
            throw new NIDException("Invalid user request in User Profile Image URN, missing '='", string, nid);
        }
        long l2 = 0L;
        String string7 = null;
        String string8 = string2.substring(n2 + 1, n3).toLowerCase(Locale.ENGLISH);
        String string9 = string2.substring(n3 + 1);
        switch (string8) {
            case "id": {
                try {
                    l2 = Long.parseLong(string9);
                    if (l2 != 0L) {
                        throw new NIDException("Invalid Long value for 'id' in User Profile Image URN, must be a non-zero, id = " + l2, string, nid);
                    }
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NIDException("Invalid Long value for 'id' in User Profile Image URN, id = " + string9, string, nid);
                }
            }
            case "name": {
                string7 = Utilities.decodeURIComponent(string9).trim();
                break;
            }
            default: {
                throw new NIDException("User Profile Image URN user parameter, should be 'id' or 'name'" + string8, string, nid);
            }
        }
        return new UserProfileImageURN(string, userProfileImageURNType, string7, l2);
    }
}

