/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.svg;

import com.iizix.prop.GSize;
import com.iizix.prop.image.SVGInfo;
import com.iizix.urn.IURNProvider;
import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.NSSException;
import com.iizix.urn.URN;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResourceType;
import com.iizix.urn.svg.SVG_URN;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;

public class SVG_URNFactory
implements IURNProvider {
    private static final SVG_URNFactory a = new SVG_URNFactory();

    public static void initialize(URNFactory uRNFactory) {
        uRNFactory.register(a);
    }

    public static SVG_URNFactory getInstance() {
        return a;
    }

    private SVG_URNFactory() {
    }

    @Override
    public NID getNID() {
        return NID.SVG;
    }

    @Override
    public List<URNResourceType> getResourceTypes() {
        return Collections.emptyList();
    }

    @Override
    public URN parse(String string, String string2, String string3, String string4, String string5) throws URNException {
        if (string3 != null) {
            throw new NIDException("SVG URN should not contain a request part '?+': " + string3, string, NID.URL);
        }
        if (string5 != null) {
            throw new NIDException("SVG URN should not contain a fragment part '#': " + string5, string, NID.URL);
        }
        GSize gSize = null;
        if (string4 != null) {
            int n2;
            if (!string4.startsWith("size:") || (n2 = string4.indexOf(120, 6)) < 0) {
                throw new NSSException("Invalid size specification of SVG, must be \"size:WIDTHxHEIGHT\", size = " + string4, string, string2);
            }
            try {
                int n3 = Integer.parseInt(string4.substring(5, n2));
                int n4 = Integer.parseInt(string4.substring(n2 + 1));
                if (n3 < 0) {
                    throw new NSSException("Invalid negative width specification of SVG, must be \"size:WIDTHxHEIGHT\", size = " + string4, string, string2);
                }
                if (n4 < 0) {
                    throw new NSSException("Invalid negative height specification of SVG, must be \"size:WIDTHxHEIGHT\", size = " + string4, string, string2);
                }
                gSize = new GSize(n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NSSException("Invalid number in size specification of SVG, must be \"size:WIDTHxHEIGHT\", size = " + string4, string, string2);
            }
        }
        try {
            SVGInfo sVGInfo = SVGInfo.fromString(string2);
            return new SVG_URN(string, sVGInfo, gSize);
        }
        catch (IOException | SAXException exception) {
            throw new NSSException("Invalid SVG data from URN: " + exception.getMessage(), string, string2, exception);
        }
    }
}

