/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.ServerSocketCommProps;
import java.util.StringTokenizer;

public class WebSocketServerCommProps
extends ServerSocketCommProps {
    protected WebSocketServerCommProps() {
    }

    public WebSocketServerCommProps(Atom atom) {
        super(atom);
    }

    public int getFromPort() {
        return this.getInt("fromPort", 14000);
    }

    public int getEndPort() {
        return this.getInt("endPort", 16000);
    }

    public void setPortRange(int n2, int n3) {
        if (n2 < 1 || n2 > n3 || n3 > 65535) {
            throw new IllegalArgumentException("Invalid range: from>=1 && from<=end && end<=65535");
        }
        this.setInt("fromPort", n2);
        this.setInt("endPort", n3);
    }

    public boolean doMaskFrames() {
        return this.getBool("maskFrames");
    }

    public void setMaskFrames(boolean bl) {
        this.setBool("maskFrames", bl);
    }

    public String[] getSubProtocols() {
        String string = this.getString("subProtocols");
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;;");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken().toUpperCase();
            ++n3;
        }
        return stringArray;
    }

    public void setSubProtocols(String[] stringArray) {
        Object object = "";
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (n2 > 0) {
                    object = (String)object + ",";
                }
                object = (String)object + stringArray[n2];
                ++n2;
            }
        }
        this.setString("subProtocols", (String)object);
    }

    public boolean doFailForUnsupportedSubProtocol() {
        return this.getBool("failForUnsupportedSubProtocol", true);
    }

    public void doFailForUnsupportedSubProtocol(boolean bl) {
        this.setBool("failForUnsupportedSubProtocol", bl);
    }

    public void setCacheParams(int n2, int n3, int n4) {
        if (n3 <= n2 || n2 < 7 || n3 > 1024 || n4 < 100 || n4 > 2048) {
            throw new IllegalArgumentException("Arguments not valid");
        }
        this.setInt("cache.minLength", n2);
        this.setInt("cache.maxLength", n3);
        this.setInt("cache.count", n4);
    }

    public int[] getCacheParams() {
        int[] nArray = new int[3];
        try {
            int n2 = this.getInt("cache.minLength");
            int n3 = this.getInt("cache.maxLength");
            int n4 = this.getInt("cache.count");
            if (n4 < 200 || n4 > 2048 || n2 < 7 || n2 >= n3 || n3 > 1024) {
                throw new Exception();
            }
            nArray[0] = n2;
            nArray[1] = n3;
            nArray[2] = n4;
        }
        catch (Exception exception) {
            nArray[0] = 7;
            nArray[1] = 80;
            nArray[2] = 700;
        }
        return nArray;
    }

    public int getServerReadMessageTimeout() {
        return this.getInt("serverReadMessageTimeout", 20000);
    }

    public void setServerReadMessageTimeout(int n2) {
        this.setInt("serverReadMessageTimeout", n2);
    }

    public boolean isOriginValidated() {
        return this.getBool("validateOrigin", true);
    }

    public void setValidateOrigin(boolean bl) {
        this.setBool("validateOrigin", bl);
    }
}

