/**
 * (C) Copyright Mindus SARL, 2026.
 * All rights reserved.
 * 
 * The iiziGo dojo dijit.Editor plugins, and the main code for the Rich Text Editor HTML page.
 * 
 * @author Christopher Mindus
 */
//alert("editor.js: userAgent = "+navigator.userAgent);

/**
 * Change of dojo ToolbarLineBreak to make it larger.
 * It's a 'line break' between two 'dijit.Toolbar' items so that very long toolbars can be organized a bit.
 */
define("dojox/editor/plugins/ToolbarLineBreak2",
      ["dojo",
       "dijit",
       "dojox",
       "dijit/_Widget",
       "dijit/_TemplatedMixin",
       "dijit/_editor/_Plugin",
       "dojo/_base/connect",
       "dojo/_base/declare"],
  function(dojo,dijit,dojox)
    {
    dojo.declare("dojox.editor.plugins.ToolbarLineBreak2",[dijit._Widget,dijit._TemplatedMixin],
      {
      templateString: "<span class='dijit dijitReset'><br><div style='height:4px;width:0px'></div></span>",
      postCreate: function() { dojo.setSelectable(this.domNode,false); },
      isFocusable: function() { return false; }
      });
  
    dojo.subscribe(dijit._scopeName+".Editor.getPlugin",null,function(o)
      {
      if ( o.plugin ) return;
      if ( o.args.name.toLowerCase()=='//' )
        o.plugin=new dijit._editor._Plugin({ button: new dojox.editor.plugins.ToolbarLineBreak2(), setEditor: function(editor) { this.editor=editor; } });
      });
  
    return dojox.editor.plugins.ToolbarLineBreak2;
    });

/*
 * Callback debug.
 */
function izCallback(oper,p1,p2,p3)
  {
  //alert("> izCallback "+oper+": p1="+p1+", p2="+p2+", p3="+p3);
  var rc;
  try { rc=izCallback0(oper,p1,p2,p3); }
  catch(e) { rc='?'; }
  //alert("< izCallback, rc: "+rc);
  return rc;
  }

//Removes the context menu on main page.
document.oncontextmenu=function(_e)
  {
  var e=_e||window.event;
  dojo.stopEvent(e.target||e.srcElement);
  };

/**
 * Function called from Eclipse to get the text.
 */
function izGetText()
  {
  izCallback(1,editor.editNode.innerHTML);
  }

/**
 * Constructs the dojo Editor in the HTML page.
 */
var editor;

// Requirements for the Editor.
try {
require(["dijit/Editor",
         "dijit/_editor/plugins/TextColor",
         "dijit/_editor/plugins/FontChoice",
         "dijit/_editor/plugins/LinkDialog",
         "dijit/_editor/plugins/ViewSource",
         "dojox/editor/plugins/FindReplace",
         "dojox/editor/plugins/ToolbarLineBreak2",
         "dojox/editor/plugins/ShowBlockNodes",
         "dojox/editor/plugins/InsertEntity",
         //"dojox/editor/plugins/TablePlugins",
         //"dojox/editor/plugins/ResizeTableColumn",
         "dojo/domReady!"
         ],
 function(Editor,TextColor,FontChoice,LinkDialog,ViewSource,FindReplace,ToolbarLineBreak2,ShowBlockNodes,InsertEntity,ready)
  {
  // Helper for table plug-in.
  //function tpi(c) { return {name:'dojox.editor.plugins.TablePlugins',command:c}; }

  // The toolbar set-up.
  var setup=
    [
    'undo','redo','|',
    'cut','copy','paste','delete','|',
    'bold','italic','underline','strikethrough','removeFormat','|',
    'subscript','superscript','|',
    'foreColor','hiliteColor','|',
    'insertOrderedList','insertUnorderedList','|',
    'insertHorizontalRule','|',
    'outdent','indent','|',
    'justifyLeft','justifyCenter','justifyRight','justifyFull',
    '//',
    FindReplace,'|','viewsource','showBlockNodes','|',
    'izInsText','createLink','unlink','insertImage','insertEntity','|',
    'fontName','fontSize','formatBlock'/*,
    tpi('insertTable'),tpi('modifyTable'),'|',
    tpi('InsertTableRowBefore'),tpi('InsertTableRowAfter'),tpi('insertTableColumnBefore'),tpi('insertTableColumnAfter'),'|',
    tpi('deleteTableRow'),tpi('deleteTableColumn'),'|',
    tpi('colorTableCell'),tpi('ResizeTableColumn'),tpi('tableContextMenu')*/
    ];
  
  // Get window height minus toolbar.
  var h=200;
  if ( typeof(window.innerWidth)=='number' ) h=window.innerHeight; // Non-IE
  else if ( document.documentElement && document.documentElement.clientHeight ) h=document.documentElement.clientHeight; //IE 6+ in 'standards compliant mode'
  else if ( document.body && document.body.clientHeight ) h=document.body.clientHeight; //IE 4 compatible
  h-=64; // Toolbar
  
  // Construction of Editor...
  var divElement=document.getElementById('editor');
  //alert("editor.js Construct Editor "+divElement);
  editor=new Editor({height:h+'px',plugins:setup},divElement);
  editor.onLoadDeferred.then(function()
    {
    // Remove context menu in editor IFrame.
    //alert("editor.js onLoadDeferred");
    editor.document.oncontextmenu=function(_e)
     {
     var e=_e || window.event;
     var target=e.target||e.srcElement;
     if ( target==editor.document.body || target.nodeName=='INPUT' )
       dojo.stopEvent(e);
     };

    // Defined izCallback also for IFrame.
    editor.iframe.contentWindow.izCallback=function(t,s)
      {
      return izCallback(t,s);
      };

    // Request initial text from Eclipse.
    editor.set('value',izCallback(0));
    editor.focus();
    });
  editor.startup();
  });

/**
 * Variable that is set for the Eclipse callback to the appropriate instance being edited
 * (set at a later stage, e.g. when the item is selected for editing).
 */
var izInsTextCB;

/**
 * This plugin provides an Eclipse dialog box to insert a text reference into an INPUT (button) element.
 */
require(['dojo/_base/declare','dijit/_editor/_Plugin','dijit/form/Button'],function(declare,_Plugin,Button)
  {
  var NAME='izInsText',declaredPlugIn=declare(NAME,_Plugin,
    {
    /**
     * Property useDefaultCommand
     * 
     * <p>Override _Plugin.useDefaultCommand, processing is handled by this plugin, not by dijit.Editor.
     * 
     * @type boolean
     */
    useDefaultCommand: false,

    /**
     * Property command
     * 
     * @type String
     * 
     * <p>As long as you provide a command, the CSS class of the button icon will be 
     * generated automatically. For this one, it will be "dijitEditorInsText".
     */
    command: NAME,
  
    /**
     * Function _initButton()
     * 
     * <p>Override _Plugin._initButton() to setup listener on button click.
     * 
     * @type Function
     */
    _initButton: function()
      {
      var self=this;
      this.inherited(arguments);
      this.connect(this.button,'onClick',function()
        {
        // Set callback to us, call Eclipse function 3.
        izInsTextCB=function(oper)
          {
          self.insText(oper);
          };
        izCallback(4,false);
        });
      },
      
    /**
     * Function insText(insText,sampleText)
     *
     * The doer for the insert text: inserts a button with onclick into here.
     * This enables editing the button definition as well as removal of it.
     */
    insText: function(oper)
      {
      var self=this,editor=self.editor;
      editor.focus();
      if ( oper!=1 )
        return;

      // Build the button with the attributes and value.
      var doc=editor.document,div=doc.createElement('div');
      div.innerHTML='<INPUT type="button" ondblclick="izInsTextDblClick(this);" _izinstext="">';

      // Get dialog data at indexes 0 and 1.
      var button=div.firstChild,
          insText=izCallback(3,0),
          sampleText=izCallback(3,1);

      // Insert the button HTML.
      button.setAttribute('_izinstext',insText);
      button.value=sampleText;
      editor.execCommand('inserthtml',div.innerHTML);

      // Register the double-click function called by the button "ondblclick".
      editor.iframe.contentWindow.izInsTextDblClick=function(button)
        {
        // Double-clicks on INPUT go here.
        insText=button.getAttribute('_izinstext',insText);
        sampleText=button.value;

        // Edit definition of text, or remove it.
        // izInsTextCB sets the callback right into here from Eclipse...
        izInsTextCB=function(oper)
          {
          // Dialog is closed by the user with an "oper" code, to delete
          // button (2), to change it (1) or cancel (0).
          editor.focus();
          if ( oper==2 )
            {
            // Remove button.
            editor.execCommand('delete');
            }
          else
          if ( oper==1 )
            {
            // Save new text.
            // Get dialog data at indexes 0 and 1.
            insText=izCallback(3,0);
            sampleText=izCallback(3,1);

            // Delete the button, then add it again.
            /*editor.execCommand('delete');*/
            button.setAttribute('_izinstext',insText);
            button.value=sampleText;
            }
          };
        izCallback(4,true,insText,sampleText);
        };
      },

    /**
     * Function getLabel()
     * 
     * <p>The tooltip text of the button. Localization can be done here.
     * 
     * @type Function
     * 
     * @return {String}
     */
    getLabel: function()
      {
      return 'Insert text from text table or VirtualSpace';
      },

    /**
     * Function updateState()
     * 
     * <p>Requests update of the button state and possible parameters.
     * 
     * @type Function
     */
    updateState: function()
      {
      // Overrides _Plugin.updateState().
      var disabled=this.get('disabled');
      this.button.set('disabled',disabled);
      }
    });

  // Register this plugin.
  _Plugin.registry[NAME]=function()
    {
    return new declaredPlugIn({command:NAME});
    };
  });
}
catch(e)
  {
  alert("failure: "+e);
  }