/**
 * Property isIgnored
 *  
 * <p>Variable to ignore changes of the styles.
 * 
 * @type Boolean
 */
var isIgnored=false,

/**
 * Property styles
 * 
 * <p>The array of styles, 7 in total.
 * 
 * @type Array
 */
styles=['rtl','disable','press','select','focus','hover','capture'],

/**
 * Property styleCheckboxes
 * 
 * <p>The array of styles check boxes.
 * 
 * @type Array
 */
styleCheckboxes=[];

/**
 * Function buildPreviews()
 * 
 * <p>Builds the preview classes from the chosen styles.
 * 
 * @type Function
 */
function buildPreviews()
  {
  var s='icon';
  for ( var ii=7; ii--; )
    if ( styleCheckboxes[ii].checked )
      s+=' '+styles[ii];
  
  // Set previewN ID's N=1-7 class names.
  //console.log('class = '+s);
  for ( ii=8; --ii; )
    document.getElementById('preview'+ii).className=s;
  }

/**
 * Function onclick()
 * 
 * <p>Function called when checkbox is clicked, informs Eclipse of the check state.
 * 
 * @type Function
 */
function onclick()
  {
  // Inform Eclipse.
  //console.log('Clicked = '+this._iz+', checked = '+this.checked);
  buildPreviews();
  
  if ( !isIgnored )
    onJSClick(this._iz,this.checked);
  }

// Initialize 7 listeners for changes in the chosen states.
for ( var ii=7; ii--; )
  {
  var chk=styleCheckboxes[ii]=document.getElementById(styles[ii]);
  chk._iz=ii;
  chk.onclick=onclick;
  }

/**
 * Function setStyle(s)
 * 
 * <p>Setup for chosen styles.
 * 
 * @type Function
 * 
 * @param {Number} styles  Bit value for the chosen styles.
 */
function setStyles(s)
  {
  isIgnored=true;
  
  for ( var ii=7; ii--; )
    document.getElementById(styles[ii]).checked=!!(s&(1<<ii));
  
  isIgnored=false;
  
  buildPreviews();
  }

/**
 * Function setPreviewsContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setPreviewsContent(s)
  {
  // Set "iconN" where N is 1-7.
  for ( var ii=8; --ii; )
    document.getElementById('icon'+ii).innerHTML=s;
  }

/**
 * Function setStateContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setStateContent(s)
  {
  document.getElementById('icon_normal' ).innerHTML=
  document.getElementById('icon_disable').innerHTML=
  document.getElementById('icon_press'  ).innerHTML=
  document.getElementById('icon_focus'  ).innerHTML=
  document.getElementById('icon_hover'  ).innerHTML=
  document.getElementById('icon_capture').innerHTML=s;
  }

/**
 * Ignore mouse and keyboard events.
 */
function ignore(_e)
  {
  // Let it pass for the entry fields.
  document.body.style.cursor='default';
  var e=_e || window.event;
  e.cancelBubble=true; // IE
  if ( e.stopPropagation )
    e.stopPropagation();
  if ( e.preventDefault )
    e.preventDefault();    
  return false;
  }
  
// Disable mouse and keyboard.
document.onmousedown=
document.onmousemove=
document.onmouseup=
document.oncontextmenu=
document.body.onkeydown=
document.body.onkeypress=
document.body.onkeyup=ignore;

///
/// --- Initialize in a jiffy ---
///

// Asynchronous events are only fired if the browser is ready.
// The browser is not ready when loading.
setTimeout(function()
  {
  // Callback to Eclipse when done.
  onJSInitialized();
  },0);
