// Setup definition file with important variables.

/* jshint unused:true, undef:true */
/* globals window, document */

(function(w)
  {
  // Dojo config.
  var h=document.location.href,
      r=h.substr(0,h.lastIndexOf('/'))+'/D/',
      R=w.izRun=
    {
    // Version number.
    version: '3.5.3', // $$$%version%
    
    // Timestamp when built, to clear cache.
    timestamp: 0, // $$$%timestamp%
    
    // Program name of the correct locale selected.
    PG: 'iiziRun', // $$$%PG%
  
    // Application ID.
    AI: 'com.iizix.run.customized', // $$$%AI%
    
    // The URL scheme: iiziruncust://cmd&params... where cmd is 'define' or 'run'.
    // 'US' is undefined if no URL scheme support is used.
    US: 'iiziruncust', // $$$%US%
    
    // Allowed operations of the URL scheme: 0=launch, 1=run another, 2=redefine (define+run).
    UO: 2, // $$$%UO%
    
    // Server and App config when fixed, null otherwise.
    //CO: { id: '', descr: 'APP_DESCR', addr: '', port: 0, ssl: !0 },
    CO: null, // $$$%CO%
    
    // Default locale.
    DL: 'en-us', // $$$%DL%
    
    // Extra locales.
    EL: ['en','de','es','fr','sv','ru','ja','zh'],  // $$$%EL%
  
    // Debugging.
    DEBUG: false, // $$$%DEBUG%
    
    // Initial user ID for server access, must be granted in server.
    UI: 'iiziRun Developer',  // $$$%UI%
    
    // Initial password for server access, must be granted in server with user ID.
    PW: 'secret',  // $$$%PW%
    
    // Geolocation plugin default not added.
    GL: false  // $$$%GL%
    
    /* No need for Firebase Web App config in iiziRun Custom: only Cordova! */
    };
  
  // Release version=1 ALWAYS for iiziRun. 
  w.izRelease=1;
  
  // +%%% beginning of removal
  // Dojo's root directory is only needed when using debug code for iiziRunDevel or iiziRunCustom
  // and should be undefined for customized iiziRun's.
  if ( !w.cordova && h.startsWith('file:') )
    r='/iizi/iiziRun_CustomizedTemplate/www/D/'; 
  // -%%% end of removal

  // Save version number globally.
  w.izRunVer=R.version;

  // Dojo module name and location.
  function f(n)
    {
    return {name:n,location:r+n};
    }
  
  // Dojo configuration.
  w.dojoConfig={has:{'dojo-bidi':true,'dojo-sync-loader':false,'dojo-preload-i18n-Api':false,'dojo-v1x-i18n-Api':true},async:true,parseOnLoad:false,locale:R.DL,extraLocale:R.EL,gfxRenderer:'svg',packages:[f('dojo'),f('dijit'),f('dojox'),f('themes'),f('dbootstrap'),f('xstyle'),f('dgrid'),f('dstore'),{name:'iz'}],iz:[r,r]};
  
  // End of function and call it!
  })(window);
