/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class DoubleValue
extends NumberValue<Double> {
    private static final Double a = 0.0;

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Double;
    }

    @Override
    public Class<Double> getValueClass() {
        return Double.class;
    }

    @Override
    public String getDescription() {
        return "Double precision floating point number";
    }

    @Override
    public Double createDefault() {
        return a;
    }

    @Override
    public Double parse(String string) throws NumberFormatException {
        return Double.valueOf(string);
    }

    @Override
    public Double convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return l2;
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

