/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.EventRequest;
import com.tabnine.eclipse.shared.api.services.SnoozeService$1;
import com.tabnine.eclipse.shared.api.services.SnoozeService$SnoozeToggledListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SnoozeService {
    private static final int DEFAULT_SNOOZE_TIMER_TIMEOUT = 3600000;
    private static final String SNOOZE_ANALYTICS_EVENT_NAME = "snooze-toggled";
    private static final String SNOOZE_ANALYTICS_EVENT_DURATION = "1";
    private boolean isSnoozed = false;
    private static SnoozeService snoozeService;
    private Timer timer;
    private List<SnoozeService$SnoozeToggledListener> listeners = new ArrayList<SnoozeService$SnoozeToggledListener>();
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();

    private SnoozeService() {
        this.timer = new Timer();
    }

    public static SnoozeService getInstance() {
        if (snoozeService == null) {
            snoozeService = new SnoozeService();
        }
        return snoozeService;
    }

    public boolean isSnoozed() {
        return this.isSnoozed;
    }

    private void startSnoozeTimer() {
        this.timer = new Timer();
        SnoozeService$1 snoozeService$1 = new SnoozeService$1(this);
        this.timer.schedule((TimerTask)snoozeService$1, 3600000L);
    }

    public void toggleSnooze() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        boolean bl = this.isSnoozed = !this.isSnoozed;
        if (this.isSnoozed) {
            this.startSnoozeTimer();
        }
        this.notifyListeners();
        this.sendAnalyticsEvent();
    }

    private void sendAnalyticsEvent() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("duration", SNOOZE_ANALYTICS_EVENT_DURATION);
        hashMap.put("show_completions", String.valueOf(this.isSnoozed));
        IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        hashMap.put("extension", iEditorPart == null ? "" : ((iEditorPart = (IFile)iEditorPart.getEditorInput().getAdapter(IFile.class)) == null ? "" : "." + iEditorPart.getFileExtension()));
        this.binaryRequestFacade.executeRequest(new EventRequest(SNOOZE_ANALYTICS_EVENT_NAME, hashMap));
    }

    public void subscribe(SnoozeService$SnoozeToggledListener snoozeService$SnoozeToggledListener) {
        this.listeners.add(snoozeService$SnoozeToggledListener);
    }

    public void unsubscribe(SnoozeService$SnoozeToggledListener snoozeService$SnoozeToggledListener) {
        this.listeners.remove(snoozeService$SnoozeToggledListener);
    }

    private void notifyListeners() {
        for (SnoozeService$SnoozeToggledListener snoozeService$SnoozeToggledListener : this.listeners) {
            snoozeService$SnoozeToggledListener.onSnoozeToggle(this.isSnoozed);
        }
    }
}

