/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.config.StateRequest;
import com.tabnine.eclipse.shared.api.binary.requests.config.StateResponse;
import com.tabnine.eclipse.shared.api.interfaces.StateUpdatedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BinaryStateService {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();
    private final List<StateUpdatedListener> listeners = new ArrayList<StateUpdatedListener>();
    private static BinaryStateService instance;

    public static BinaryStateService getInstance() {
        if (instance == null) {
            instance = new BinaryStateService();
        }
        return instance;
    }

    public void subscribe(StateUpdatedListener stateUpdatedListener) {
        this.listeners.add(stateUpdatedListener);
    }

    public void unsubscribe(StateUpdatedListener stateUpdatedListener) {
        this.listeners.remove(stateUpdatedListener);
    }

    public void notifyListeners(StateResponse stateResponse) {
        for (StateUpdatedListener stateUpdatedListener : new CopyOnWriteArrayList<StateUpdatedListener>(this.listeners)) {
            stateUpdatedListener.onUpdate(stateResponse);
        }
    }

    public StateResponse getState() {
        StateResponse stateResponse = this.binaryRequestFacade.executeRequest(new StateRequest());
        if (stateResponse != null) {
            this.notifyListeners(stateResponse);
        }
        return stateResponse;
    }

    public StateResponse getUserStateDirectly() {
        return this.binaryRequestFacade.executeRequest(new StateRequest());
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(() -> this.getState(), 0L, 3L, TimeUnit.SECONDS);
    }
}

