/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.prop.Atom;
import com.iizix.prop.IPatternOwner;
import com.iizix.prop.PlainKStringProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.text.KString;
import com.iizix.text.PlainKString;

public class PatternProp
extends PlainKStringProp {
    public PatternProp() {
    }

    public PatternProp(Atom atom) {
        super(atom);
    }

    public PatternProp(Atom atom, String string) {
        super(atom);
        try {
            this.setPropValue(KString.newPlainKString(string));
        }
        catch (PropException propException) {
            throw new InternalError("Shoudn't be", propException);
        }
    }

    public PatternProp(Atom atom, PlainKString plainKString) {
        super(atom);
        try {
            this.setPropValue(plainKString);
        }
        catch (PropException propException) {
            throw new InternalError("Shoudn't be", propException);
        }
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof IPatternOwner) {
            Value.Type type = ((IPatternOwner)((Object)propCnr)).getValueType();
            if (type == null) {
                propVerification.add(new PropVerificationError("type", PropVerificationError.Severity.ERROR, "Pattern", this, "The value type is undefined", new String[0]));
            } else {
                PlainKString plainKString = this.getPlainKString();
                if (plainKString != null) {
                    if (type.category.patterns.length == 0) {
                        propVerification.add(new PropVerificationError("no.support", PropVerificationError.Severity.ERROR, "Pattern", this, "Pattern is not supported for " + String.valueOf((Object)type) + " value type", new String[0]));
                    } else {
                        String string = plainKString.getHTMLString(null);
                        try {
                            type.createDefault().getString(string, LocaleInfo.getCurrent(false));
                        }
                        catch (Exception exception) {
                            propVerification.add(new PropVerificationError("syntax", PropVerificationError.Severity.ERROR, "Pattern", this, exception.getMessage(), new String[0]));
                        }
                    }
                }
            }
        }
        return true;
    }
}

