/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.java;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.java.AddClassAction;
import com.iizigo.java.JavaClass;
import com.iizigo.java.JavaManager;
import com.iizigo.java.MemberTreeItemNavigatorPresentation;
import com.iizigo.java.MethodLookup;
import com.iizigo.java.parser.ParsedJavaSource;
import com.iizigo.java.parser.type.IzMethodDeclaration;
import com.iizigo.java.parser.type.IzTypeDeclaration;
import com.iizigo.java.prop.IClassReferenceListener;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ModuleRootPropCnr;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.TreeItemNavigatorPresentation;
import com.iizigo.prop.editor.dialog.SelectCNDialog;
import com.iizigo.swt.IValidateSelection;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JavaHelper {
    public static final int MAX_COMPILER_COMPLIANCE_LEVEL = 15;
    public static final IJavaElement[] EMPTY_JAVA_ELEMENTS = new IJavaElement[0];
    public static final String ERR_PROJECT_CLOSED = "Project is closed";
    public static final String ERR_CLASS_NOT_FOUND = "Class not found";
    public static final String ERR_NOT_CLASS = "Not a class";
    public static final String ERR_CLASS_NOT_IMPLEMENTING_INTERFACE = "Class does not implement interface '";
    public static final String ERR_CLASS_ABSTRACT = "Class is abstract";
    public static final String ERR_CLASS_LOCAL = "Class is local - needs wrapping instance";
    public static final String ERR_INNER_CLASS = "Class cannot be an inner class";
    public static final String ERR_CLASS_CANNOT_INSTANTIATE = "Cannot instantiate class";
    public static final String ERR_CLASS_INTERFACE = "Interface, not a class";
    public static final String ERR_CLASS_NOT_PUBLIC = "Class is not public";
    public static final String ERR_CLASS_CONSTRUCTOR_NOT_PUBLIC = "Constructor without arguments is not public";
    public static final String ERR_CLASS_MISSING_PUBLIC_CONSTRUCTOR = "Missing public constructor without arguments";
    private static Method a = new HashMap();
    private static final HashMap<Thread, HashMap<Integer, a>> a;

    public static IClassFile getClassFile(IType iType) {
        if (a == null) {
            Method method = null;
            try {
                method = IType.class.getDeclaredMethod("getClassFile", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                ILog.SEVERE(JavaHelper.class, (String)("Failed retrieving " + String.valueOf(IType.class) + " method getClassFile() returning " + String.valueOf(IClassFile.class) + " instance"), (Throwable)exception);
                return null;
            }
            a = method;
        }
        try {
            return (IClassFile)a.invoke((Object)iType, new Object[0]);
        }
        catch (Exception exception) {
            ILog.SEVERE(JavaHelper.class, (String)("Failed retrieving " + iType.getFullyQualifiedName() + " call getClassFile() returning " + String.valueOf(IClassFile.class) + " instance"), (Throwable)exception);
            return null;
        }
    }

    public static JavaClass createClassReference(GProp<?> gProp, String string, IClassReferenceListener iClassReferenceListener) {
        ModuleModel moduleModel = JavaHelper.a(gProp);
        return moduleModel != null ? JavaManager.getInstance().a(moduleModel, string, iClassReferenceListener) : null;
    }

    public static boolean verifyPresence(GProp<?> gProp, String string) {
        try {
            ModuleModel moduleModel = JavaHelper.a(gProp);
            return moduleModel.getJavaProject().findType(string) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static List<JavaClass> getPublicOrStaticClasses() {
        return JavaManager.getInstance().getPublicOrStaticClasses();
    }

    public static List<String> getAvailableMethods(IType iType, String string, String string2) {
        return JavaManager.getInstance().getAvailableMethods(iType, string, string2);
    }

    private static ModuleModel a(GProp<?> gProp) {
        ModuleModel moduleModel;
        PropCnr propCnr = gProp.getRootParentNoAssert();
        if (propCnr instanceof ModuleRootPropCnr) {
            ModuleRootPropCnr moduleRootPropCnr = (ModuleRootPropCnr)propCnr;
            moduleModel = moduleRootPropCnr.getModel();
        } else {
            moduleModel = null;
        }
        return moduleModel;
    }

    public static String listJavaClassSource(Shell shell, IJavaProject iJavaProject, String string, String string2, String string3, String string4, IJavaElement iJavaElement) {
        try {
            Object[] objectArray;
            IJavaProject iJavaProject22;
            ArrayList<IType> arrayList = new ArrayList<IType>();
            List<IJavaProject> list = iJavaProject != null ? Arrays.asList(iJavaProject) : Arrays.asList(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects());
            for (IJavaProject iJavaProject22 : list) {
                if (!iJavaProject22.isOpen()) continue;
                IPackageFragment[] iPackageFragmentArray = iJavaProject22.getPackageFragments();
                int n2 = iPackageFragmentArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    objectArray = iPackageFragmentArray[n3];
                    ICompilationUnit[] iCompilationUnitArray = objectArray.getCompilationUnits();
                    int n4 = iCompilationUnitArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ICompilationUnit iCompilationUnit = iCompilationUnitArray[n5];
                        IType[] iTypeArray = iCompilationUnit.getTypes();
                        int n6 = iTypeArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            IType iType = iTypeArray[n7];
                            if (JavaHelper.validateClass(iType, string3) == null && (string4 == null || JavaHelper.hasAnnotation(iType, string4))) {
                                arrayList.add(iType);
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
            iJavaProject22 = SearchEngine.createJavaSearchScope((IJavaElement[])arrayList.toArray(new IJavaElement[arrayList.size()]));
            SelectionDialog selectionDialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)iJavaProject22, (int)2, (boolean)false);
            selectionDialog.setTitle(string);
            selectionDialog.setMessage(string2);
            if (iJavaElement != null) {
                selectionDialog.setInitialSelections(new Object[]{iJavaElement});
            }
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0) {
                return ((IType)objectArray[0]).getFullyQualifiedName('.');
            }
        }
        catch (JavaModelException javaModelException) {
            ILog.WARNING(JavaHelper.class, (String)("listJavaClassSource failed: " + javaModelException.getMessage()));
        }
        return null;
    }

    public static boolean gotoJava(Shell shell, String string, IJavaElement iJavaElement) {
        block6: {
            if (iJavaElement != null) {
                block5: {
                    if (JavaUI.openInEditor((IJavaElement)iJavaElement) == null) break block5;
                    return true;
                }
                try {
                    if (shell != null) {
                        Activator.messageBox(shell, string, "Failed to open the Java editor.", 40);
                    }
                }
                catch (JavaModelException | PartInitException throwable) {
                    if (shell == null) break block6;
                    Activator.openError(shell, string, "Failed to open the Java editor.", throwable);
                }
            }
        }
        return false;
    }

    public static String createJavaClassSource(IJavaProject iJavaProject, String string) {
        IType iType = JavaHelper.createJavaClassSourceType(iJavaProject, string, true);
        return iType != null ? iType.getFullyQualifiedName() : null;
    }

    public static IType createJavaClassSourceType(IJavaProject iJavaProject, String string, boolean bl) {
        AddClassAction addClassAction = new AddClassAction(iJavaProject, string);
        addClassAction.setOpenEditorOnFinish(bl);
        addClassAction.run();
        IJavaElement iJavaElement = addClassAction.getCreatedElement();
        if (!(iJavaElement instanceof IType)) {
            return null;
        }
        IType iType = (IType)iJavaElement;
        JavaHelper.reconcile(iType);
        return iType;
    }

    public static CompilationUnit reconcile(IType iType) {
        try {
            return iType.getCompilationUnit().reconcile(15, true, true, null, null);
        }
        catch (JavaModelException javaModelException) {
            IResource iResource = iType.getResource();
            if (iResource != null && iResource.isAccessible()) {
                ILog.SEVERE(JavaHelper.class, (String)("Failed reconcile of " + String.valueOf(iResource.getFullPath()) + " (class " + iType.getFullyQualifiedName() + ")"), (Throwable)javaModelException);
            }
            return null;
        }
    }

    public static String validateClassName(String string) {
        if (string.isEmpty()) {
            return "Empty class name";
        }
        IStatus iStatus = JavaConventions.validatePackageName((String)string, (String)"14", (String)"14");
        return iStatus.getSeverity() == 4 ? iStatus.getMessage() : null;
    }

    public static String getClassFQN(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getQualifiedName();
        int n2 = string.indexOf(60);
        return n2 < 0 ? string : string.substring(0, n2);
    }

    public static String canInstantiate(IType iType) {
        block18: {
            int n2;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    n2 = iType.getFlags();
                                    if (!iType.isEnum()) break block12;
                                    return "Enum, not a class";
                                }
                                if (!iType.isInterface()) break block13;
                                return ERR_CLASS_INTERFACE;
                            }
                            if (iType.isClass()) break block14;
                            return ERR_NOT_CLASS;
                        }
                        if (!Flags.isAbstract((int)n2)) break block15;
                        return ERR_CLASS_ABSTRACT;
                    }
                    if (!iType.isLocal()) break block16;
                    return ERR_CLASS_LOCAL;
                }
                if (Flags.isPublic((int)n2)) break block17;
                return ERR_CLASS_NOT_PUBLIC;
            }
            if (Flags.isStatic((int)n2) || iType.getDeclaringType() == null) break block18;
            return ERR_INNER_CLASS;
        }
        try {
            boolean bl = false;
            IMethod[] iMethodArray = iType.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod iMethod = iMethodArray[n4];
                if (iMethod.isConstructor()) {
                    bl = true;
                    if (iMethod.getNumberOfParameters() == 0) {
                        return Flags.isPublic((int)iMethod.getFlags()) ? null : ERR_CLASS_CONSTRUCTOR_NOT_PUBLIC;
                    }
                }
                ++n4;
            }
            return bl ? ERR_CLASS_MISSING_PUBLIC_CONSTRUCTOR : null;
        }
        catch (Exception exception) {
            return ERR_CLASS_CANNOT_INSTANTIATE;
        }
    }

    public static IType getIType(IAdaptable iAdaptable) {
        if (iAdaptable != null) {
            IType iType = (IType)iAdaptable.getAdapter(IType.class);
            if (iType != null) {
                return iType;
            }
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iAdaptable.getAdapter(ICompilationUnit.class);
            if (iCompilationUnit != null) {
                return iCompilationUnit.findPrimaryType();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String validateClass(IType iType, String string) {
        try {
            if (iType == null) return ERR_NOT_CLASS;
            if (!iType.isClass()) {
                return ERR_NOT_CLASS;
            }
            String string2 = JavaHelper.canInstantiate(iType);
            if (string2 != null) {
                return string2;
            }
            if (string == null) {
                return null;
            }
            ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = iTypeHierarchy.getAllInterfaces();
            int n2 = iTypeArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return ERR_CLASS_NOT_IMPLEMENTING_INTERFACE + string + "'";
                }
                IType iType2 = iTypeArray[n3];
                String string3 = iType2.getFullyQualifiedName('.');
                if (string3.equals(string)) {
                    return null;
                }
                ++n3;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return ERR_CLASS_NOT_IMPLEMENTING_INTERFACE + string + "'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAnnotationsMatch(IAnnotation[] iAnnotationArray, String string, String string2, String string3, boolean bl) {
        int n2 = 0;
        if (iAnnotationArray.length <= 0) return n2;
        try {
            IBinding[] iBindingArray;
            boolean bl2 = false;
            int n3 = string.lastIndexOf(46);
            String string4 = n3 > 0 ? string.substring(n3 + 1) : "";
            IAnnotation[] iAnnotationArray2 = iAnnotationArray;
            int n4 = iAnnotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IAnnotation iAnnotation = iAnnotationArray2[n5];
                iBindingArray = iAnnotation.getElementName();
                if (iBindingArray.equals(string)) {
                    if (string2 == null) {
                        return 1;
                    }
                    bl2 = true;
                    int n6 = JavaHelper.a(iAnnotation.getMemberValuePairs(), string2, string3, bl);
                    if (n6 > 0) {
                        return n6;
                    }
                } else if (string2 == null && iBindingArray.equals(string4)) {
                    return 1;
                }
                ++n5;
            }
            if (bl2) return n2;
            int n7 = 0;
            iBindingArray = JavaHelper.createBindings(iAnnotationArray[0].getJavaProject(), (IJavaElement[])iAnnotationArray);
            int n8 = iBindingArray.length;
            n4 = 0;
            while (n4 < n8) {
                IAnnotationBinding iAnnotationBinding;
                IBinding iBinding = iBindingArray[n4];
                if (iBinding instanceof IAnnotationBinding && (iAnnotationBinding = (IAnnotationBinding)iBinding).getAnnotationType().getQualifiedName().equals(string)) {
                    if (string2 == null) {
                        return 1;
                    }
                    int n9 = JavaHelper.a(iAnnotationArray[n7].getMemberValuePairs(), string2, string3, bl);
                    if (n9 > 0) {
                        if (n9 == 3) {
                            return 3;
                        }
                        n2 = n9;
                    }
                }
                ++n7;
                ++n4;
            }
            return n2;
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return n2;
    }

    private static int a(IMemberValuePair[] iMemberValuePairArray, String string, String string2, boolean bl) {
        int n2 = 0;
        IMemberValuePair[] iMemberValuePairArray2 = iMemberValuePairArray;
        int n3 = iMemberValuePairArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IMemberValuePair iMemberValuePair = iMemberValuePairArray2[n4];
            if (string.equals(iMemberValuePair.getMemberName())) {
                if (string2 == null) {
                    return 2;
                }
                Object object = iMemberValuePair.getValue();
                if (object != null && object.toString().equals(string2)) {
                    return 3;
                }
                if (bl && string2.equals("*")) {
                    n2 = 2;
                }
            }
            ++n4;
        }
        return n2;
    }

    public static boolean hasAnnotation(IType iType, String string) {
        try {
            return JavaHelper.getAnnotationsMatch(iType.getAnnotations(), string, null, null, false) != 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static String nonFQN(String string) {
        int n2 = string.lastIndexOf(46);
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkAnnotation(IType iType, String string, String string2, String string3) {
        try {
            switch (JavaHelper.getAnnotationsMatch(iType.getAnnotations(), string, string2, string3, false)) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    if (string2 == null) {
                        return null;
                    }
                    String string4 = JavaHelper.nonFQN(string);
                    return "Class '" + iType.getTypeQualifiedName('.') + "' has the annotation '@" + string4 + "' but is missing a back-reference to the Class Reference: it should refer back to '" + string3 + "', i.e. '@" + string4 + "(" + string2 + " = \"" + string3 + "\")'";
                }
                case 3: {
                    return null;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        Object object = JavaHelper.nonFQN(string);
        if (string2 != null) {
            object = (String)object + "(" + string2 + " = \"" + string3 + "\")";
        }
        return "Class '" + iType.getTypeQualifiedName('.') + "' must be annotated with '@" + (String)object + "'";
    }

    public static boolean hasAnnotation(IMethod iMethod, String string, String string2, String string3) {
        int n2;
        block5: {
            block4: {
                try {
                    n2 = JavaHelper.getAnnotationsMatch(iMethod.getAnnotations(), string, string2, string3, false);
                    if (string2 != null || n2 <= 0) break block4;
                    return true;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            if (string3 != null || n2 <= 1) break block5;
            return true;
        }
        return n2 == 3;
    }

    public static IMethod getAnnotatedMethod(IType iType, String string, String string2) {
        try {
            IMethod[] iMethodArray = iType.getMethods();
            int n2 = iMethodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IMethod iMethod = iMethodArray[n3];
                if (iMethod.getElementName().equals(string) && (string2 == null || JavaHelper.getAnnotationsMatch(iMethod.getAnnotations(), string2, null, null, false) != 0)) {
                    return iMethod;
                }
                ++n3;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public static MethodLookup validateMethod(IType iType, String string, boolean bl, String string2, String string3, String string4, boolean bl2) {
        MethodLookup methodLookup = new MethodLookup();
        try {
            Object object;
            if (string2 == null) {
                boolean bl3 = false;
                IMethod[] iMethodArray = iType.getMethods();
                int n2 = iMethodArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IMethod iMethod = iMethodArray[n3];
                    if (iMethod.getElementName().equals(string)) {
                        bl3 = true;
                        if (Flags.isStatic((int)iMethod.getFlags()) == bl) {
                            methodLookup.element = iMethod;
                            return methodLookup;
                        }
                    }
                    ++n3;
                }
                methodLookup.msg = !bl3 ? "Method '" + string + "' not found in class '" + iType.getFullyQualifiedName('.') + "'" : (bl ? "Non-static method '" + string + "' found in class '" + iType.getFullyQualifiedName('.') + "'" : "Static method '" + string + "' found in class '" + iType.getFullyQualifiedName('.') + "'");
                methodLookup.element = iType;
                return methodLookup;
            }
            Object object2 = null;
            Object object3 = null;
            int n4 = 0;
            IMethod[] iMethodArray = iType.getMethods();
            int n5 = iMethodArray.length;
            int n6 = 0;
            while (n6 < n5) {
                object = iMethodArray[n6];
                if (object.getElementName().equals(string) && Flags.isStatic((int)object.getFlags()) == bl) {
                    int n7 = JavaHelper.getAnnotationsMatch(object.getAnnotations(), string2, string3, string4, bl2 && bl);
                    if (n7 == 3) {
                        methodLookup.element = object;
                        return methodLookup;
                    }
                    if (n7 == 1) {
                        if (string3 == null) {
                            methodLookup.element = object;
                            return methodLookup;
                        }
                        if (n4 == 0) {
                            n4 = 1;
                            object2 = object;
                        }
                    } else if (n7 == 2 && n4 != 2) {
                        object2 = object;
                        n4 = 2;
                    }
                    if (object3 == null && n7 > 0) {
                        object3 = object;
                    }
                }
                ++n6;
            }
            if (object3 == null) {
                methodLookup.msg = "Method '" + string + "' is not found in class '" + iType.getFullyQualifiedName('.') + "'";
                methodLookup.element = iType;
            } else if (object2 == null) {
                methodLookup.msg = "Method '" + string + "' in class '" + iType.getFullyQualifiedName('.') + "' must be annotated with '@" + JavaHelper.nonFQN(string2) + "'";
                methodLookup.element = object3;
            } else {
                object = JavaHelper.nonFQN(string2);
                methodLookup.msg = "Method '" + string + "' in class '" + iType.getFullyQualifiedName('.') + "' has the annotation '@" + (String)object + "' but is missing a back-reference to the Method Reference: it should refer back to '" + string4 + "', i.e. '@" + (String)object + "(" + string3 + " = \"" + string4 + "\")'";
                methodLookup.element = object2;
            }
        }
        catch (JavaModelException javaModelException) {
            methodLookup.msg = "Failed looking up methods in class '" + iType.getFullyQualifiedName('.') + "'";
        }
        return methodLookup;
    }

    public static CompilationUnit getSharedAST(ITypeRoot iTypeRoot) {
        return SharedASTProvider.getAST((ITypeRoot)iTypeRoot, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASTParser getASTParser(IJavaProject iJavaProject, int n2) {
        Object object;
        if (n2 < 0) {
            object = iJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 8;
            }
        }
        n2 = Math.min(Math.max(n2, 8), 15);
        object = null;
        Thread thread = Thread.currentThread();
        Method method = a;
        synchronized (method) {
            HashMap<Integer, Object> hashMap = (HashMap<Integer, Object>)((HashMap)((Object)a)).get(thread);
            if (hashMap == null) {
                JavaHelper.a();
                hashMap = new HashMap<Integer, Object>(2);
                object = new a(n2);
                hashMap.put(n2, object);
                ((HashMap)((Object)a)).put(thread, hashMap);
            } else {
                object = (a)hashMap.get(n2);
                if (object == null) {
                    object = new a(n2);
                    hashMap.put(n2, object);
                }
            }
        }
        return ((a)object).a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearThreadCache() {
        Method method = a;
        synchronized (method) {
            ((HashMap)((Object)a)).remove(Thread.currentThread());
            JavaHelper.a();
        }
    }

    private static void a() {
        Iterator iterator = ((HashMap)((Object)a)).keySet().iterator();
        while (iterator.hasNext()) {
            if (((Thread)iterator.next()).isAlive()) continue;
            iterator.remove();
        }
    }

    public static IBinding[] createBindings(IJavaProject iJavaProject, IJavaElement[] iJavaElementArray) {
        block6: {
            try {
                IJavaElement iJavaElement;
                IJavaElement[] iJavaElementArray2 = iJavaElementArray;
                int n2 = iJavaElementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    iJavaElement = iJavaElementArray2[n3];
                    IResource iResource = iJavaElement.getResource();
                    if (iResource == null || iResource.isAccessible()) {
                        ++n3;
                        continue;
                    }
                    break block6;
                }
                if (iJavaProject == null && iJavaElementArray.length > 0) {
                    iJavaProject = iJavaElementArray[0].getJavaProject();
                }
                if (iJavaProject != null && iJavaProject.isOpen()) {
                    iJavaElement = JavaHelper.getASTParser(iJavaProject, -1);
                    iJavaElement.setProject(iJavaProject);
                    return iJavaElement.createBindings(iJavaElementArray, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                ILog.WARNING(JavaHelper.class, (String)("createBindings failed: " + string), (Throwable)throwable);
            }
        }
        return new IBinding[iJavaElementArray.length];
    }

    public static boolean hasJavaNature(IProject iProject) throws CoreException {
        if (!iProject.isAccessible()) {
            throw new CoreException((IStatus)Activator.createErrorStatus(ERR_PROJECT_CLOSED));
        }
        return iProject.hasNature("org.eclipse.jdt.core.javanature");
    }

    public static IJavaProject getJavaProject(IProject iProject) throws CoreException {
        if (!JavaHelper.hasJavaNature(iProject)) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Project is not of Java Nature"));
        }
        IProjectNature iProjectNature = iProject.getNature("org.eclipse.jdt.core.javanature");
        try {
            try {
                return (IJavaProject)iProjectNature;
            }
            catch (ClassCastException classCastException) {
                return JavaCore.create((IProject)iProject);
            }
        }
        catch (Throwable throwable) {
            throw new CoreException((IStatus)Activator.createErrorStatus(ERR_PROJECT_CLOSED, throwable));
        }
    }

    public static String getSimpleSignature(IMethod iMethod) {
        String string = null;
        IResource iResource = iMethod.getCompilationUnit().getResource();
        ParsedJavaSource parsedJavaSource = JavaManager.getInstance().getParsedJavaSource(iResource);
        if (parsedJavaSource != null) {
            string = parsedJavaSource.getSimpleSignature(iMethod);
        }
        if (string == null) {
            IBinding[] iBindingArray = JavaHelper.createBindings(null, new IJavaElement[]{iMethod});
            String string2 = string = iBindingArray[0] instanceof IMethodBinding ? JavaHelper.getSimpleSignature((IMethodBinding)iBindingArray[0], parsedJavaSource) : null;
            if (parsedJavaSource != null && string != null) {
                parsedJavaSource.saveSimpleSignature(iMethod, string);
            }
        }
        return string;
    }

    public static String getSimpleSignature(IMethodBinding iMethodBinding, ParsedJavaSource parsedJavaSource) {
        StringBuilder stringBuilder;
        String string = null;
        if (parsedJavaSource != null) {
            string = parsedJavaSource.getSimpleSignature(iMethodBinding);
        }
        if (string == null) {
            stringBuilder = new StringBuilder();
            if (!iMethodBinding.isConstructor()) {
                ITypeBinding iTypeBinding = iMethodBinding.getReturnType();
                if (iTypeBinding == null) {
                    return null;
                }
                stringBuilder.append(iTypeBinding.getQualifiedName());
            }
            stringBuilder.append('(');
            boolean bl = false;
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            int n2 = iTypeBindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITypeBinding iTypeBinding = iTypeBindingArray[n3];
                if (bl) {
                    stringBuilder.append(',');
                } else {
                    bl = true;
                }
                stringBuilder.append(iTypeBinding.getQualifiedName());
                ++n3;
            }
            stringBuilder.append(')');
            string = stringBuilder.toString();
        }
        if (parsedJavaSource != null && string != null) {
            parsedJavaSource.saveSimpleSignature(iMethodBinding, string);
            stringBuilder = iMethodBinding.getJavaElement();
            if (stringBuilder instanceof IMethod) {
                IMethod iMethod = (IMethod)stringBuilder;
                parsedJavaSource.saveSimpleSignature(iMethod, string);
            }
        }
        return string;
    }

    public static String getNonDesignerNamedClass(GProp<?> gProp) {
        String string = null;
        Class<?> clazz = gProp.getClass();
        while (clazz != null && (string = clazz.getCanonicalName()).startsWith("com.iizigo.")) {
            clazz = clazz.getSuperclass();
        }
        return string;
    }

    public static IFolder[] getSourceFolders(IJavaProject iJavaProject) throws JavaModelException {
        try {
            ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n2 = iClasspathEntryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
                if (iClasspathEntry.getEntryKind() == 3) {
                    arrayList.add(iWorkspaceRoot.getFolder(iClasspathEntry.getPath()));
                }
                ++n3;
            }
            return arrayList.toArray(new IFolder[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JavaModelException(new CoreException((IStatus)Activator.createErrorStatus("Failed getting source folders of project '" + iJavaProject.getProject().getName() + "'", illegalArgumentException)));
        }
    }

    public static ArrayList<IProject> getBuildPathProjects(IJavaProject iJavaProject) throws JavaModelException {
        try {
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n2 = iClasspathEntryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
                if (iClasspathEntry.getEntryKind() == 2) {
                    arrayList.add(iWorkspaceRoot.getProject(iClasspathEntry.getPath().toString().substring(1)));
                }
                ++n3;
            }
            return arrayList;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JavaModelException(new CoreException((IStatus)Activator.createErrorStatus("Failed getting build path projects from project '" + iJavaProject.getProject().getName() + "'", illegalArgumentException)));
        }
    }

    public static boolean isValidForSystem(IJavaElement iJavaElement) {
        if (iJavaElement instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
            IType iType = iCompilationUnit.findPrimaryType();
            try {
                return iType != null && iType.isClass();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }

    public static IJavaElement[] getSelection(ISelection iSelection) {
        LinkedHashSet<IJavaElement> linkedHashSet = new LinkedHashSet<IJavaElement>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e2 : iStructuredSelection) {
                IAdaptable iAdaptable;
                IJavaElement iJavaElement;
                if (e2 instanceof IJavaElement) {
                    IJavaElement iJavaElement2 = (IJavaElement)e2;
                    linkedHashSet.add(iJavaElement2);
                    continue;
                }
                if (!(e2 instanceof IAdaptable) || (iJavaElement = (IJavaElement)(iAdaptable = (IAdaptable)e2).getAdapter(IJavaElement.class)) == null) continue;
                linkedHashSet.add(iJavaElement);
            }
        }
        return linkedHashSet.isEmpty() ? EMPTY_JAVA_ELEMENTS : linkedHashSet.toArray(new IJavaElement[linkedHashSet.size()]);
    }

    public static TreeItemNavigatorPresentation createClassNodesTree(ModuleModel moduleModel, String string, String string2) {
        return JavaHelper.createClassNodesTree(moduleModel, string, string2, null, null);
    }

    public static TreeItemNavigatorPresentation createClassNodesTree(ModuleModel moduleModel, String string, String string2, String string3, TreeItemNavigatorPresentation[] treeItemNavigatorPresentationArray) {
        HashSet<IProject> hashSet = null;
        if (moduleModel != null) {
            hashSet = new HashSet<IProject>(Set.of(moduleModel.getProjectReferences(false)));
            hashSet.add(moduleModel.getProject());
        }
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Image image = applicationUI.getImage("java_package.gif");
        TreeItemNavigatorPresentation treeItemNavigatorPresentation = new TreeItemNavigatorPresentation("root");
        LinkedHashMap<IProject, b> linkedHashMap = new LinkedHashMap<IProject, b>();
        for (ParsedJavaSource parsedJavaSource : JavaManager.getInstance().getAllParsedSources()) {
            TreeItemNavigatorPresentation treeItemNavigatorPresentation2;
            IProject iProject = parsedJavaSource.sourceFile.getProject();
            if (hashSet != null && !hashSet.contains(iProject)) continue;
            b b2 = (b)linkedHashMap.get(iProject);
            if (b2 == null) {
                treeItemNavigatorPresentation2 = new TreeItemNavigatorPresentation(iProject.getName(), ProjectManager.getInstance().isRegistered(iProject) ? applicationUI.imageIizi : applicationUI.getImage("java_project.gif"));
                treeItemNavigatorPresentation.addChild(treeItemNavigatorPresentation2);
                b2 = new b(treeItemNavigatorPresentation2);
                linkedHashMap.put(iProject, b2);
            }
            treeItemNavigatorPresentation2 = b2.a;
            IzTypeDeclaration[] izTypeDeclarationArray = parsedJavaSource.getTypeFileProcessor().getTypes();
            int n2 = izTypeDeclarationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4;
                IzTypeDeclaration izTypeDeclaration = izTypeDeclarationArray[n3];
                IType iType = izTypeDeclaration.type;
                if (!(iType == null || (string4 = izTypeDeclaration.canInstantiate()) != null || string != null && (string4 = JavaHelper.validateClass(izTypeDeclaration.type, string)) != null || string2 != null && !izTypeDeclaration.hasAnnotation(string2))) {
                    String string5 = izTypeDeclaration.packageFQN;
                    TreeItemNavigatorPresentation treeItemNavigatorPresentation3 = (TreeItemNavigatorPresentation)((HashMap)((Object)treeItemNavigatorPresentation2)).get(string5);
                    if (treeItemNavigatorPresentation3 == null) {
                        treeItemNavigatorPresentation3 = new TreeItemNavigatorPresentation(string5, image);
                        ((HashMap)((Object)treeItemNavigatorPresentation2)).put(string5, treeItemNavigatorPresentation3);
                        b2.a.addChild(treeItemNavigatorPresentation3);
                    }
                    MemberTreeItemNavigatorPresentation memberTreeItemNavigatorPresentation = new MemberTreeItemNavigatorPresentation(izTypeDeclaration.getClassNameNoPackage(), applicationUI.imageClass, (IMember)izTypeDeclaration.type);
                    memberTreeItemNavigatorPresentation.attachment = iType;
                    treeItemNavigatorPresentation3.addChild(memberTreeItemNavigatorPresentation);
                    if (treeItemNavigatorPresentationArray != null && string3 != null && string3.equals(izTypeDeclaration.classFQN)) {
                        treeItemNavigatorPresentationArray[0] = memberTreeItemNavigatorPresentation;
                    }
                }
                ++n3;
            }
        }
        treeItemNavigatorPresentation.sortChildren(true, null);
        return treeItemNavigatorPresentation;
    }

    public static TreeItemNavigatorPresentation createMethodTree(ModuleModel moduleModel, String string, boolean bl, String string2) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        for (ParsedJavaSource parsedJavaSource : JavaManager.getInstance().getAllParsedSources()) {
            IzTypeDeclaration[] izTypeDeclarationArray = parsedJavaSource.getTypeFileProcessor().getTypes();
            int n2 = izTypeDeclarationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IzTypeDeclaration izTypeDeclaration = izTypeDeclarationArray[n3];
                if (string.equals(izTypeDeclaration.classFQN)) {
                    ArrayList<IzMethodDeclaration> arrayList = izTypeDeclaration.getMethods(bl, string2);
                    if (arrayList.isEmpty()) {
                        return null;
                    }
                    MemberTreeItemNavigatorPresentation memberTreeItemNavigatorPresentation = new MemberTreeItemNavigatorPresentation(string, applicationUI.imageClass, (IMember)izTypeDeclaration.type);
                    Image image = null;
                    for (IzMethodDeclaration izMethodDeclaration : arrayList) {
                        if (image == null) {
                            image = applicationUI.getImage(string2 != null ? "java_listener_method.gif" : "java_method_public.gif");
                        }
                        MemberTreeItemNavigatorPresentation memberTreeItemNavigatorPresentation2 = new MemberTreeItemNavigatorPresentation(izMethodDeclaration.name, image, (IMember)izMethodDeclaration.method);
                        memberTreeItemNavigatorPresentation2.attachment = izMethodDeclaration;
                        memberTreeItemNavigatorPresentation.addChild(memberTreeItemNavigatorPresentation2);
                    }
                    memberTreeItemNavigatorPresentation.sortChildren(true, null);
                    return memberTreeItemNavigatorPresentation;
                }
                ++n3;
            }
        }
        return null;
    }

    public static String selectClassName(Shell shell, ModuleModel moduleModel, String string, String string2, String string3) {
        IValidateSelection iValidateSelection = object -> {
            if (object instanceof TreeItemNavigatorPresentation) {
                TreeItemNavigatorPresentation treeItemNavigatorPresentation = (TreeItemNavigatorPresentation)object;
                if (treeItemNavigatorPresentation.attachment != null) {
                    return true;
                }
            }
            return false;
        };
        TreeItemNavigatorPresentation[] treeItemNavigatorPresentationArray = new TreeItemNavigatorPresentation[1];
        TreeItemNavigatorPresentation treeItemNavigatorPresentation = JavaHelper.createClassNodesTree(moduleModel, string, string2, string3, treeItemNavigatorPresentationArray);
        Object object2 = new SelectCNDialog(shell, "Select existing class", ApplicationUI.getInstance().imageClass, treeItemNavigatorPresentation, null, null, 4, null, iValidateSelection, treeItemNavigatorPresentationArray[0]).open();
        return iValidateSelection.isAccepted(object2) ? ((IType)((TreeItemNavigatorPresentation)object2).attachment).getFullyQualifiedName('.') : null;
    }

    private static class a {
        private final ASTParser a;

        private a(int n2) {
            this.a = ASTParser.newParser((int)n2);
            this.a.setResolveBindings(true);
            this.a.setBindingsRecovery(true);
            this.a.setStatementsRecovery(true);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class b {
        private final TreeItemNavigatorPresentation a;
        private final HashMap<String, TreeItemNavigatorPresentation> a = new HashMap();

        private b(TreeItemNavigatorPresentation treeItemNavigatorPresentation) {
            this.a = treeItemNavigatorPresentation;
        }
    }
}

