/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.validator.ControlValidator;
import com.iizigo.validator.IValidationMessage;
import com.iizigo.validator.ValidatorManager;
import com.iizix.jdbc.DBServerState;
import com.iizix.jdbc.DerbyImpl;
import java.io.File;
import org.apache.commons.validator.routines.DomainValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InternalDatabasePreferencePage
extends PreferencePage
implements IValidationMessage,
IWorkbenchPreferencePage {
    private final ValidatorManager a;
    private final DomainValidator a;
    private final ApplicationUI a;
    private final File a;
    private IPreferenceStore a;
    private DBServerState a;
    private Throwable a;
    private Label a;
    private Text a;
    private Spinner a;
    private Text b;
    private Button a;
    private Button b;
    private Button c;
    private String a;
    private String b;
    private int a;
    private boolean a = new ValidatorManager(this);
    private boolean b;
    private boolean c;
    private static volatile /* synthetic */ int[] a;

    public void init(IWorkbench iWorkbench) {
        Activator activator = Activator.getInstance();
        this.a = activator.getPreferenceStore();
        this.setPreferenceStore(this.a);
        this.a = activator.getDatabaseDirectoryCandidate().getPath();
        this.b = this.a.getString("db_address");
        this.a = this.a.getInt("db_port");
        this.a = this.a.getBoolean("db_autostart");
        this.b = this.a.getBoolean("db_autostop");
    }

    protected Control createContents(Composite composite) {
        int n2 = this.a.s10();
        int n3 = n2 / 2;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = n2;
        gridLayout.verticalSpacing = n3;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        gridData.widthHint = this.a.cx(250);
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        label.setText("Derby Network Database Server settings for IIZI.");
        gridData = new GridData(16384, 16384, false, false);
        gridData.verticalIndent = n2;
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("&Directory:");
        label.setToolTipText("Root directory for databases");
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = n2;
        this.b = new Text(composite2, 2052);
        this.b.setLayoutData((Object)gridData);
        this.b.setText(this.a);
        this.b.setToolTipText("The root directory where Derby databases will be created");
        ControlValidator controlValidator2 = this.a.newValidator(this.b, "Database directory", true);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            if (string.isEmpty()) {
                return false;
            }
            try {
                new File(string).toPath();
            }
            catch (Exception exception) {
                controlValidator.setWarningMessage("Database directory is not valid: " + exception.getMessage());
                return false;
            }
            return true;
        });
        gridData = new GridData(16384, 16384, false, false);
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("&Address:");
        label.setToolTipText("Bind Address, default \"localhost\"");
        gridData = new GridData(4, 0x1000000, true, false);
        this.a = new Text(composite2, 2052);
        this.a.setLayoutData((Object)gridData);
        this.a.setText(this.b);
        this.a.setToolTipText("There is real need to set the bind address as only\n\"local\" or \"loopback\" addresses are used,\ndefault is \"localhost\".");
        controlValidator2 = this.a.newValidator(this.a, "Bind address:", false);
        controlValidator2.setType(36);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            if (!string.isEmpty() && !this.a.isValid(string)) {
                controlValidator.setWarningMessage("Not a valid address or host name");
            }
            return true;
        });
        String string2 = "Specifies the port number between 1 and 65535, default is 1527";
        gridData = new GridData(4, 0x1000000, false, false);
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("&Port:");
        label.setToolTipText(string2);
        gridData = new GridData(16384, 0x1000000, false, false);
        this.a = new Spinner(composite2, 2048);
        this.a.setLayoutData((Object)gridData);
        this.a.setToolTipText(string2);
        this.a.newValidator(this.a, "Port number", 1, 65535, this.a, 5);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.verticalIndent = n2;
        label = new Label(composite2, 258);
        label.setLayoutData((Object)gridData);
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.verticalIndent = n3;
        gridData.horizontalIndent = n3;
        this.a = new Button(composite2, 32);
        this.a.setLayoutData((Object)gridData);
        this.a.setText("&Start server when iiziGo starts");
        this.a.setSelection(this.a);
        gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        gridData.horizontalIndent = n3;
        this.b = new Button(composite2, 32);
        this.b.setLayoutData((Object)gridData);
        this.b.setText("St&op server when iiziGo stops");
        this.b.setSelection(this.b);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.verticalIndent = n3;
        label = new Label(composite2, 258);
        label.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.verticalIndent = n3;
        label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText("State:");
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = n3;
        this.a = new Label(composite2, 0);
        this.a.setLayoutData((Object)gridData);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = n3;
        Link link = new Link(composite2, 0);
        link.setLayoutData((Object)gridData);
        link.setToolTipText("Click here to check if database server is connectable");
        link.setText("<a href=\"p\">A&ction</a>:");
        link.addListener(13, event -> this.b());
        int n4 = this.a.cx(80);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = n3;
        gridData.widthHint = n4;
        this.c = new Button(composite2, 8);
        this.c.setLayoutData((Object)gridData);
        this.c.addListener(13, event -> this.a());
        Runnable runnable = () -> {
            String string = this.a();
        };
        DerbyImpl.addServerStateListener((Runnable)runnable);
        this.a();
        composite2.addListener(12, event -> {
            boolean bl = DerbyImpl.removeServerStateListener((Runnable)runnable);
        });
        return composite2;
    }

    private String a() {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.a = DerbyImpl.getServerState();
        switch (InternalDatabasePreferencePage.a()[this.a.ordinal()]) {
            case 6: {
                object = "Connectable to port " + this.a.getSelection();
                bl = true;
                break;
            }
            case 7: {
                object = "Connection failed to port " + this.a.getSelection();
                break;
            }
            case 8: {
                object = "Invalid host";
                break;
            }
            case 1: {
                object = "Started on port %i";
                bl = true;
                break;
            }
            case 3: {
                object = "Starting on port %i";
                bl2 = true;
                break;
            }
            case 5: {
                object = "Failed starting on port %i";
                bl4 = true;
                break;
            }
            case 2: {
                object = "Stopped on port %i";
                break;
            }
            case 4: {
                object = "Stopping on port %i";
                bl3 = true;
                break;
            }
            default: {
                object = "Unknown state";
                bl4 = true;
            }
        }
        boolean bl5 = this.a.validate();
        this.c = bl || bl2;
        this.c.setText(this.c ? "Stop" : "Start");
        this.c.setEnabled(bl5 && !bl2 && !bl3);
        object = ((String)object).replace("%i", Integer.toString(DerbyImpl.getServerPort()));
        this.a.setText((String)object);
        this.a.setToolTipText((String)object);
        if (bl5) {
            this.setErrorMessage((String)(bl4 ? object : null));
        }
        return object;
    }

    protected void performDefaults() {
        this.a.setSelection(1527);
        this.a.setText("localhost");
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        return this.a.isValidAndComplete();
    }

    public boolean performCancel() {
        return true;
    }

    @Override
    public void onValidate(boolean bl) {
        this.setValid(bl);
    }

    private void a() {
        if (!this.c.isEnabled()) {
            return;
        }
        if (this.c) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
                try {
                    this.a = DerbyImpl.stopServer((File)this.a);
                }
                catch (Throwable throwable) {
                    this.a = throwable;
                }
            });
            if (this.a != null) {
                Activator.openError(this.getShell(), "Stop Database Server", "Failed stopping database server.", this.a);
            } else if (this.a != DBServerState.STOPPED) {
                Activator.openError(this.getShell(), "Stop Database Server", "Failed stopping database server: " + this.a());
            }
        } else {
            File file = new File(this.b.getText());
            int n2 = this.a.getSelection();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
                try {
                    this.a = DerbyImpl.startServer((File)this.a, (File)file, (int)n2);
                }
                catch (Throwable throwable) {
                    this.a = throwable;
                }
            });
            if (this.a != null) {
                Activator.openError(this.getShell(), "Start Database Server", "Failed starting database server.", this.a);
            } else if (this.a != DBServerState.STARTED) {
                Activator.openError(this.getShell(), "Start Database Server", "Failed starting database server: " + this.a());
            }
        }
    }

    private void b() {
        int n2 = this.a.getSelection();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            try {
                this.a = DerbyImpl.isSocketConnectable((String)"localhost", (int)n2, (int)10000, null);
            }
            catch (Throwable throwable) {
                this.a = throwable;
            }
        });
        if (this.a != null) {
            Activator.openError(this.getShell(), "Check Connection to Database Server", "Failed checking connection to database server.", this.a);
        } else if (this.a != DBServerState.CONNECTABLE) {
            Activator.openError(this.getShell(), "Check Connection to Database Server", "Failed checking connection to database server: " + this.a());
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[DBServerState.values().length];
        try {
            nArray[DBServerState.CONNECTABLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.CONNECTION_FAILED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.INVALID_HOST.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STARTING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.START_FAILED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STOPPED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.STOPPING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBServerState.UNKNOWN.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

