/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.tabnine.eclipse.shared.api.binary.BinaryProcessRequester;
import com.tabnine.eclipse.shared.api.binary.BinaryRequest;
import com.tabnine.eclipse.shared.api.binary.ParsedBinaryIO;
import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineDeadException;
import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineInvalidResponseException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryProcessRequesterImpl
implements BinaryProcessRequester {
    static Logger logger = LogManager.getLogger(BinaryProcessRequesterImpl.class);
    public static final String BINARY_PROTOCOL_VERSION = "4.4.223";
    public static final int ILLEGAL_RESPONSE_THRESHOLD = 5;
    private int illegalResponsesGiven = 0;
    private final ParsedBinaryIO parsedBinaryIO;

    public BinaryProcessRequesterImpl(ParsedBinaryIO parsedBinaryIO) {
        this.parsedBinaryIO = parsedBinaryIO;
    }

    @Override
    public synchronized <R> R request(BinaryRequest<R> binaryRequest) {
        if (this.parsedBinaryIO.isDead()) {
            throw new TabNineDeadException("Binary is dead");
        }
        try {
            this.parsedBinaryIO.writeRequest(BinaryProcessRequesterImpl.wrapWithBinaryRequest(binaryRequest.serialize()));
            return this.readResult(binaryRequest);
        }
        catch (IOException iOException) {
            logger.warn("Exception communicating with the binary", (Throwable)iOException);
            throw new TabNineDeadException(iOException);
        }
    }

    @Override
    public Long pid() {
        return this.parsedBinaryIO.pid();
    }

    @Override
    public void destroy() {
        this.parsedBinaryIO.destroy();
    }

    private <R> R readResult(BinaryRequest<R> binaryRequest) {
        try {
            R r2 = this.parsedBinaryIO.readResponse(binaryRequest.response());
            if (!binaryRequest.validate(r2)) {
                throw new TabNineInvalidResponseException();
            }
            this.illegalResponsesGiven = 0;
            return r2;
        }
        catch (TabNineInvalidResponseException tabNineInvalidResponseException) {
            if (binaryRequest.shouldBeAllowed(tabNineInvalidResponseException)) {
                return null;
            }
            if (++this.illegalResponsesGiven > 5) {
                this.illegalResponsesGiven = 0;
                throw new TabNineDeadException("Too many illegal responses given");
            }
            logger.warn((Object)tabNineInvalidResponseException);
            return null;
        }
    }

    public static Map<String, Object> wrapWithBinaryRequest(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("version", BINARY_PROTOCOL_VERSION);
        hashMap.put("request", object);
        return hashMap;
    }
}

