/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.correction.java.AddPdeClasspathContainerClasspathFixProposal;
import org.eclipse.pde.internal.ui.correction.java.FindClassResolutionsOperation;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class UnresolvedImportFixProcessor
extends ClasspathFixProcessor {
    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String name) throws CoreException {
        if (!WorkspaceModelManager.isPluginProject((IProject)project.getProject())) {
            IFile bnd = project.getProject().getFile("bnd.bnd");
            if (bnd.exists()) {
                return new ClasspathFixProcessor.ClasspathFixProposal[]{new AddPdeClasspathContainerClasspathFixProposal(project)};
            }
            return new ClasspathFixProcessor.ClasspathFixProposal[0];
        }
        ClasspathFixCollector collector = new ClasspathFixCollector();
        FindClassResolutionsOperation findOperation = new FindClassResolutionsOperation(project.getProject(), name, collector);
        findOperation.run((IProgressMonitor)new NullProgressMonitor());
        return (ClasspathFixProcessor.ClasspathFixProposal[])collector.proposals.toArray(ClasspathFixProcessor.ClasspathFixProposal[]::new);
    }

    private static class ClasspathFixCollector
    extends FindClassResolutionsOperation.AbstractClassResolutionCollector {
        private final List<ClasspathFixProcessor.ClasspathFixProposal> proposals = new ArrayList<ClasspathFixProcessor.ClasspathFixProposal>();

        private ClasspathFixCollector() {
        }

        @Override
        public void addResolutionModification(IProject project, ExportPackageDescription desc, CompilationUnit cu, String typeToImport) {
            BundleDescription exporter = desc.getExporter();
            if (exporter == null) {
                return;
            }
            JavaResolutionFactory.AbstractManifestChange<BundleDescription> change = JavaResolutionFactory.createRequireBundleChange(project, exporter, cu, typeToImport);
            ClasspathFixProcessor.ClasspathFixProposal proposal = JavaResolutionFactory.createClasspathFixProposal(change, 16);
            this.proposals.add(proposal);
        }
    }
}

