/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class BigDecimalValue
extends NumberValue<BigDecimal> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.BigDecimal;
    }

    @Override
    public Class<BigDecimal> getValueClass() {
        return BigDecimal.class;
    }

    @Override
    public String getDescription() {
        return "Arbitrary-precision signed decimal number";
    }

    @Override
    public BigDecimal createDefault() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal parse(String string) throws NumberFormatException {
        return new BigDecimal(string);
    }

    @Override
    public BigDecimal convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Double) {
                return new BigDecimal((Double)object);
            }
            if (object instanceof Float) {
                return new BigDecimal(((Float)object).floatValue());
            }
            return BigDecimal.valueOf(((Number)object).longValue());
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return BigDecimal.valueOf(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

