/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.device;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.FolderSettingsProp;
import com.iizix.prop.FolderURIPropCnr;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ui.UIPanelBase;
import com.iizix.prop.ui.device.GThemes;

public class ThemesProp
extends GProp<GThemes> {
    private static final Class<?>[] a = new Class[]{GThemes.class, String.class};

    public ThemesProp() {
    }

    public ThemesProp(Atom atom) {
        super(atom);
    }

    public ThemesProp(Atom atom, GThemes gThemes) {
        super(atom);
        this.setPropValue(gThemes);
    }

    @Override
    protected boolean isPropPrivateAtCreation() {
        return true;
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(GThemes gThemes) {
        try {
            return super.setPropValue(gThemes);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof GThemes)) {
            throw new PropTypeException(this, "newValue not GThemes");
        }
        if (GThemes.NONE.equals(object)) {
            throw new PropTypeException(this, "newValue cannot be GThemes.NONE");
        }
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        GThemes gThemes = (GThemes)object;
        if (gThemes == null) {
            gThemes = GThemes.DEFAULT_DESKTOP;
        }
        gThemes.append(sendTransaction);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        GThemes gThemes = GThemes.from(readTransaction);
        return this.setPropValue((Object)gThemes, propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            return GThemes.from(string);
        }
        catch (Exception exception) {
            throw new PropException(this, "fromElementString error: " + String.valueOf(exception), exception);
        }
    }

    @Override
    public String toElementString(Object object) {
        return ((GThemes)object).dataToString();
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return ((GThemes)object).dataToString();
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return GThemes.from((String)object);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        GThemes gThemes = (GThemes)this.getPropValue();
        if (gThemes != null) {
            FolderURIPropCnr folderURIPropCnr;
            PropCnr propCnr = this.getParent();
            if (propCnr instanceof UIPanelBase) {
                GThemes gThemes2;
                String string;
                if ((propCnr = propCnr.getParent()) instanceof FileURIPropCnr) {
                    propCnr = propCnr.getParent();
                }
                if (propCnr instanceof FolderURIPropCnr && (string = gThemes.verify(gThemes2 = ((FolderURIPropCnr)propCnr).getThemesMask(null))) != null) {
                    propVerification.add(new PropVerificationError("themes", PropVerificationError.Severity.WARNING, "Themes", this, "Selected panel designed themes mismatch -- " + string, new String[0]));
                }
            } else if (propCnr instanceof FolderSettingsProp && (folderURIPropCnr = propCnr.getParent(FolderURIPropCnr.class)) != null && (gThemes = folderURIPropCnr.getThemesMask(gThemes)) != null && gThemes.isNullMask()) {
                propVerification.add(new PropVerificationError("themes", PropVerificationError.Severity.WARNING, "Themes", this, "Possible themes selection for panels becomes null", new String[0]));
            }
        }
        return true;
    }
}

