/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.os;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.os.b;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ThreadDeadlockDetector {
    private static final ThreadMXBean a = ManagementFactory.getThreadMXBean();
    private static Timer a;

    public static ThreadMXBean getThreadMXBean() {
        return a;
    }

    public static boolean startDeadlockCheck() {
        return ThreadDeadlockDetector.startDeadlockCheck(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startDeadlockCheck(long l2) {
        Class<ThreadDeadlockDetector> clazz = ThreadDeadlockDetector.class;
        synchronized (ThreadDeadlockDetector.class) {
            Timer timer;
            block4: {
                if (a == null) break block4;
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return false;
            }
            a = timer = new Timer(true);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            ILog.INFO(ThreadDeadlockDetector.class, "Deadlock detection started: checking interval is " + Utilities.formatEnglishDuration(l2));
            timer.scheduleAtFixedRate((TimerTask)new b(), new Date(), l2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stopDeadlockCheck() {
        Class<ThreadDeadlockDetector> clazz = ThreadDeadlockDetector.class;
        synchronized (ThreadDeadlockDetector.class) {
            block4: {
                if (a != null) break block4;
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            a.cancel();
            a = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            ILog.INFO(ThreadDeadlockDetector.class, "Deadlock detection stopped");
            return true;
        }
    }

    public static void checkForDeadlocks() {
        ThreadMXBean threadMXBean = ThreadDeadlockDetector.getThreadMXBean();
        try {
            ThreadDeadlockDetector.a(threadMXBean, threadMXBean.findDeadlockedThreads());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ThreadDeadlockDetector.a(threadMXBean, threadMXBean.findMonitorDeadlockedThreads());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void a(ThreadMXBean threadMXBean, long[] lArray) {
        if (lArray != null && lArray.length > 0) {
            Thread[] threadArray = new Thread[lArray.length];
            int n2 = 0;
            while (n2 < threadArray.length) {
                threadArray[n2] = ThreadDeadlockDetector.a(threadMXBean.getThreadInfo(lArray[n2]));
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder("DEADLOCKED THREADS DETECTED: count = ").append(threadArray.length).append('\n');
            int n3 = 0;
            while (n3 < threadArray.length) {
                Thread thread = threadArray[n3];
                if (thread == null) {
                    stringBuilder.append("\n - Unknown thread ID " + lArray[n3]);
                } else {
                    stringBuilder.append("\n - Thread: " + String.valueOf(thread));
                    StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                    int n4 = stackTraceElementArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        StackTraceElement stackTraceElement = stackTraceElementArray[n5];
                        stringBuilder.append("\n     " + String.valueOf(stackTraceElement));
                        ++n5;
                    }
                }
                ++n3;
            }
            ILog.SEVERE(ThreadDeadlockDetector.class, stringBuilder.toString());
        }
    }

    private static Thread a(ThreadInfo threadInfo) {
        long l2 = threadInfo.getThreadId();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.threadId() != l2) continue;
            return thread;
        }
        return null;
    }
}

