/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.iizix.SessionInfo;
import com.iizix.comm.IServerWebSocketCommListener;
import com.iizix.nio.IWebSocketComm;
import com.iizix.server.ServerShell;
import com.iizix.virtual.ThreadGroupType;

public interface IEndPoint {
    public static final String STORAGE_NAME = IEndPoint.class.getName();
    public static final long DEFAULT_HEARTBEAT_INTERVAL = 15000L;

    public static IEndPoint getSessionInstance() {
        SessionInfo sessionInfo = SessionInfo.getSessionInfo();
        return sessionInfo != null ? (IEndPoint)sessionInfo.getPrivateData(STORAGE_NAME, IEndPoint.class) : null;
    }

    public Type getEndPointType();

    public String getEndPointName();

    public long getServerSessionID();

    public SessionInfo getSessionInfo();

    public ServerShell getServer();

    public IServerWebSocketCommListener getWebSocketCommListener(IWebSocketComm var1);

    public boolean dispose();

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static enum Type {
        SERVER("Server", ThreadGroupType.SERVER_SESSION),
        EDITOR("Designer", ThreadGroupType.CLIENT_SESSION),
        JAVA_CLIENT("Java client", ThreadGroupType.CLIENT_SESSION),
        JAVASCRIPT_CLIENT("JavaScript client", ThreadGroupType.CLIENT_SESSION),
        VS_VIEWER("VirtualSpace Viewer", ThreadGroupType.VSVIEWER_SESSION),
        LICENSE_MANAGER("License Manager", ThreadGroupType.SERVER_SESSION),
        REMOTE("Server Monitor", ThreadGroupType.SERVER_SESSION),
        EXTERNAL_MODULE("External Server Module", ThreadGroupType.SERVER_SESSION);

        private final String a;
        private final ThreadGroupType a;

        private Type(String string2, ThreadGroupType threadGroupType) {
            this.a = string2;
            this.a = threadGroupType;
        }

        public String getDescription() {
            return this.a;
        }

        public ThreadGroupType getThreadGroupType() {
            return this.a;
        }
    }
}

